/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.enforcer.copyright;

import io.helidon.build.common.logging.Log;
import io.helidon.build.maven.enforcer.FileRequest;
import io.helidon.build.maven.enforcer.RuleFailureException;
import io.helidon.build.maven.enforcer.copyright.Copyright;
import io.helidon.build.maven.enforcer.copyright.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public abstract class TemplateLine {
    public static List<TemplateLine> parseTemplate(Validator.ValidatorConfig config, List<String> lines) {
        ArrayList<TemplateLine> templateLines = new ArrayList<TemplateLine>(lines.size() + 1);
        boolean hasCopyright = false;
        for (String line : lines) {
            if (line.contains("YYYY")) {
                templateLines.add(new CopyrightLine(config, line));
                hasCopyright = true;
                continue;
            }
            if (line.isBlank()) {
                templateLines.add(new BlankLine());
                continue;
            }
            templateLines.add(new TextLine(line));
        }
        if (!hasCopyright) {
            templateLines.add(0, new CopyrightLine(config));
        }
        return templateLines;
    }

    public abstract void validate(FileRequest var1, String var2, int var3) throws RuleFailureException;

    private static class CopyrightLine
    extends TemplateLine {
        private static final Pattern YEAR = Pattern.compile("\\d\\d\\d\\d ");
        private final String prefix;
        private final String licensor;
        private final String suffix;
        private final String yearSeparator;
        private final String logExpectedLine;
        private final int minLength;
        private final int prefixLength;
        private final int suffixLength;
        private final int licensorLength;
        private final int yearSeparatorLength;
        private final boolean checkFormatOnly;
        private final Pattern yearsPattern;
        private final CopyrightLine backup;
        private final String currentYear;

        private CopyrightLine(CopyrightLineSetup setup, CopyrightLineSetup backup) {
            this.prefix = setup.prefix;
            this.licensor = setup.licensor;
            this.suffix = setup.suffix;
            this.yearSeparator = setup.yearSeparator;
            String expectedLine = this.prefix + "YYYY[" + this.yearSeparator + "YYYY] " + this.licensor + this.suffix;
            this.logExpectedLine = Copyright.logGood(expectedLine);
            this.checkFormatOnly = setup.checkFormatOnly;
            this.prefixLength = this.prefix.length();
            this.licensorLength = this.licensor.length();
            this.suffixLength = this.suffix.length();
            this.yearSeparatorLength = this.yearSeparator.length();
            this.minLength = this.prefixLength + this.licensorLength + this.suffixLength + 5;
            this.yearsPattern = Pattern.compile("\\d\\d\\d\\d" + this.yearSeparator + "\\d\\d\\d\\d ");
            this.currentYear = setup.currentYear;
            this.backup = setup.licensor.contains("Oracle") ? (backup == null ? null : new CopyrightLine(backup, null)) : null;
        }

        CopyrightLine(Validator.ValidatorConfig config) {
            this(new CopyrightLineSetup(config, "Copyright (c) ", config.licensor(), "."), null);
        }

        CopyrightLine(Validator.ValidatorConfig config, String line) {
            this(CopyrightLine.parse(config, line), CopyrightLine.parse(config, line + " All rights reserved."));
        }

        private static CopyrightLineSetup parse(Validator.ValidatorConfig config, String line) {
            int yyyy = line.indexOf("YYYY");
            int dot = line.indexOf(".", yyyy);
            if (dot < 0) {
                dot = line.length();
            }
            return new CopyrightLineSetup(config, line.substring(0, yyyy), line.substring(yyyy + 5, dot), line.substring(dot));
        }

        @Override
        public void validate(FileRequest file, String actualLine, int lineNumber) {
            try {
                this.doValidate(file, actualLine, file.lastModifiedYear(), lineNumber);
            }
            catch (RuleFailureException e) {
                if (this.backup != null && !file.lastModifiedYear().equals(this.currentYear)) {
                    try {
                        this.backup.validate(file, actualLine, lineNumber);
                    }
                    catch (RuleFailureException ignored) {
                        throw e;
                    }
                }
                throw e;
            }
        }

        private void doValidate(FileRequest file, String actualLine, String expectedYear, int lineNumber) {
            String yearSection;
            if (actualLine.length() < this.minLength) {
                throw new RuleFailureException(file, lineNumber, "Line too short. Expected " + this.logExpectedLine + ", is " + Copyright.logBad(actualLine));
            }
            int lineLength = actualLine.length();
            String actualPrefix = actualLine.substring(0, this.prefixLength);
            int suffixStart = lineLength - this.suffixLength;
            int licensorStart = suffixStart - this.licensorLength;
            if (this.isYears(actualLine, this.prefixLength)) {
                yearSection = actualLine.substring(this.prefixLength, this.prefixLength + 10);
                licensorStart = this.prefixLength + 11;
            } else if (this.isYear(actualLine, this.prefixLength)) {
                yearSection = actualLine.substring(this.prefixLength, this.prefixLength + 4);
                licensorStart = this.prefixLength + 5;
            } else {
                yearSection = actualLine.substring(this.prefixLength, licensorStart).trim();
            }
            String actualSuffix = actualLine.substring(suffixStart, lineLength);
            String actualLicensor = actualLine.substring(licensorStart, suffixStart);
            if (!actualPrefix.equals(this.prefix)) {
                throw new RuleFailureException(file, lineNumber, "Wrong prefix. Expected " + this.logExpectedLine + ", is " + Copyright.logBad(actualPrefix));
            }
            if (!actualSuffix.equals(this.suffix)) {
                throw new RuleFailureException(file, lineNumber, "Wrong suffix. Expected " + this.logExpectedLine + ", is " + Copyright.logBad(actualSuffix));
            }
            if (!actualLicensor.equals(this.licensor)) {
                throw new RuleFailureException(file, lineNumber, "Wrong format. Expected " + Copyright.logGood(this.licensor) + ", is " + Copyright.logBad(actualLicensor));
            }
            if (yearSection.length() == 4) {
                this.validateYearFormat(file, lineNumber, actualLine, yearSection);
                if (!this.checkFormatOnly) {
                    Log.debug((String)("Expected year: " + expectedYear + ", actual year: " + yearSection), (Object[])new Object[0]);
                    this.validateYear(file, lineNumber, yearSection, expectedYear);
                }
            } else if (yearSection.length() == 8 + this.yearSeparatorLength) {
                String firstYear = yearSection.substring(0, 4);
                String actualSeparator = yearSection.substring(4, 4 + this.yearSeparatorLength);
                String secondYear = yearSection.substring(4 + this.yearSeparatorLength);
                this.validateYearFormat(file, lineNumber, actualLine, firstYear);
                this.validateYearFormat(file, lineNumber, actualLine, secondYear);
                if (!actualSeparator.equals(this.yearSeparator)) {
                    throw new RuleFailureException(file, lineNumber, "Wrong year separator. Expected  " + Copyright.logGood(this.yearSeparator) + ", is " + Copyright.logBad(actualSeparator) + ", on line " + Copyright.logBad(actualLine));
                }
                if (!this.checkFormatOnly) {
                    Log.debug((String)("Expected year: " + expectedYear + ", actual years: " + yearSection), (Object[])new Object[0]);
                    this.validateYear(file, lineNumber, firstYear, secondYear, expectedYear);
                }
            } else {
                throw new RuleFailureException(file, lineNumber, "Wrong year. Expected " + Copyright.logGood("yyyy" + this.yearSeparator + expectedYear) + ", is " + Copyright.logBad(yearSection));
            }
        }

        private boolean isYear(String actualLine, int prefixLength) {
            if (actualLine.length() >= prefixLength + 5) {
                String years = actualLine.substring(prefixLength, prefixLength + 5);
                return YEAR.matcher(years).matches();
            }
            return false;
        }

        private boolean isYears(String actualLine, int prefixLength) {
            if (actualLine.length() >= prefixLength + 11) {
                String years = actualLine.substring(prefixLength, prefixLength + 11);
                return this.yearsPattern.matcher(years).matches();
            }
            return false;
        }

        private void validateYear(FileRequest file, int lineNumber, String actualFrom, String actualTo, String expectedYear) {
            if (!actualTo.equals(expectedYear)) {
                throw new RuleFailureException(file, lineNumber, "Wrong year. Expected " + Copyright.logGood(actualFrom + this.yearSeparator + expectedYear) + ", is " + Copyright.logBad(actualFrom + this.yearSeparator + actualTo));
            }
        }

        private void validateYear(FileRequest file, int lineNumber, String actualYear, String expectedYear) {
            if (!actualYear.equals(expectedYear)) {
                throw new RuleFailureException(file, lineNumber, "Wrong year. Expected " + Copyright.logGood(actualYear + this.yearSeparator + expectedYear) + ", is " + Copyright.logBad(actualYear));
            }
        }

        void validateYearFormat(FileRequest file, int lineNumber, String line, String year) {
            try {
                Integer.parseInt(year);
            }
            catch (NumberFormatException e) {
                throw new RuleFailureException(file, lineNumber, "Wrong year format. Expected " + Copyright.logGood("4 digits") + ", is " + Copyright.logBad(year) + ", on line " + Copyright.logBad(line));
            }
        }

        private static class CopyrightLineSetup {
            private final String prefix;
            private final String licensor;
            private final String suffix;
            private final String yearSeparator;
            private final boolean checkFormatOnly;
            private final String currentYear;

            private CopyrightLineSetup(Validator.ValidatorConfig config, String prefix, String licensor, String suffix) {
                this.prefix = prefix;
                this.licensor = licensor;
                this.suffix = suffix;
                this.yearSeparator = config.yearSeparator();
                this.checkFormatOnly = config.checkFormatOnly();
                this.currentYear = config.currentYear();
            }
        }
    }

    private static class BlankLine
    extends TemplateLine {
        private BlankLine() {
        }

        @Override
        public void validate(FileRequest file, String actualLine, int lineNumber) {
            if (actualLine.isBlank()) {
                return;
            }
            throw new RuleFailureException(file, lineNumber, "Expected empty line, is " + Copyright.logBad(actualLine));
        }
    }

    private static class TextLine
    extends TemplateLine {
        private final String line;

        private TextLine(String line) {
            this.line = line;
        }

        @Override
        public void validate(FileRequest file, String actualLine, int lineNumber) {
            if (this.line.equals(actualLine)) {
                return;
            }
            throw new RuleFailureException(file, lineNumber, "Invalid line. Expected " + Copyright.logGood(this.line) + ", is " + Copyright.logBad(actualLine));
        }
    }
}

