/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.enforcer.copyright;

import io.helidon.build.maven.enforcer.FileRequest;
import io.helidon.build.maven.enforcer.RuleFailureException;
import java.nio.file.Path;
import java.util.Set;

public interface Validator {
    public Set<String> supportedSuffixes();

    default public boolean supports(Path path) {
        return false;
    }

    public void validate(FileRequest var1, Path var2) throws RuleFailureException;

    public static interface ValidatorConfig {
        public static Builder builder() {
            return new Builder();
        }

        public String yearSeparator();

        public boolean checkFormatOnly();

        public String licensor();

        public String currentYear();

        public static class Builder {
            private String yearSeparator = ", ";
            private boolean checkFormatOnly;
            private String defaultLicensor = "Oracle and/or its affiliates";
            private String currentYear;

            private Builder() {
            }

            public ValidatorConfig build() {
                return new ValidatorConfigImpl(this);
            }

            public Builder yearSeparator(String yearSeparator) {
                this.yearSeparator = yearSeparator;
                return this;
            }

            public Builder checkFormatOnly(boolean checkFormatOnly) {
                this.checkFormatOnly = checkFormatOnly;
                return this;
            }

            public Builder defaultLicensor(String defaultLicensor) {
                this.defaultLicensor = defaultLicensor;
                return this;
            }

            public Builder currentYear(String currentYear) {
                this.currentYear = currentYear;
                return this;
            }

            private static class ValidatorConfigImpl
            implements ValidatorConfig {
                private final String yearSeparator;
                private final boolean checkFormatOnly;
                private final String licensor;
                private final String currentYear;

                private ValidatorConfigImpl(Builder builder) {
                    this.yearSeparator = builder.yearSeparator;
                    this.checkFormatOnly = builder.checkFormatOnly;
                    this.licensor = builder.defaultLicensor;
                    this.currentYear = builder.currentYear;
                }

                @Override
                public String yearSeparator() {
                    return this.yearSeparator;
                }

                @Override
                public boolean checkFormatOnly() {
                    return this.checkFormatOnly;
                }

                @Override
                public String licensor() {
                    return this.licensor;
                }

                @Override
                public String currentYear() {
                    return this.currentYear;
                }
            }
        }
    }
}

