/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.enforcer.copyright;

import io.helidon.build.common.logging.Log;
import io.helidon.build.maven.enforcer.EnforcerException;
import io.helidon.build.maven.enforcer.FileRequest;
import io.helidon.build.maven.enforcer.RuleFailureException;
import io.helidon.build.maven.enforcer.copyright.Copyright;
import io.helidon.build.maven.enforcer.copyright.FileLine;
import io.helidon.build.maven.enforcer.copyright.TemplateLine;
import io.helidon.build.maven.enforcer.copyright.Validator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public abstract class ValidatorBase
implements Validator {
    private final List<TemplateLine> templateLines;
    private final String currentYear;

    protected ValidatorBase(Validator.ValidatorConfig validatorConfig, List<TemplateLine> templateLines) {
        this.templateLines = templateLines;
        this.currentYear = validatorConfig.currentYear();
    }

    @Override
    public boolean supports(Path path) {
        return false;
    }

    @Override
    public void validate(FileRequest file, Path path) {
        List<FileLine> copyrightComment;
        Log.verbose((String)("Processing file: " + path), (Object[])new Object[0]);
        try (BufferedReader br = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            copyrightComment = this.readComment(file, br);
        }
        catch (IOException e) {
            throw new EnforcerException("Failed to read file " + path, e);
        }
        if (copyrightComment.size() != this.templateLines.size()) {
            if (copyrightComment.isEmpty()) {
                throw new RuleFailureException(file, 0, "Expecting copyright with " + Copyright.logGood(String.valueOf(this.templateLines.size())) + " lines, but it was " + Copyright.logBad("empty"));
            }
            throw new RuleFailureException(file, copyrightComment.iterator().next().lineNumber(), "Expecting copyright with " + Copyright.logGood(String.valueOf(this.templateLines.size())) + " lines, but it contained " + Copyright.logBad(String.valueOf(copyrightComment.size())) + " lines");
        }
        for (int i = 0; i < copyrightComment.size(); ++i) {
            FileLine actualLine = copyrightComment.get(i);
            TemplateLine templateLine = this.templateLines.get(i);
            templateLine.validate(file, actualLine.line(), actualLine.lineNumber());
        }
    }

    protected List<FileLine> readComment(FileRequest file, BufferedReader reader) throws IOException {
        String line;
        int lineNumber = 0;
        while ((line = reader.readLine()) != null) {
            ++lineNumber;
            if (line.isBlank()) continue;
            if (!this.isPreamble(line.trim())) break;
            if (!this.copyrightBeforePreamble()) continue;
            return List.of();
        }
        if (line == null) {
            return List.of();
        }
        if (!this.isCommentStart(line.trim())) {
            throw new RuleFailureException(file, lineNumber, "No comment found");
        }
        ArrayList<FileLine> comment = new ArrayList<FileLine>();
        while ((line = reader.readLine()) != null) {
            ++lineNumber;
            if (this.supportsBlockComments() ? line.trim().startsWith(this.blockCommentEnd()) : !line.trim().startsWith(this.lineCommentStart().orElseThrow(() -> new EnforcerException("When block comment is not supported, line comment must be defined.")))) break;
            line = this.removeComment(file, line, lineNumber);
            comment.add(FileLine.create(lineNumber, line));
        }
        if (comment.isEmpty()) {
            throw new RuleFailureException(file, lineNumber, "No comment found");
        }
        if (this.allowLeadEmptyLine() && ((FileLine)comment.get(0)).line().isBlank()) {
            comment.remove(0);
        }
        if (this.allowTrailEmptyLine(file.lastModifiedYear()) && ((FileLine)comment.get(comment.size() - 1)).line().isBlank()) {
            this.containsTrailingEmptyLine(file);
            comment.remove(comment.size() - 1);
        }
        if (!this.supportsBlockComments() && ((FileLine)comment.get(comment.size() - 1)).line().isBlank()) {
            comment.remove(comment.size() - 1);
        }
        return comment;
    }

    protected void containsTrailingEmptyLine(FileRequest file) {
    }

    protected boolean allowLeadEmptyLine() {
        return false;
    }

    protected boolean allowTrailEmptyLine(String modifiedYear) {
        return false;
    }

    protected boolean copyrightBeforePreamble() {
        return true;
    }

    protected String removeComment(FileRequest file, String line, int lineNumber) {
        String lineComment;
        if (this.supportsBlockComments() && this.blockCommentPrefix().isPresent()) {
            String block = this.blockCommentPrefix().get();
            if (block.isBlank() || block.startsWith(" ")) {
                if (line.startsWith(block)) {
                    return line.substring(block.length());
                }
                if (line.isBlank()) {
                    return "";
                }
            } else {
                String trimmed = line.trim();
                if (trimmed.startsWith(block)) {
                    if (trimmed.length() == block.length()) {
                        return "";
                    }
                    if (trimmed.charAt(block.length()) != ' ') {
                        throw new RuleFailureException(file, lineNumber, "Expected prefix " + Copyright.logGood(block) + ", but line is " + Copyright.logBad(line));
                    }
                    return trimmed.substring(block.length() + 1);
                }
            }
            throw new RuleFailureException(file, lineNumber, "Expected prefix " + Copyright.logGood(block) + ", but line is " + Copyright.logBad(line));
        }
        if (this.lineCommentStart().isPresent() && line.startsWith(lineComment = this.lineCommentStart().get())) {
            String substring = line.substring(lineComment.length());
            if (substring.startsWith(" ")) {
                substring = substring.substring(1);
            }
            return substring;
        }
        return line;
    }

    protected boolean isCommentStart(String line) {
        if (this.supportsBlockComments()) {
            return line.startsWith(this.blockCommentStart());
        }
        return line.startsWith(this.lineCommentStart().orElseThrow(() -> new EnforcerException("When block comment is not supported, line comment must be defined.")));
    }

    protected final boolean startsWith(Path path, String prefix) {
        return this.startsWith(path, prefix.getBytes(StandardCharsets.UTF_8));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final boolean startsWith(Path path, byte[] prefix) {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            byte[] chunk = new byte[prefix.length];
            int read = inputStream.read(chunk);
            if (read < chunk.length) {
                boolean bl2 = false;
                return bl2;
            }
            boolean bl = Arrays.equals(prefix, chunk);
            return bl;
        }
        catch (IOException e) {
            throw new EnforcerException("Failed to check file from prefix. Path: " + path, e);
        }
    }

    protected boolean supportsBlockComments() {
        return false;
    }

    protected String blockCommentStart() {
        return null;
    }

    protected String blockCommentEnd() {
        return null;
    }

    protected Optional<String> blockCommentPrefix() {
        return Optional.empty();
    }

    protected Optional<String> lineCommentStart() {
        return Optional.empty();
    }

    protected boolean isPreamble(String line) {
        return false;
    }

    protected final String currentYear() {
        return this.currentYear;
    }
}

