/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.enforcer.copyright;

import io.helidon.build.maven.enforcer.copyright.TemplateLine;
import io.helidon.build.maven.enforcer.copyright.Validator;
import io.helidon.build.maven.enforcer.copyright.ValidatorBase;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.Set;

class ValidatorJsp
extends ValidatorBase {
    public static final String BLOCK_COMMENT_START = "<%--";
    public static final String BLOCK_COMMENT_END = "--%>";
    private static final Optional<String> BLOCK_COMMENT_PREFIX = Optional.of("    ");

    protected ValidatorJsp(Validator.ValidatorConfig validatorConfig, List<TemplateLine> templateLines) {
        super(validatorConfig, templateLines);
    }

    @Override
    public Set<String> supportedSuffixes() {
        return Set.of(".jsp");
    }

    @Override
    public boolean supports(Path path) {
        return path.getFileName().toString().equals("build.properties") && super.startsWith(path, "<");
    }

    @Override
    protected boolean supportsBlockComments() {
        return true;
    }

    @Override
    protected String blockCommentStart() {
        return BLOCK_COMMENT_START;
    }

    @Override
    protected String blockCommentEnd() {
        return BLOCK_COMMENT_END;
    }

    @Override
    protected boolean allowLeadEmptyLine() {
        return true;
    }

    @Override
    protected boolean allowTrailEmptyLine(String modifiedYear) {
        return true;
    }

    @Override
    protected Optional<String> blockCommentPrefix() {
        return BLOCK_COMMENT_PREFIX;
    }
}

