/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.enforcer.inclusivenaming;

import io.helidon.build.common.logging.Log;
import io.helidon.build.maven.enforcer.EnforcerException;
import io.helidon.build.maven.enforcer.FileMatcher;
import io.helidon.build.maven.enforcer.FileRequest;
import io.helidon.build.maven.enforcer.FoundFiles;
import io.helidon.build.maven.enforcer.RuleFailure;
import io.helidon.build.maven.enforcer.inclusivenaming.InlusiveNamingConfig;
import io.helidon.build.maven.enforcer.inclusivenaming.XmlData;
import io.helidon.build.maven.enforcer.inclusivenaming.XmlInclusiveNaming;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class InclusiveNamingRule {
    private static final String INCLUSIVE_NAMING_XML = "inclusive-names.xml";
    private static final Set<String> ALLOWED_TIERS = Set.of("0");
    private static final Set<String> DEFAULT_INCLUDES = Set.of(".java", ".xml", ".adoc", ".txt", ".md", ".html", ".css", ".properties", ".yaml", ".sh", ".sql", ".conf", ".json", ".kt", ".groovy", ".mustache", ".yml", ".graphql", ".proto", "Dockerfile.native", "Dockerfile.jlink", ".gradle", ".MF");
    private final List<FileMatcher> excludes;
    private final List<FileMatcher> includes;
    private final List<XmlData> terms;

    private InclusiveNamingRule(Builder builder) {
        this.excludes = builder.excludes();
        this.includes = builder.includes();
        this.terms = builder.terms();
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<RuleFailure> check(FoundFiles filesToCheck) {
        LinkedList<RuleFailure> failures = new LinkedList<RuleFailure>();
        AtomicInteger count = new AtomicInteger();
        filesToCheck.fileRequests().stream().filter(this::include).forEach(fr -> {
            count.incrementAndGet();
            this.processFile((FileRequest)fr, (List<RuleFailure>)failures);
        });
        if (failures.size() == 0) {
            Log.info((String)("Inclusive naming processed " + count.get() + " files."), (Object[])new Object[0]);
        } else {
            Log.info((String)("Inclusive naming processed " + count.get() + " files, found " + failures.size() + " errors"), (Object[])new Object[0]);
        }
        return failures;
    }

    private void processFile(FileRequest fr, List<RuleFailure> errors) {
        try (BufferedReader bufferedReader = Files.newBufferedReader(fr.path(), StandardCharsets.UTF_8);){
            String line;
            int lineNum = 0;
            LinkedList<XmlData> found = new LinkedList<XmlData>();
            while ((line = bufferedReader.readLine()) != null) {
                ++lineNum;
                for (XmlData term : this.terms) {
                    if (!line.toLowerCase().contains(term.getTerm())) continue;
                    found.add(term);
                }
                if (!found.isEmpty()) {
                    errors.add(RuleFailure.create(fr, lineNum, "inclusive naming found: " + String.join((CharSequence)", ", ((Object)found).toString())));
                }
                found.clear();
            }
        }
        catch (IOException e) {
            throw new EnforcerException("Failed to process file for inclusive naming: " + fr.relativePath());
        }
    }

    private boolean include(FileRequest fr) {
        for (FileMatcher exclude : this.excludes) {
            if (!exclude.matches(fr)) continue;
            return false;
        }
        for (FileMatcher include : this.includes) {
            if (!include.matches(fr)) continue;
            return true;
        }
        return false;
    }

    public static class Builder {
        private InlusiveNamingConfig inclusiveNamingConfig;

        private Builder() {
        }

        public Builder config(InlusiveNamingConfig inclusiveNamingConfig) {
            this.inclusiveNamingConfig = inclusiveNamingConfig;
            return this;
        }

        public InclusiveNamingRule build() {
            return new InclusiveNamingRule(this);
        }

        private List<XmlData> readTerms(Supplier<InputStream> supplier) {
            ArrayList<XmlData> terms = new ArrayList<XmlData>();
            try (InputStream is = supplier.get();){
                XmlInclusiveNaming xml = this.xmlInclusiveNaming(is);
                for (XmlData data : xml.getData()) {
                    String tier = data.getTier();
                    String term = data.getTerm();
                    if (ALLOWED_TIERS.contains(tier)) continue;
                    boolean exclude = false;
                    for (Pattern pattern : this.inclusiveNamingConfig.excludeTermsRegExps()) {
                        if (!pattern.matcher(term).matches()) continue;
                        exclude = true;
                        break;
                    }
                    if (exclude) continue;
                    terms.add(data);
                }
            }
            catch (IOException | JAXBException e) {
                throw new EnforcerException("Failed to read inclusive naming file", e);
            }
            terms.addAll(this.inclusiveNamingConfig.additionalTerms());
            return terms;
        }

        private XmlInclusiveNaming xmlInclusiveNaming(InputStream is) throws JAXBException {
            JAXBContext contextObj = JAXBContext.newInstance((Class[])new Class[]{XmlInclusiveNaming.class});
            Unmarshaller unmarshaller = contextObj.createUnmarshaller();
            return (XmlInclusiveNaming)unmarshaller.unmarshal(is);
        }

        List<XmlData> terms() {
            if (this.inclusiveNamingConfig.inclusiveNamingFile().isPresent()) {
                return this.readTerms(() -> {
                    try {
                        return new FileInputStream(this.inclusiveNamingConfig.inclusiveNamingFile().get());
                    }
                    catch (FileNotFoundException e) {
                        throw new EnforcerException(this.inclusiveNamingConfig.inclusiveNamingFile().get() + " was not found");
                    }
                });
            }
            return this.readTerms(() -> InclusiveNamingRule.class.getResourceAsStream(InclusiveNamingRule.INCLUSIVE_NAMING_XML));
        }

        List<FileMatcher> excludes() {
            return this.inclusiveNamingConfig.excludes().stream().map(FileMatcher::create).flatMap(Collection::stream).collect(Collectors.toList());
        }

        List<FileMatcher> includes() {
            HashSet<String> includes = new HashSet<String>(DEFAULT_INCLUDES);
            includes.addAll(this.inclusiveNamingConfig.includes());
            return includes.stream().map(FileMatcher::create).flatMap(Collection::stream).collect(Collectors.toList());
        }
    }
}

