/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.enforcer.nativeimage;

import io.helidon.build.common.PathFinder;
import io.helidon.build.common.maven.MavenVersion;
import io.helidon.build.maven.enforcer.EnforcerException;
import io.helidon.build.maven.enforcer.RuleFailure;
import io.helidon.build.maven.enforcer.nativeimage.NativeImageConfig;
import io.helidon.build.maven.enforcer.nativeimage.VersionConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class NativeImageRule {
    private static final String NATIVE_IMAGE = "native-image";
    private static final String GRAALVM_HOME = "GRAALVM_HOME";
    private static final String JAVA_HOME = "JAVA_HOME";
    private final List<VersionConfig> versionConfigs;

    public NativeImageRule(NativeImageConfig config) {
        this.versionConfigs = config.rules();
    }

    public List<RuleFailure> check() {
        LinkedList<RuleFailure> failures = new LinkedList<RuleFailure>();
        Process process = this.startProcess();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith("GraalVM")) continue;
                this.checkVersion(failures, line.split(" "));
            }
        }
        catch (IOException e) {
            throw new EnforcerException("Fail to run native-image --version");
        }
        return failures;
    }

    private void checkVersion(List<RuleFailure> failures, String[] elements) {
        if (elements.length < 1) {
            return;
        }
        MavenVersion version = MavenVersion.toMavenVersion((String)elements[1]);
        for (VersionConfig rule : this.versionConfigs) {
            rule.checkVersion(version, failures);
        }
    }

    private Process startProcess() {
        Process process;
        Path nativeImage = this.findNativeImage();
        if (nativeImage == null || !nativeImage.toFile().exists()) {
            throw new EnforcerException("native-image executable not found.");
        }
        ProcessBuilder builder = new ProcessBuilder(nativeImage.toString(), "--version").redirectErrorStream(true);
        try {
            process = builder.start();
        }
        catch (IOException e) {
            throw new EnforcerException("Fail to run native-image --version");
        }
        try {
            process.getOutputStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return process;
    }

    private Path findNativeImage() {
        return (Path)PathFinder.find((String)NATIVE_IMAGE, List.of(Optional.ofNullable(System.getenv(GRAALVM_HOME)).map(x$0 -> Path.of(x$0, new String[0])).map(p -> p.resolve("bin"))), List.of(Optional.ofNullable(System.getenv(JAVA_HOME)).map(x$0 -> Path.of(x$0, new String[0])).map(p -> p.resolve("bin")))).orElseThrow(() -> new IllegalStateException("Unable to find native-image"));
    }
}

