/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.enforcer.nativeimage;

import io.helidon.build.common.maven.MavenVersion;
import io.helidon.build.maven.enforcer.RuleFailure;
import io.helidon.build.maven.enforcer.nativeimage.EnforcerNativeImageException;
import java.util.List;

public class VersionConfig {
    private String version;
    private String matcher;
    private static final List<String> AVAILABLE_MATCHER = List.of("greaterThan", "lessThan", "greaterThanOrEqualTo", "lessThanOrEqualTo");

    public String getVersion() {
        return this.version;
    }

    public String getMatcher() {
        return this.matcher;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setMatcher(String matcher) {
        this.matcher = matcher;
    }

    void checkVersion(MavenVersion nativeVersion, List<RuleFailure> failures) {
        boolean success;
        MavenVersion ruleVersion = MavenVersion.toMavenVersion((String)this.version);
        switch (this.matcher.toLowerCase()) {
            case "greaterthan": {
                success = nativeVersion.isGreaterThan(ruleVersion);
                break;
            }
            case "lessthan": {
                success = nativeVersion.isLessThan(ruleVersion);
                break;
            }
            case "greaterthanorequalto": {
                success = nativeVersion.isGreaterThanOrEqualTo(ruleVersion);
                break;
            }
            case "lessthanorequalto": {
                success = nativeVersion.isLessThanOrEqualTo(ruleVersion);
                break;
            }
            default: {
                throw new EnforcerNativeImageException(this.matcher, AVAILABLE_MATCHER);
            }
        }
        if (!success) {
            failures.add(RuleFailure.create(this.errorMessage(this.matcher, nativeVersion, ruleVersion)));
        }
    }

    private String errorMessage(String match, MavenVersion nativeVersion, MavenVersion ruleVersion) {
        return String.format("native image version %s is not %s %s rule version.", nativeVersion, match, ruleVersion);
    }

    public String toString() {
        return "VersionConfig{version=" + this.version + ", matcher=" + this.matcher + "}";
    }
}

