/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.javadoc;

import io.helidon.build.common.FileUtils;
import io.helidon.build.common.Lists;
import io.helidon.build.common.OSType;
import io.helidon.build.common.PrintStreams;
import io.helidon.build.common.ProcessMonitor;
import io.helidon.build.common.RingBuffer;
import io.helidon.build.common.Strings;
import io.helidon.build.common.logging.Log;
import io.helidon.build.common.logging.LogLevel;
import io.helidon.build.common.maven.MavenModel;
import io.helidon.build.common.maven.plugin.MavenArtifact;
import io.helidon.build.common.maven.plugin.MavenFilters;
import io.helidon.build.common.maven.plugin.PlexusLoggerHolder;
import io.helidon.build.javadoc.JavaParser;
import io.helidon.build.javadoc.JavadocModule;
import io.helidon.build.javadoc.OfflineLink;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.lang.invoke.CallSite;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Organization;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;

@Mojo(name="javadoc", requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
@Execute(phase=LifecyclePhase.NONE)
public class JavadocMojo
extends AbstractMojo {
    private static final String JAVADOC_EXE = OSType.currentOS() == OSType.Windows ? "javadoc.exe" : "javadoc";
    @Component
    private PlexusLoggerHolder plexusLogHolder;
    @Component
    private RepositorySystem repoSystem;
    @Component
    private ArchiverManager archiverManager;
    @Component
    private ProjectBuilder projectBuilder;
    @Component
    private ToolchainManager toolchainManager;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepos;
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    private File buildDirectory;
    @Parameter(property="helidon.javadoc.outputDirectory", defaultValue="${project.build.directory}/apidocs", required=true)
    private File outputDirectory;
    @Parameter(property="helidon.javadoc.projectRoot", defaultValue="${maven.multiModuleProjectDirectory}", required=true)
    private File projectRoot;
    @Parameter(property="helidon.javadoc.dependencyIncludes", defaultValue="*:*")
    private List<String> dependencyIncludes = List.of();
    @Parameter(property="helidon.javadoc.dependencyExcludes")
    private List<String> dependencyExcludes = List.of();
    @Parameter(property="helidon.javadoc.pomScanningIdentity", defaultValue="pom.xml")
    private List<String> pomScanningIdentity = List.of();
    @Parameter(property="helidon.javadoc.pomScanningIncludes", defaultValue="**/*")
    private List<String> pomScanningIncludes = List.of();
    @Parameter(property="helidon.javadoc.pomScanningExcludes", defaultValue="**/target/**,**/src**")
    private List<String> pomScanningExcludes = List.of();
    @Parameter(property="helidon.javadoc.pomIncludes", defaultValue="*:*:*")
    private List<String> pomIncludes = List.of();
    @Parameter(property="helidon.javadoc.pomExcludes")
    private List<String> pomExcludes = List.of();
    @Parameter(property="helidon.javadoc.fileIncludes", defaultValue="*.java")
    private List<String> fileIncludes = List.of();
    @Parameter(property="helidon.javadoc.fileExcludes")
    private List<String> fileExcludes = List.of();
    @Parameter(property="helidon.javadoc.sourcesJarFallback", defaultValue="false")
    private boolean sourcesJarFallback;
    @Parameter(property="helidon.javadoc.parseModuleInfo", defaultValue="true")
    private boolean parseModuleInfo;
    @Parameter(property="helidon.javadoc.sourcesJarIncludes")
    private List<String> sourcesJarIncludes = List.of();
    @Parameter(property="helidon.javadoc.sourcesJarExcludes")
    private List<String> sourcesJarExcludes = List.of();
    @Parameter(property="helidon.javadoc.sourceIncludes", defaultValue="**/*")
    private List<String> sourceIncludes = List.of();
    @Parameter(property="helidon.javadoc.sourceExcludes", defaultValue="**/src/test/java,**/generated-test-sources")
    private List<String> sourceExcludes = List.of();
    @Parameter(property="helidon.javadoc.moduleIncludes", defaultValue="*")
    private List<String> moduleIncludes = List.of();
    @Parameter(property="helidon.javadoc.moduleExcludes")
    private List<String> moduleExcludes = List.of();
    @Parameter(property="helidon.javadoc.packageIncludes", defaultValue="*")
    private List<String> packageIncludes = List.of();
    @Parameter(property="helidon.javadoc.packageExcludes")
    private List<String> packageExcludes = List.of();
    @Parameter
    private String[] additionalOptions = new String[0];
    @Parameter(property="helidon.javadoc.source", defaultValue="${maven.compiler.source}")
    private String source;
    @Parameter(defaultValue="${maven.compiler.release}")
    private String release;
    @Parameter(property="helidon.javadoc.charset")
    private String charset;
    @Parameter(property="helidon.javadoc.docencoding", defaultValue="UTF-8")
    private String docencoding;
    @Parameter(property="helidon.javadoc.encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(property="bottom", defaultValue="Copyright &#169; {inceptionYear}&#x2013;{currentYear} {organizationName}. All rights reserved.")
    private String bottom;
    @Parameter(property="doctitle", defaultValue="${project.name} ${project.version} API")
    private String doctitle;
    @Parameter(property="helidon.javadoc.windowtitle", defaultValue="${project.name} ${project.version} API")
    private String windowtitle;
    @Parameter(property="helidon.javadoc.links")
    private ArrayList<String> links;
    @Parameter(property="helidon.javadoc.offlineLinks")
    private OfflineLink[] offlineLinks;
    @Parameter(property="helidon.javadoc.author", defaultValue="true")
    private boolean author;
    @Parameter(property="helidon.javadoc.use", defaultValue="true")
    private boolean use;
    @Parameter(property="helidon.javadoc.version", defaultValue="true")
    private boolean version;
    @Parameter(property="helidon.javadoc.doclint")
    private String doclint;
    @Parameter(property="helidon.javadoc.quiet", defaultValue="false")
    private boolean quiet;
    @Parameter(property="helidon.javadoc.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="helidon.javadoc.failOnError", defaultValue="true")
    private boolean failOnError;
    @Parameter(property="helidon.javadoc.failOnWarnings", defaultValue="false")
    private boolean failOnWarnings;
    private Predicate<MavenArtifact> dependencyFilter;
    private Predicate<MavenModel> pomFilter;
    private Predicate<Path> pomIdentityFilter;
    private Predicate<Path> pomScanningFilter;
    private Predicate<Path> sourceFilter;
    private Predicate<String> filenameFilter;
    private Predicate<String> moduleFilter;
    private Predicate<String> packageFilter;
    private IncludeExcludeFileSelector[] sourcesJarSelectors;
    private Map<String, Path> workspace;
    private Path workDir;
    private final Map<String, JavadocModule> jars = new HashMap<String, JavadocModule>();
    private final Map<String, JavadocModule> sources = new HashMap<String, JavadocModule>();
    private final Map<String, Set<JavadocModule>> unresolved = new HashMap<String, Set<JavadocModule>>();
    private final Map<String, Set<JavadocModule>> resolved = new HashMap<String, Set<JavadocModule>>();
    private final Set<String> modulePath = new HashSet<String>();
    private final Set<String> classPath = new HashSet<String>();

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            Log.info((String)"processing is skipped.", (Object[])new Object[0]);
            return;
        }
        this.sourcesJarSelectors = JavadocMojo.selectors(this.sourcesJarIncludes, this.sourcesJarExcludes);
        this.dependencyFilter = MavenFilters.artifactFilter(this.dependencyIncludes, this.dependencyExcludes);
        this.pomFilter = MavenFilters.pomFilter(this.pomIncludes, this.pomExcludes);
        this.sourceFilter = MavenFilters.pathFilter(this.sourceIncludes, this.sourceExcludes, (Path)this.projectRoot.toPath());
        this.filenameFilter = MavenFilters.stringFilter(this.fileIncludes, this.fileExcludes);
        this.pomIdentityFilter = MavenFilters.dirFilter(this.pomScanningIdentity);
        this.pomScanningFilter = MavenFilters.pathFilter(this.pomScanningIncludes, this.pomScanningExcludes, (Path)this.projectRoot.toPath());
        this.moduleFilter = MavenFilters.stringFilter(this.moduleIncludes, this.moduleExcludes);
        this.packageFilter = MavenFilters.stringFilter(this.packageIncludes, this.packageExcludes);
        this.workDir = FileUtils.ensureDirectory((Path)this.buildDirectory.toPath().resolve("javadoc-maven-plugin"), (FileAttribute[])new FileAttribute[0]);
        this.workspace = this.scanWorkspace();
        this.resolveJavadocModules();
        this.resolveJavaModules();
        this.resolvePaths();
        Path optionsFile = this.writeOptionsFile();
        Path argsFile = this.writeArgsFile();
        Log.info((String)"Generated options file at %s", (Object[])new Object[]{optionsFile});
        Log.info((String)"Generated args file at %s", (Object[])new Object[]{argsFile});
        String exe = this.javadocExecutable();
        List<CallSite> cmd = List.of(exe, "@" + optionsFile, "@" + argsFile);
        try {
            RingBuffer lines = new RingBuffer(10);
            ProcessMonitor.builder().processBuilder(new ProcessBuilder(cmd)).autoEol(false).stdOut(PrintStreams.accept((PrintStream)PrintStreams.DEVNULL, x$0 -> Log.info((String)x$0, (Object[])new Object[0]))).stdErr(PrintStreams.accept((PrintStream)PrintStreams.DEVNULL, x$0 -> Log.warn((String)x$0, (Object[])new Object[0]))).filter(arg_0 -> ((RingBuffer)lines).add(arg_0)).build().execute(1L, TimeUnit.DAYS);
            if (this.failOnWarnings) {
                for (String line : lines) {
                    if (!line.matches("\\d+ warnings?")) continue;
                    throw new MojoExecutionException("Javadoc execution completed with " + line);
                }
            }
        }
        catch (ProcessMonitor.ProcessTimeoutException | IOException | InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        catch (ProcessMonitor.ProcessFailedException ex) {
            if (this.failOnError) {
                throw new RuntimeException("Javadoc execution failed", ex);
            }
            Log.error((String)"Javadoc execution failed", (Object[])new Object[0]);
        }
    }

    private void resolveJavadocModules() {
        for (MavenArtifact artifact : Lists.map((Collection)this.project.getArtifacts(), MavenArtifact::new)) {
            JavadocModule.CompositeJavadocModule cm;
            Record module;
            if (!"jar".equals(artifact.type())) {
                Log.debug((String)("Dependency ignored (not a jar type): " + artifact), (Object[])new Object[0]);
                continue;
            }
            try {
                if (this.dependencyFilter.test(artifact)) {
                    Path dir = this.workspace.get(JavadocMojo.gav(artifact));
                    if (dir != null) {
                        Log.debug((String)"Resolving source roots in directory: %s", (Object[])new Object[]{dir});
                        sourceRoots = this.sourceRootsFromProjectFiles(dir);
                        module = new JavadocModule.SourceModule(artifact, sourceRoots, this.moduleDescriptor(sourceRoots, artifact));
                    } else if (this.sourcesJarFallback) {
                        Log.info((String)"Resolving source roots from sources-jar for: %s", (Object[])new Object[]{artifact});
                        sourceRoots = this.sourceRootsFromSourceJar(artifact);
                        module = new JavadocModule.SourceModule(artifact, sourceRoots, this.moduleDescriptor(sourceRoots, artifact));
                    } else {
                        Log.warn((String)"Unable to resolve source roots for: %s", (Object[])new Object[]{artifact});
                        module = new JavadocModule.JarModule(artifact, this.moduleDescriptor(artifact), true);
                    }
                } else {
                    Log.debug((String)"Dependency not included as a source module: %s", (Object[])new Object[]{artifact});
                    module = new JavadocModule.JarModule(artifact, this.moduleDescriptor(artifact), true);
                }
            }
            catch (Throwable ex) {
                Log.error((Throwable)ex, (String)"Unable to resolve javadoc module: %s (class-path only)", (Object[])new Object[]{artifact});
                if (LogLevel.isDebug()) {
                    Log.log((LogLevel)LogLevel.DEBUG, (Throwable)ex, (String)"Unable to resolve javadoc module", (Object[])new Object[0]);
                }
                module = new JavadocModule.JarModule(artifact, null, true);
            }
            JavadocModule computed = module instanceof JavadocModule.SourceModule ? this.sources.compute(module.name(), ((JavadocModule)((Object)module))::merge) : this.jars.compute(module.name(), ((JavadocModule)((Object)module))::merge);
            if (!(computed instanceof JavadocModule.CompositeJavadocModule) || (cm = (JavadocModule.CompositeJavadocModule)computed).name().equals("INVALID!")) continue;
            Log.debug((String)"Found module '%s' in multiple locations: %s", (Object[])new Object[]{cm.name(), Lists.join(cm.artifacts(), MavenArtifact::file, (String)" ")});
        }
    }

    private void resolveJavaModules() {
        HashMap required = new HashMap();
        Set systemModules = ModuleFinder.ofSystem().findAll().stream().map(ModuleReference::descriptor).map(ModuleDescriptor::name).collect(Collectors.toSet());
        this.sources.forEach((name, module) -> module.requires(true).forEach(it -> {
            if (!this.sources.containsKey(it) && !systemModules.contains(it)) {
                required.computeIfAbsent(it, n -> new HashSet()).add(module);
            }
        }));
        ArrayDeque stack = new ArrayDeque(required.keySet());
        while (!stack.isEmpty()) {
            Set edges;
            String name2 = (String)stack.pop();
            JavadocModule module2 = this.jars.computeIfAbsent(name2, arg_0 -> this.lambda$resolveJavaModules$5(name2, edges = required.getOrDefault(name2, Set.of()), arg_0));
            if (module2 != null) {
                this.resolved.computeIfAbsent(name2, n -> new HashSet()).addAll(edges);
                module2.requires(false).forEach(it -> {
                    if (!this.sources.containsKey(it) && !systemModules.contains(it)) {
                        required.computeIfAbsent(it, n -> new HashSet()).add(module2);
                        stack.push(it);
                    }
                });
                continue;
            }
            this.unresolved.computeIfAbsent(name2, n -> new HashSet()).addAll(edges);
        }
        if (!this.unresolved.isEmpty()) {
            this.unresolved.forEach((name, modules) -> Log.warn((String)"Unresolved module: %s required by %s", (Object[])new Object[]{name, Lists.join((Collection)modules, JavadocModule::name, (String)", ")}));
        }
    }

    private void resolvePaths() {
        Path moduleSrcDir = this.workDir.resolve("src");
        this.sources.forEach((name, it) -> {
            this.modulePath.add(Strings.normalizePath((Object)it.artifact().file()));
            FileUtils.ensureDirectory((Path)moduleSrcDir.resolve((String)name), (FileAttribute[])new FileAttribute[0]);
        });
        this.jars.forEach((name, it) -> {
            String path = Strings.normalizePath((Object)it.artifact().file());
            if (this.resolved.containsKey(name)) {
                this.modulePath.add(path);
            } else {
                this.classPath.add(path);
            }
        });
        if (LogLevel.isDebug()) {
            List sourceRoots = Lists.flatMap(this.sources.values(), JavadocModule::sourceRoots);
            Log.debug((String)"Resolved source roots: %s", (Object[])new Object[]{Lists.join((Collection)sourceRoots, s -> Strings.normalizePath((Object)s.dir()), (String)", ")});
            Log.debug((String)"Resolved module-path: %s", (Object[])new Object[]{this.modulePath});
            Log.debug((String)"Resolved class-path: %s", (Object[])new Object[]{this.classPath});
        }
    }

    private Path writeOptionsFile() {
        ArrayList<String> options = new ArrayList<String>();
        if (Strings.isValid((String)this.doclint)) {
            options.add("-Xdoclint:" + this.doclint);
        }
        JavadocMojo.addOption(options, "-d", Strings.normalizePath((Object)this.outputDirectory));
        if (!JavadocMojo.addOption(options, "--release", this.release)) {
            JavadocMojo.addOption(options, "--source", this.source);
        }
        JavadocMojo.addOption(options, "--module-source-path", Strings.normalizePath((Object)this.workDir.resolve("src")));
        JavadocMojo.addOption(options, "--module-path", String.join((CharSequence)File.pathSeparator, this.modulePath));
        JavadocMojo.addOption(options, "--class-path", String.join((CharSequence)File.pathSeparator, this.classPath));
        this.sources.forEach((name, it) -> {
            Set<JavadocModule.SourceRoot> sourceRoots = it.sourceRoots();
            if (!sourceRoots.isEmpty()) {
                String value = Lists.join(sourceRoots, s -> Strings.normalizePath((Object)s.dir()), (String)File.pathSeparator);
                JavadocMojo.addOption(options, "--patch-module", name + "=" + value);
            }
        });
        JavadocMojo.addOption(options, "-docencoding", this.docencoding);
        if (!JavadocMojo.addOption(options, "-charset", this.charset)) {
            JavadocMojo.addOption(options, "-charset", this.docencoding);
        }
        JavadocMojo.addOption(options, "-bottom", this.bottomText());
        JavadocMojo.addOption(options, "-doctitle", this.doctitle);
        JavadocMojo.addOption(options, "-windowtitle", this.windowtitle);
        for (String link : this.links) {
            JavadocMojo.addOption(options, "-link", link);
        }
        for (OfflineLink offlineLink : this.offlineLinks) {
            JavadocMojo.addOption(options, "-linkoffline", offlineLink.getUrl(), Strings.normalizePath((Object)offlineLink.getLocation()));
        }
        if (this.author) {
            options.add("-author");
        }
        if (this.use) {
            options.add("-use");
        }
        if (this.version) {
            options.add("-version");
        }
        if (this.quiet) {
            options.add("-quiet");
        }
        for (String option : this.additionalOptions) {
            options.add(option.replaceAll("(?<!\\\\)\\\\(?![\\\\:])", "\\\\"));
        }
        return this.writeLines("options", options);
    }

    private Path writeArgsFile() {
        ArrayList<String> args = new ArrayList<String>();
        this.sources.forEach((name, module) -> {
            if (!this.moduleFilter.test((String)name)) {
                Log.debug((String)"Excluding module: '%s' (provided by %s)", (Object[])new Object[]{name, module.artifact()});
                return;
            }
            for (JavadocModule.SourceRoot sourceRoot : module.sourceRoots()) {
                sourceRoot.files().forEach((pkg, files) -> {
                    if (this.packageFilter.test((String)pkg) || pkg.isEmpty() && files.stream().allMatch(file -> "module-info.java".equals(FileUtils.fileName((Path)file)))) {
                        for (Path file2 : files) {
                            args.add(Strings.normalizePath((Object)file2.toAbsolutePath()));
                        }
                    } else {
                        Log.debug((String)"Excluding package: '%s' (provided by %s)", (Object[])new Object[]{pkg, module.artifact()});
                    }
                });
            }
        });
        return this.writeLines("argsfile", args);
    }

    private JavadocModule resolveMissing(String name, Set<JavadocModule> edges) {
        return edges.stream().flatMap(JavadocModule::stream).flatMap(it -> {
            MavenProject pom = this.effectivePom(it.artifact());
            return pom.getDependencies().stream().filter(dep -> !it.visible() || dep.isOptional() || "provided".equals(dep.getScope())).map(this::resolveDependencies).flatMap(Collection::stream);
        }).flatMap(it -> {
            try {
                return Stream.of(new JavadocModule.JarModule((MavenArtifact)it, this.moduleDescriptor((MavenArtifact)it), false));
            }
            catch (Throwable ex) {
                Log.error((Throwable)ex, (String)ex.getMessage(), (Object[])new Object[0]);
                return Stream.empty();
            }
        }).filter(it -> it.name().equals(name)).findFirst().orElse(null);
    }

    private Set<JavadocModule.SourceRoot> sourceRootsFromSourceJar(MavenArtifact dep) {
        File sourcesJar = this.resolveArtifact(dep.sourcesJar());
        Path sourceRoot = this.workDir.resolve("source-jars").resolve(dep.toString());
        try {
            Log.debug((String)"Unpacking %s to %s", (Object[])new Object[]{sourcesJar, sourceRoot});
            Files.createDirectories(sourceRoot, new FileAttribute[0]);
            UnArchiver unArchiver = this.archiverManager.getUnArchiver(sourcesJar);
            unArchiver.setSourceFile(sourcesJar);
            unArchiver.setDestDirectory(sourceRoot.toFile());
            unArchiver.setFileSelectors((FileSelector[])this.sourcesJarSelectors);
            unArchiver.extract();
            List sourceFiles = FileUtils.walk((Path)sourceRoot, (path, attrs) -> attrs.isDirectory() || this.filenameFilter.test(FileUtils.fileName((Path)path)));
            return this.sourceRoots(sourceFiles);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        catch (NoSuchArchiverException e) {
            throw new RuntimeException(e);
        }
    }

    private Set<JavadocModule.SourceRoot> sourceRootsFromProjectFiles(Path dir) {
        List nested = Lists.filter(this.workspace.values(), it -> !it.equals(dir) && it.startsWith(dir));
        List moduleSources = FileUtils.walk((Path)dir, (path, attrs) -> attrs.isDirectory() && !nested.contains(path) || this.filenameFilter.test(FileUtils.fileName((Path)path)));
        return this.sourceRoots(moduleSources);
    }

    private Set<JavadocModule.SourceRoot> sourceRoots(List<Path> sourceFiles) {
        HashMap<Path, JavadocModule.SourceRoot> sourceRoots = new HashMap<Path, JavadocModule.SourceRoot>();
        HashMap<Path, String> packages = new HashMap<Path, String>();
        for (Path sourceFile : sourceFiles) {
            String pkg;
            Path dir = JavadocMojo.sourceRoot(sourceFile, pkg = packages.computeIfAbsent(sourceFile.getParent(), ignored -> {
                Log.debug((String)"Parsing package name of %s", (Object[])new Object[]{sourceFile});
                return JavaParser.packge(sourceFile);
            }));
            if (this.sourceFilter.test(dir)) {
                sourceRoots.computeIfAbsent(dir, d -> new JavadocModule.SourceRoot((Path)d, (Map<String, Set<Path>>)new HashMap<String, Set<Path>>())).files().computeIfAbsent(pkg, p -> new HashSet()).add(sourceFile);
                continue;
            }
            Log.debug((String)"Excluding source root: %s", (Object[])new Object[]{dir});
        }
        return new HashSet<JavadocModule.SourceRoot>(sourceRoots.values());
    }

    private static Path sourceRoot(Path sourceFile, String pkg) {
        Path path = sourceFile.getParent();
        long count = pkg.chars().filter(it -> it == 46).count();
        if (count > 0L) {
            while (count >= 0L) {
                path = path.getParent();
                --count;
            }
        }
        return path;
    }

    private ModuleDescriptor moduleDescriptor(Set<JavadocModule.SourceRoot> sourceRoots, MavenArtifact artifact) {
        return sourceRoots.stream().filter(s -> this.parseModuleInfo).map(s -> s.dir().resolve("module-info.java")).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findFirst().map(this::moduleDescriptor).orElseGet(() -> this.moduleDescriptor(artifact));
    }

    private ModuleDescriptor moduleDescriptor(Path path) {
        Log.debug((String)"Parsing %s", (Object[])new Object[]{path});
        return JavaParser.module(path);
    }

    private ModuleDescriptor moduleDescriptor(MavenArtifact artifact) {
        Log.debug((String)"Resolving module descriptor for %s", (Object[])new Object[]{artifact});
        ModuleFinder mf = ModuleFinder.of(artifact.file());
        return mf.findAll().iterator().next().descriptor();
    }

    private File resolveArtifact(MavenArtifact artifact) {
        try {
            ArtifactRequest request = new ArtifactRequest();
            request.setArtifact(artifact.toAetherArtifact());
            request.setRepositories(this.remoteRepos);
            return this.repoSystem.resolveArtifact(this.repoSession, request).getArtifact().getFile();
        }
        catch (ArtifactResolutionException e) {
            throw new RuntimeException(e);
        }
    }

    private List<MavenArtifact> resolveDependencies(Dependency dep) {
        try {
            CollectRequest collectRequest = new CollectRequest();
            collectRequest.setRoot(new org.eclipse.aether.graph.Dependency((Artifact)new DefaultArtifact(dep.getGroupId(), dep.getArtifactId(), dep.getClassifier(), dep.getType(), dep.getVersion()), "compile"));
            DependencyNode node = this.repoSystem.collectDependencies(this.repoSession, collectRequest).getRoot();
            DependencyRequest dependencyRequest = new DependencyRequest();
            dependencyRequest.setRoot(node);
            return this.repoSystem.resolveDependencies(this.repoSession, dependencyRequest).getArtifactResults().stream().map(ArtifactResult::getArtifact).filter(it -> "jar".equals(it.getExtension())).map(MavenArtifact::new).toList();
        }
        catch (DependencyCollectionException | DependencyResolutionException e) {
            throw new RuntimeException(e);
        }
    }

    private MavenProject effectivePom(MavenArtifact a) {
        try {
            DefaultProjectBuildingRequest pbr = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
            pbr.setRemoteRepositories(this.project.getRemoteArtifactRepositories());
            pbr.setPluginArtifactRepositories(this.project.getPluginArtifactRepositories());
            pbr.setProject(null);
            pbr.setValidationLevel(0);
            pbr.setResolveDependencies(true);
            File pomFile = this.resolveArtifact(a.pom());
            return this.projectBuilder.build(pomFile, (ProjectBuildingRequest)pbr).getProject();
        }
        catch (ProjectBuildingException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Map<String, Path> scanWorkspace() {
        Map<String, Path> map;
        block8: {
            Stream<Path> stream = Files.walk(this.projectRoot.toPath(), new FileVisitOption[0]);
            try {
                map = stream.filter(this.pomIdentityFilter).filter(this.pomScanningFilter).map(it -> {
                    Path file = it.resolve("pom.xml");
                    Log.debug((String)"Reading model %s", (Object[])new Object[]{file});
                    return Map.entry(MavenModel.read((Path)file), it);
                }).filter(it -> this.pomFilter.test((MavenModel)it.getKey())).collect(Collectors.toMap(e -> JavadocMojo.gav((MavenModel)e.getKey()), Map.Entry::getValue));
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            stream.close();
        }
        return map;
    }

    private String bottomText() {
        String inceptionYear = this.project.getInceptionYear();
        LocalDate localDate = LocalDate.now();
        String currentYear = Integer.toString(localDate.getYear());
        String text = this.bottom;
        if (Strings.isValid((String)currentYear)) {
            text = text.replace("{currentYear}", currentYear);
        }
        text = Strings.isValid((String)inceptionYear) ? text.replace("{inceptionYear}", currentYear) : text.replace("{inceptionYear}&#x2013;", currentYear);
        Organization organization = this.project.getOrganization();
        text = organization != null && Strings.isValid((String)organization.getName()) ? (Strings.isValid((String)organization.getUrl()) ? text.replace("{organizationName}", String.format("<a href=\"%s\">%s</a>", organization.getUrl(), organization.getName())) : text.replace("{organizationName}", organization.getName())) : text.replace(" {organizationName}", "");
        return text;
    }

    private Path writeLines(String filename, List<String> lines) {
        Path path;
        block9: {
            Path file = this.workDir.resolve(filename);
            BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);
            try {
                for (String line : lines) {
                    writer.write(line);
                    writer.newLine();
                }
                path = file;
                if (writer == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            writer.close();
        }
        return path;
    }

    private String javadocExecutable() {
        return Optional.ofNullable(this.toolchainManager.getToolchainFromBuildContext("jdk", this.session)).map(tc -> {
            Log.debug((String)"Searching for javadoc executable in toolchain: %s", (Object[])new Object[]{tc.getType()});
            return tc.findTool("javadoc");
        }).or(() -> {
            Log.debug((String)"Unable to find javadoc from toolchain", (Object[])new Object[0]);
            return FileUtils.findExecutableInPath((String)JAVADOC_EXE).map(Path::toString);
        }).or(() -> {
            Log.debug((String)"Searching for javadoc executable in JAVA_HOME", (Object[])new Object[0]);
            return FileUtils.findExecutableInJavaHome((String)JAVADOC_EXE).map(Path::toString);
        }).orElseThrow(() -> new IllegalStateException("Unable to find javadoc executable"));
    }

    private static String gav(MavenArtifact dep) {
        return String.format("%s:%s:%s", dep.groupId(), dep.artifactId(), dep.version());
    }

    private static String gav(MavenModel pom) {
        return String.format("%s:%s:%s", pom.groupId(), pom.artifactId(), pom.version());
    }

    private static boolean addOption(List<String> args, String option, Object ... values) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            Object str;
            Object value = values[i];
            if (value == null || ((String)(str = value.toString())).isEmpty()) continue;
            str = ((String)str).replace("'", "\\'");
            str = ((String)str).replace("\n", " ");
            str = "'" + (String)str + "'";
            sb.append((String)str);
            if (i >= values.length - 1) continue;
            sb.append(" ");
        }
        if (!sb.isEmpty()) {
            args.add(option);
            args.add(sb.toString());
            return true;
        }
        return false;
    }

    private static IncludeExcludeFileSelector[] selectors(List<String> includes, List<String> excludes) {
        if (!excludes.isEmpty() || !includes.isEmpty()) {
            IncludeExcludeFileSelector selector = new IncludeExcludeFileSelector();
            selector.setExcludes(excludes.toArray(new String[0]));
            selector.setIncludes(includes.toArray(new String[0]));
            return new IncludeExcludeFileSelector[]{selector};
        }
        return null;
    }

    private /* synthetic */ JavadocModule lambda$resolveJavaModules$5(String name, Set edges, String n) {
        Log.debug((String)"Resolving %s from provided/optional dependencies", (Object[])new Object[]{name});
        return this.resolveMissing(name, edges);
    }
}

