/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.javadoc;

import io.helidon.build.javadoc.JavaTokenizer;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.module.ModuleDescriptor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class JavaParser {
    private static final JavaTokenizer.Symbol TO = JavaTokenizer.Symbol.keyword(JavaTokenizer.Keyword.TO);
    private static final JavaTokenizer.Symbol WITH = JavaTokenizer.Symbol.keyword(JavaTokenizer.Keyword.WITH);
    private static final JavaTokenizer.Symbol SEMI_COLON = JavaTokenizer.Symbol.token(JavaTokenizer.Token.SEMI_COLON);
    private static final JavaTokenizer.Symbol COMMA = JavaTokenizer.Symbol.token(JavaTokenizer.Token.COMMA);
    private static final JavaTokenizer.Symbol WHITESPACE = JavaTokenizer.Symbol.token(JavaTokenizer.Token.WHITESPACE);
    private final JavaTokenizer tokenizer;

    private JavaParser(InputStream is) {
        this.tokenizer = new JavaTokenizer(is);
    }

    static String packge(InputStream is) {
        return new JavaParser(is).parsePackage();
    }

    static String packge(Path path) {
        try {
            return JavaParser.packge(Files.newInputStream(path, new OpenOption[0]));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    static ModuleDescriptor module(InputStream is) {
        return new JavaParser(is).parseModule();
    }

    static ModuleDescriptor module(Path path) {
        try {
            return JavaParser.module(Files.newInputStream(path, new OpenOption[0]));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private String parsePackage() {
        while (this.tokenizer.hasNext()) {
            JavaTokenizer.Symbol symbol = this.tokenizer.next();
            if (!symbol.isKeyword()) continue;
            return symbol.keyword() == JavaTokenizer.Keyword.PACKAGE ? this.parseName() : "";
        }
        throw new IllegalStateException("Unexpected EOF");
    }

    private ModuleDescriptor parseModule() {
        HashMap<String, String> imports = new HashMap<String, String>();
        while (this.tokenizer.hasNext()) {
            JavaTokenizer.Symbol symbol = this.tokenizer.next();
            if (!symbol.isKeyword()) continue;
            switch (symbol.keyword()) {
                case IMPORT: {
                    String name = this.parseName();
                    imports.put(name.substring(name.lastIndexOf(46) + 1), name);
                    break;
                }
                case MODULE: {
                    ModuleDescriptor.Builder builder = ModuleDescriptor.newModule(this.parseName());
                    block12: while (this.tokenizer.hasNext()) {
                        symbol = this.tokenizer.next();
                        if (!symbol.isKeyword()) continue;
                        JavaTokenizer.Keyword keyword = symbol.keyword();
                        switch (keyword) {
                            case REQUIRES: {
                                this.parseModuleRequires(builder);
                                continue block12;
                            }
                            case EXPORTS: {
                                this.parseModuleExports(builder);
                                continue block12;
                            }
                            case OPENS: {
                                this.parseModuleOpens(builder);
                                continue block12;
                            }
                            case PROVIDES: {
                                this.parseModuleProvides(builder, imports);
                                continue block12;
                            }
                            case USES: {
                                this.parseModuleUses(builder, imports);
                                continue block12;
                            }
                        }
                        throw new IllegalStateException(String.format("Unexpected keyword '%s' at %s", keyword.text(), this.tokenizer.cursor()));
                    }
                    return builder.build();
                }
            }
        }
        throw new IllegalStateException("Unable to parse module");
    }

    private JavaTokenizer.Symbol nextSymbol(Predicate<JavaTokenizer.Symbol> predicate) {
        while (this.tokenizer.hasNext()) {
            JavaTokenizer.Symbol symbol = this.tokenizer.peek();
            if (symbol.isConcrete()) {
                if (predicate.test(symbol)) {
                    this.tokenizer.skip();
                    return symbol;
                }
                return null;
            }
            this.tokenizer.skip();
        }
        throw new IllegalStateException("Unexpected EOF");
    }

    private List<JavaTokenizer.Symbol> nextSymbols(Predicate<JavaTokenizer.Symbol> predicate) {
        ArrayList<JavaTokenizer.Symbol> symbols = new ArrayList<JavaTokenizer.Symbol>();
        while (this.tokenizer.hasNext()) {
            JavaTokenizer.Symbol symbol = this.tokenizer.peek();
            if (symbol.isConcrete()) {
                if (predicate.test(symbol)) {
                    this.tokenizer.skip();
                    symbols.add(symbol);
                } else {
                    return symbols;
                }
            }
            this.tokenizer.skip();
        }
        throw new IllegalStateException("Unexpected EOF");
    }

    private String parseName() {
        StringBuilder sb = new StringBuilder();
        JavaTokenizer.Symbol previous = WHITESPACE;
        while (this.tokenizer.hasNext()) {
            JavaTokenizer.Symbol symbol = this.tokenizer.peek();
            if (symbol.isConcrete()) {
                if (!symbol.isIdentifier() && !symbol.isDot() && (!symbol.isContextualKeyword() || !previous.isDot())) break;
                sb.append(symbol.text());
            }
            this.tokenizer.skip();
            previous = symbol;
        }
        return sb.toString();
    }

    private List<String> parseNames() {
        ArrayList<String> names = new ArrayList<String>();
        while (this.tokenizer.hasNext()) {
            names.add(this.parseName());
            JavaTokenizer.Symbol symbol = this.nextSymbol(JavaTokenizer.Symbol::isToken);
            if (symbol == SEMI_COLON) {
                return names;
            }
            if (symbol == null || symbol == COMMA) continue;
            throw new IllegalStateException(String.format("Unexpected token '%s' at %s", symbol.text(), this.tokenizer.cursor()));
        }
        throw new IllegalStateException("Unexpected EOF");
    }

    private void parseModuleRequires(ModuleDescriptor.Builder builder) {
        List<JavaTokenizer.Symbol> symbols = this.nextSymbols(JavaTokenizer.Symbol::isKeyword);
        Set<ModuleDescriptor.Requires.Modifier> modifiers = symbols.stream().map(symbol -> switch (symbol.keyword()) {
            case JavaTokenizer.Keyword.STATIC -> ModuleDescriptor.Requires.Modifier.STATIC;
            case JavaTokenizer.Keyword.TRANSITIVE -> ModuleDescriptor.Requires.Modifier.TRANSITIVE;
            default -> throw new IllegalStateException(String.format("Invalid directive at %s", this.tokenizer.cursor()));
        }).collect(Collectors.toSet());
        String source = this.parseName();
        builder.requires(modifiers, source);
    }

    private void parseModuleExports(ModuleDescriptor.Builder builder) {
        String source = this.parseName();
        if (!source.isEmpty()) {
            JavaTokenizer.Symbol symbol = this.nextSymbol(JavaTokenizer.Symbol::isKeyword);
            if (symbol == null) {
                builder.exports(source);
            } else if (symbol == TO) {
                builder.exports(source, Collections.unmodifiableSet(new LinkedHashSet<String>(this.parseNames())));
            }
        } else {
            throw new IllegalStateException(String.format("Invalid directive at %s", this.tokenizer.cursor()));
        }
    }

    private void parseModuleOpens(ModuleDescriptor.Builder builder) {
        String source = this.parseName();
        if (!source.isEmpty()) {
            JavaTokenizer.Symbol symbol = this.nextSymbol(JavaTokenizer.Symbol::isKeyword);
            if (symbol == null) {
                builder.opens(source);
            } else if (symbol == TO) {
                builder.opens(source, Collections.unmodifiableSet(new LinkedHashSet<String>(this.parseNames())));
            }
        } else {
            throw new IllegalStateException(String.format("Invalid directive at %s", this.tokenizer.cursor()));
        }
    }

    private void parseModuleProvides(ModuleDescriptor.Builder builder, Map<String, String> imports) {
        String service = this.parseName();
        String serviceFQN = imports.getOrDefault(service, service);
        if (!service.isEmpty()) {
            List<String> providers;
            JavaTokenizer.Symbol symbol = this.nextSymbol(JavaTokenizer.Symbol::isKeyword);
            if (symbol == WITH && !(providers = this.parseNames().stream().map(it -> imports.getOrDefault(it, (String)it)).toList()).isEmpty()) {
                builder.provides(serviceFQN, providers);
            }
        } else {
            throw new IllegalStateException(String.format("Invalid directive at %s", this.tokenizer.cursor()));
        }
    }

    private void parseModuleUses(ModuleDescriptor.Builder builder, Map<String, String> imports) {
        String service = this.parseName();
        builder.uses(imports.getOrDefault(service, service));
    }
}

