/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.javadoc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;

class JavaTokenizer
implements AutoCloseable,
Iterator<Symbol> {
    private static final List<String> KEYWORDS = Arrays.stream(Keyword.values()).map(Keyword::text).toList();
    private final int bufferSize;
    private char[] buf;
    private final Reader reader;
    private boolean eof = false;
    private int limit;
    private int position;
    private int lastPosition;
    private int valuePosition;
    private int lineNo = 1;
    private int charNo = 0;
    private State state = State.TOKEN;
    private Symbol symbol;

    JavaTokenizer(InputStream is, int size) {
        try {
            this.reader = new InputStreamReader(is);
            this.bufferSize = size;
            this.buf = new char[this.bufferSize];
            this.limit = this.reader.read(this.buf);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    JavaTokenizer(InputStream is) {
        this(is, 1024);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    String cursor() {
        return String.format("line: %d, col: %d", this.lineNo, this.charNo);
    }

    @Override
    public boolean hasNext() {
        if (this.symbol == null) {
            this.symbol = this.parseNext();
        }
        return this.symbol != null;
    }

    @Override
    public Symbol next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Symbol next = this.symbol;
        this.symbol = null;
        return next;
    }

    Symbol peek() {
        return this.symbol;
    }

    void skip() {
        this.symbol = null;
    }

    private Symbol parseNext() {
        while (this.position < this.limit && this.symbol == null) {
            char c = this.readChar();
            if (c == '\n') {
                ++this.lineNo;
                this.charNo = 1;
            }
            this.lastPosition = this.position++;
            switch (this.state) {
                case TOKEN: {
                    boolean foundToken = false;
                    for (Token token : Token.values()) {
                        if (!token.type.read(this)) continue;
                        this.valuePosition = this.position;
                        switch (token) {
                            case EOL_COMMENT: {
                                this.state = State.EOL_COMMENT;
                                break;
                            }
                            case COMMENT_START: {
                                this.state = State.COMMENT;
                                break;
                            }
                            case SINGLE_QUOTE: {
                                this.state = State.CHAR_LITERAL;
                                break;
                            }
                            case DOUBLE_QUOTE: {
                                this.state = State.STRING_LITERAL;
                                break;
                            }
                            default: {
                                this.symbol = Symbol.token(token);
                            }
                        }
                        foundToken = true;
                        break;
                    }
                    if (foundToken) break;
                    this.valuePosition = this.position;
                    this.state = State.NAME;
                    break;
                }
                case NAME: {
                    if (Character.isJavaIdentifierPart(c)) {
                        if (this.valuePosition < 0) {
                            this.valuePosition = this.lastPosition;
                        }
                        ++this.position;
                        break;
                    }
                    String rawValue = this.symbolValue();
                    if (KEYWORDS.contains(rawValue)) {
                        Keyword keyword = Keyword.valueOf(rawValue.toUpperCase());
                        this.symbol = Symbol.keyword(keyword);
                    } else {
                        this.symbol = Symbol.identifier(rawValue);
                    }
                    this.state = State.TOKEN;
                    break;
                }
                case EOL_COMMENT: {
                    if (c == '\n') {
                        this.symbol = Symbol.eolComment(this.symbolValue());
                        this.state = State.TOKEN;
                    }
                    ++this.position;
                    break;
                }
                case COMMENT: {
                    if (this.consumeString("*/")) {
                        this.symbol = Symbol.comment(this.symbolValue());
                        this.state = State.TOKEN;
                    }
                    break;
                }
                case CHAR_LITERAL: {
                    if (c == '\'') {
                        this.symbol = Symbol.charLiteral(this.symbolValue());
                        ++this.position;
                        this.state = State.TOKEN;
                        break;
                    }
                    if (c == '\\') {
                        ++this.position;
                        if (this.consumeChar('\'')) break;
                        this.consumeChar('\\');
                        break;
                    }
                    ++this.position;
                    break;
                }
                case STRING_LITERAL: {
                    if (c == '\"') {
                        this.symbol = Symbol.stringLiteral(this.symbolValue());
                        ++this.position;
                        this.state = State.TOKEN;
                        break;
                    }
                    if (c == '\\') {
                        ++this.position;
                        if (this.consumeChar('\"')) break;
                        this.consumeChar('\\');
                        break;
                    }
                    ++this.position;
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("State %s not supported at line: %d, char: %d", new Object[]{this.state, this.lineNo, this.charNo}));
                }
            }
            this.charNo += this.position - this.lastPosition;
            if (this.position < this.limit) continue;
            this.ensureBuffer(1);
        }
        return this.symbol;
    }

    private String symbolValue() {
        return String.valueOf(this.buf, this.valuePosition, this.lastPosition - this.valuePosition);
    }

    private boolean consumeWhiteSpace() {
        char c = this.readChar();
        if (Character.isWhitespace(c)) {
            ++this.position;
            return true;
        }
        return false;
    }

    private boolean consumeChar(char expected) {
        char actual = this.readChar();
        if (actual == expected) {
            ++this.position;
            return true;
        }
        return false;
    }

    private boolean consumeString(String expected) {
        String actual = this.readString(expected.length());
        if (expected.equals(actual)) {
            this.position += expected.length();
            return true;
        }
        return false;
    }

    private char readChar() {
        if (this.ensureBuffer(1)) {
            return this.buf[this.position];
        }
        return '\u0000';
    }

    private String readString(int length) {
        if (this.ensureBuffer(length)) {
            return String.valueOf(this.buf, this.position, length);
        }
        return null;
    }

    private boolean ensureBuffer(int length) {
        int newLimit = this.position + length;
        if (newLimit > this.limit) {
            if (this.eof) {
                return false;
            }
            int offset = this.limit - this.valuePosition;
            if (newLimit > this.buf.length) {
                char[] tmp = new char[this.buf.length + this.bufferSize];
                System.arraycopy(this.buf, this.valuePosition, tmp, 0, offset);
                this.buf = tmp;
                this.limit = offset;
                this.position -= this.valuePosition;
                this.lastPosition -= this.valuePosition;
                this.valuePosition = 0;
            }
            try {
                int read = this.reader.read(this.buf, offset, this.buf.length - offset);
                if (read == -1) {
                    this.eof = true;
                    return false;
                }
                this.limit = offset + read;
                return true;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        return true;
    }

    private static enum State {
        TOKEN,
        COMMENT,
        EOL_COMMENT,
        NAME,
        STRING_LITERAL,
        CHAR_LITERAL;

    }

    record Symbol(Type type, Value value) {
        static Symbol comment(String rawValue) {
            return new Symbol(Type.COMMENT, new StringValue(rawValue));
        }

        static Symbol eolComment(String rawValue) {
            return new Symbol(Type.EOL_COMMENT, new StringValue(rawValue));
        }

        static Symbol identifier(String rawValue) {
            return new Symbol(Type.IDENTIFIER, new StringValue(rawValue));
        }

        static Symbol stringLiteral(String rawValue) {
            return new Symbol(Type.STRING_LITERAL, new StringValue(rawValue));
        }

        static Symbol charLiteral(String rawValue) {
            return new Symbol(Type.CHAR_LITERAL, new StringValue(rawValue));
        }

        static Symbol keyword(Keyword keyword) {
            return keyword.symbol;
        }

        static Symbol token(Token token) {
            return token.symbol;
        }

        boolean isToken() {
            return this.type == Type.TOKEN;
        }

        boolean isDot() {
            return Token.DOT.symbol == this;
        }

        boolean isIdentifier() {
            return this.type == Type.IDENTIFIER;
        }

        boolean isKeyword() {
            return this.type == Type.KEYWORD;
        }

        boolean isContextualKeyword() {
            return this.isKeyword() && !this.keyword().isReserved();
        }

        boolean isConcrete() {
            return switch (this.type) {
                case Type.EOL_COMMENT, Type.COMMENT -> false;
                case Type.TOKEN -> {
                    if (this != Token.WHITESPACE.symbol) {
                        yield true;
                    }
                    yield false;
                }
                default -> true;
            };
        }

        Token token() {
            Value value = this.value;
            if (value instanceof TokenValue) {
                TokenValue v = (TokenValue)value;
                return v.token;
            }
            throw new IllegalStateException("Expected a TokenValue but got: " + this.value);
        }

        String raw() {
            Value value = this.value;
            if (value instanceof StringValue) {
                StringValue v = (StringValue)value;
                return v.rawValue;
            }
            throw new IllegalStateException("Expected a StringValue but got: " + this.value);
        }

        Keyword keyword() {
            Value value = this.value;
            if (value instanceof KeywordValue) {
                KeywordValue v = (KeywordValue)value;
                return v.keyword;
            }
            throw new IllegalStateException("Expected a KeywordValue but got: " + this.value);
        }

        String text() {
            return switch (this.type) {
                case Type.TOKEN -> this.token().text();
                case Type.KEYWORD -> this.keyword().text();
                default -> this.raw();
            };
        }

        static enum Type {
            TOKEN,
            EOL_COMMENT,
            COMMENT,
            IDENTIFIER,
            KEYWORD,
            CHAR_LITERAL,
            STRING_LITERAL;

        }

        private static interface Value {
        }

        private record StringValue(String rawValue) implements Value
        {
        }

        private record TokenValue(Token token) implements Value
        {
        }

        private record KeywordValue(Keyword keyword) implements Value
        {
        }
    }

    static enum Token {
        WHITESPACE(JavaTokenizer::consumeWhiteSpace),
        OPEN_PARENT('('),
        CLOSE_PARENT(')'),
        OPEN_SQUARE('['),
        CLOSE_SQUARE(']'),
        OPEN_CURLY('{'),
        CLOSE_CURLY('}'),
        ANNOTATION('@'),
        SINGLE_QUOTE('\''),
        DOUBLE_QUOTE('\"'),
        EOL_COMMENT("//"),
        COMMENT_START("/*"),
        DOT('.'),
        COMMA(','),
        SEMI_COLON(';'),
        EQUALS("=="),
        ASSIGN('='),
        INCREMENT("++"),
        PLUS_EQUAL("+="),
        PLUS('+'),
        DECREMENT("--"),
        MINUS_EQUAL("-="),
        MINUS('-'),
        MULTIPLY_EQUAL("*="),
        MULTIPLY('*'),
        DIVIDE_EQUAL("/="),
        DIVIDE('/'),
        MODULO_EQUAL("%="),
        MODULO('%'),
        LOGICAL_AND("&&"),
        LOGICAL_OR("||"),
        LOGICAL_NOT('!'),
        NOT_EQUAL("!="),
        LOGICAL_XOR('^'),
        BIT_AND_EQUAL("&="),
        BIT_OR_EQUAL("|="),
        XOR_EQUAL("^="),
        SHR_EQUAL(">>="),
        SHL_EQUAL("<<="),
        SHR(">>"),
        SHL("<<"),
        GREATER_EQUAL(">="),
        LOWER_EQUAL("<="),
        GREATER('>'),
        LOWER('<'),
        BIT_OR('|'),
        BIT_AND('&'),
        BIT_COMP('~');

        private final Type type;
        private final Symbol symbol;

        private Token(Function<JavaTokenizer, Boolean> function) {
            this.type = new FunctionType(function);
            this.symbol = new Symbol(Symbol.Type.TOKEN, new Symbol.TokenValue(this));
        }

        private Token(char ch) {
            this.type = new CharType(ch);
            this.symbol = new Symbol(Symbol.Type.TOKEN, new Symbol.TokenValue(this));
        }

        private Token(String str) {
            this.type = new StringType(str);
            this.symbol = new Symbol(Symbol.Type.TOKEN, new Symbol.TokenValue(this));
        }

        String text() {
            Type type = this.type;
            if (type instanceof CharType) {
                CharType t = (CharType)type;
                return String.valueOf(t.ch);
            }
            type = this.type;
            if (type instanceof StringType) {
                StringType t = (StringType)type;
                return t.str;
            }
            return "<" + this.name() + ">";
        }

        private record FunctionType(Function<JavaTokenizer, Boolean> fn) implements Type
        {
            @Override
            public boolean read(JavaTokenizer tokenizer) {
                return this.fn.apply(tokenizer);
            }
        }

        private static interface Type {
            public boolean read(JavaTokenizer var1);
        }

        private record CharType(char ch) implements Type
        {
            @Override
            public boolean read(JavaTokenizer tokenizer) {
                return tokenizer.consumeChar(this.ch);
            }
        }

        private record StringType(String str) implements Type
        {
            @Override
            public boolean read(JavaTokenizer tokenizer) {
                return tokenizer.consumeString(this.str);
            }
        }
    }

    static enum Keyword {
        ABSTRACT,
        ASSERT,
        BOOLEAN,
        BREAK,
        BYTE,
        CATCH,
        CHAR,
        CLASS,
        CONST,
        CONTINUE,
        DEFAULT,
        DO,
        DOUBLE,
        ELSE,
        ENUM,
        EXTENDS,
        FALSE,
        FINAL,
        FINALLY,
        FLOAT,
        FOR,
        GOTO,
        IF,
        IMPLEMENTS,
        IMPORT,
        INSTANCEOF,
        INT,
        INTERFACE,
        LONG,
        NATIVE,
        NEW,
        PACKAGE,
        PRIVATE,
        PROTECTED,
        PUBLIC,
        RETURN,
        SHORT,
        STATIC,
        STRICTFP,
        SUPER,
        SWITCH,
        SYNCHRONIZED,
        THIS,
        THROW,
        THROWS,
        TRANSIENT,
        TRUE,
        TRY,
        VOID,
        VOLATILE,
        WHILE,
        EXPORTS(false),
        MODULE(false),
        NON_SEALED(false),
        OPEN(false),
        OPENS(false),
        PERMITS(false),
        PROVIDES(false),
        RECORD(false),
        REQUIRES(false),
        SEALED(false),
        TO(false),
        TRANSITIVE(false),
        USES(false),
        VAR(false),
        WHEN(false),
        WITH(false),
        YIELD(false);

        private final Symbol symbol = new Symbol(Symbol.Type.KEYWORD, new Symbol.KeywordValue(this));
        private final boolean reserved;
        private final String text;

        private Keyword() {
            this(true);
        }

        private Keyword(boolean reserved) {
            this.reserved = reserved;
            this.text = this.name().toLowerCase().replace('_', '-');
        }

        boolean isReserved() {
            return this.reserved;
        }

        String text() {
            return this.text;
        }
    }
}

