/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.javadoc;

import io.helidon.build.common.Lists;
import io.helidon.build.common.maven.plugin.MavenArtifact;
import java.lang.module.ModuleDescriptor;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

interface JavadocModule {
    public static final String INVALID = "INVALID!";

    public MavenArtifact artifact();

    public ModuleDescriptor descriptor();

    public Set<SourceRoot> sourceRoots();

    default public String name() {
        ModuleDescriptor md = this.descriptor();
        return md != null ? md.name() : INVALID;
    }

    default public Set<String> requires(boolean direct) {
        ModuleDescriptor md = this.descriptor();
        return md == null ? Set.of() : md.requires().stream().filter(r -> direct || !r.modifiers().contains((Object)ModuleDescriptor.Requires.Modifier.STATIC) || r.modifiers().contains((Object)ModuleDescriptor.Requires.Modifier.TRANSITIVE)).map(ModuleDescriptor.Requires::name).collect(Collectors.toSet());
    }

    default public boolean visible() {
        return true;
    }

    default public Stream<JavadocModule> stream() {
        return Stream.of(this);
    }

    default public JavadocModule merge(String ignored, JavadocModule current) {
        if (current instanceof CompositeJavadocModule) {
            CompositeJavadocModule composite = (CompositeJavadocModule)current;
            composite.elements.add(this);
            return composite;
        }
        if (current != null) {
            return new CompositeJavadocModule(Lists.of((Object[])new JavadocModule[]{current, this}));
        }
        return this;
    }

    public record CompositeJavadocModule(List<JavadocModule> elements) implements JavadocModule
    {
        @Override
        public MavenArtifact artifact() {
            return this.elements.stream().findFirst().map(JavadocModule::artifact).orElseThrow();
        }

        @Override
        public ModuleDescriptor descriptor() {
            return ((JavadocModule)this.elements.stream().findFirst().orElseThrow()).descriptor();
        }

        @Override
        public Set<SourceRoot> sourceRoots() {
            return this.stream().map(JavadocModule::sourceRoots).flatMap(Collection::stream).collect(Collectors.toSet());
        }

        @Override
        public Stream<JavadocModule> stream() {
            HashSet<JavadocModule> result = new HashSet<JavadocModule>();
            ArrayDeque<JavadocModule> stack = new ArrayDeque<JavadocModule>(this.elements);
            while (!stack.isEmpty()) {
                JavadocModule elt = (JavadocModule)stack.pop();
                if (elt instanceof CompositeJavadocModule) {
                    CompositeJavadocModule eltCm = (CompositeJavadocModule)elt;
                    eltCm.elements.forEach(stack::push);
                    continue;
                }
                result.add(elt);
            }
            return result.stream();
        }

        Set<MavenArtifact> artifacts() {
            return this.stream().map(JavadocModule::artifact).collect(Collectors.toSet());
        }
    }

    public record JarModule(MavenArtifact artifact, ModuleDescriptor descriptor, boolean visible) implements JavadocModule
    {
        @Override
        public Set<SourceRoot> sourceRoots() {
            return Set.of();
        }
    }

    public record SourceModule(MavenArtifact artifact, Set<SourceRoot> sourceRoots, ModuleDescriptor descriptor) implements JavadocModule
    {
    }

    public record SourceRoot(Path dir, Map<String, Set<Path>> files) {
    }
}

