/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.linker;

import io.helidon.build.util.FileUtils;
import io.helidon.build.util.Log;
import io.helidon.linker.Jar;
import io.helidon.linker.JavaDependencies;
import io.helidon.linker.ResourceContainer;
import io.helidon.linker.util.Constants;
import io.helidon.linker.util.JavaRuntime;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.stream.Stream;

public final class Application
implements ResourceContainer {
    public static final Path APP_DIR = Paths.get("app", new String[0]);
    private static final Path ARCHIVE_PATH = Paths.get("lib" + Constants.DIR_SEP + "start.jsa", new String[0]);
    private static final String HELIDON_JAR_NAME_PREFIX = "helidon-";
    private static final String MP_FILE_PREFIX = "helidon-microprofile";
    private static final String VERSION_1_4_1 = "1.4.1";
    private static final String UNKNOWN_VERSION = "0.0.0";
    private final Jar mainJar;
    private final List<Jar> classPath;
    private final boolean isMicroprofile;
    private final String version;

    public static Application create(Path mainJar) {
        return new Application(mainJar);
    }

    private Application(Path mainJar) {
        this.mainJar = Jar.open(mainJar);
        this.classPath = this.collectClassPath();
        this.isMicroprofile = this.classPath.stream().anyMatch(jar -> jar.name().startsWith(MP_FILE_PREFIX));
        this.version = this.extractHelidonVersion();
    }

    public Set<String> javaDependencies(JavaRuntime javaHome) {
        return JavaDependencies.collect(this.jars(), javaHome);
    }

    public Path install(JavaRuntime jri, boolean stripDebug) {
        Path appRootDir = this.mainJar.path().getParent();
        Path appInstallDir = jri.ensureDirectory(APP_DIR);
        Path installedAppJar = this.mainJar.copyToDirectory(appInstallDir, this.isMicroprofile(), stripDebug);
        this.classPath.forEach(jar -> {
            Path relativeDir = appRootDir.relativize(jar.path().getParent());
            Path installDir = jri.ensureDirectory(appInstallDir.resolve(relativeDir));
            jar.copyToDirectory(installDir, this.isMicroprofile(), stripDebug);
        });
        return installedAppJar;
    }

    public long installedSize(JavaRuntime jri) {
        return FileUtils.sizeOf((Path)jri.path().resolve(APP_DIR));
    }

    public Path archivePath() {
        return ARCHIVE_PATH;
    }

    public boolean isMicroprofile() {
        return this.isMicroprofile;
    }

    public int size() {
        return 1 + this.classPath.size();
    }

    public long diskSize() {
        return this.jars().mapToLong(jar -> FileUtils.sizeOf((Path)jar.path())).sum();
    }

    public String helidonVersion() {
        return this.version;
    }

    public String exitOnStartedValue() {
        return Application.exitOnStartedValue(this.version);
    }

    public static String exitOnStartedValue(String helidonVersion) {
        return helidonVersion.equals(VERSION_1_4_1) ? "\u2705" : "!";
    }

    @Override
    public boolean containsResource(String resourcePath) {
        return this.jars().anyMatch(jar -> jar.containsResource(resourcePath));
    }

    private Stream<Jar> jars() {
        return Stream.concat(Stream.of(this.mainJar), this.classPath.stream());
    }

    private List<Jar> collectClassPath() {
        List<Jar> classPath = this.addClassPath(this.mainJar, new HashSet<Jar>(), new ArrayList<Jar>());
        if (Log.isDebug()) {
            Log.debug((String)"Application classpath:", (Object[])new Object[0]);
            classPath.forEach(jar -> Log.debug((String)"    %s", (Object[])new Object[]{jar}));
        }
        return classPath;
    }

    private List<Jar> addClassPath(Jar jar, Set<Jar> visited, List<Jar> classPath) {
        if (!visited.contains(jar)) {
            if (!jar.equals(this.mainJar)) {
                classPath.add(jar);
            }
            for (Path path : jar.classPath()) {
                this.addClassPath(jar, path, visited, classPath);
            }
        }
        return classPath;
    }

    private void addClassPath(Jar jar, Path classPathEntry, Set<Jar> visited, List<Jar> classPath) {
        if (Files.isRegularFile(classPathEntry, new LinkOption[0])) {
            if (Jar.isJar(classPathEntry)) {
                try {
                    Jar classPathJar = Jar.open(classPathEntry);
                    this.addClassPath(classPathJar, visited, classPath);
                }
                catch (Exception e) {
                    Log.warn((String)"Could not open class path jar: %s", (Object[])new Object[]{classPathEntry});
                }
            } else {
                Log.debug((String)"Ignoring class path entry: %s", (Object[])new Object[]{classPathEntry});
            }
        } else if (Files.isDirectory(classPathEntry, new LinkOption[0])) {
            FileUtils.list((Path)classPathEntry).forEach(path -> this.addClassPath(jar, (Path)path, visited, classPath));
        }
    }

    private String extractHelidonVersion() {
        return this.classPath.stream().filter(jar -> jar.name().startsWith(HELIDON_JAR_NAME_PREFIX)).filter(jar -> jar.manifest() != null).filter(jar -> jar.manifest().getMainAttributes().containsKey(Attributes.Name.IMPLEMENTATION_VERSION)).map(jar -> jar.manifest().getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION)).findFirst().orElse(UNKNOWN_VERSION);
    }
}

