/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.linker;

import io.helidon.build.util.FileUtils;
import io.helidon.build.util.Log;
import io.helidon.build.util.LogFormatter;
import io.helidon.build.util.OSType;
import io.helidon.build.util.PrintStreams;
import io.helidon.build.util.ProcessMonitor;
import io.helidon.linker.util.Constants;
import io.helidon.linker.util.JavaRuntime;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public final class ClassDataSharing {
    private final Path applicationJar;
    private final String applicationModule;
    private final Path jri;
    private final Path classListFile;
    private final Path archiveFile;
    private final List<String> classList;

    public static Builder builder() {
        return new Builder();
    }

    private ClassDataSharing(Builder builder) {
        this.applicationJar = builder.mainJar;
        this.applicationModule = builder.applicationModule;
        this.jri = builder.jri;
        this.classListFile = builder.classListFile;
        this.archiveFile = builder.archiveFile;
        this.classList = builder.classList;
    }

    public Path applicationJar() {
        return this.applicationJar;
    }

    public String applicationModule() {
        return this.applicationModule;
    }

    public Path jri() {
        return this.jri;
    }

    public Path classListFile() {
        return this.classListFile;
    }

    public List<String> classList() {
        return this.classList;
    }

    public Path archiveFile() {
        return this.archiveFile;
    }

    public static final class Builder {
        private static final String FILE_PREFIX = "start";
        private static final String ARCHIVE_NAME = "start.jsa";
        private static final String CLASS_LIST_FILE_SUFFIX = ".classlist";
        private static final String JAR_SUFFIX = ".jar";
        private static final String XSHARE_OFF = "-Xshare:off";
        private static final String XSHARE_DUMP = "-Xshare:dump";
        private static final String XX_DUMP_LOADED_CLASS_LIST = "-XX:DumpLoadedClassList=";
        private static final String XX_SHARED_ARCHIVE_FILE = "-XX:SharedArchiveFile=";
        private static final String XX_SHARED_CLASS_LIST_FILE = "-XX:SharedClassListFile=";
        private static final String EXIT_ON_STARTED = "-Dexit.on.started=";
        private static final String EXIT_ON_STARTED_VALUE = "!";
        private static final String UTF_8_ENCODING = "-Dfile.encoding=UTF-8";
        private static final String SKIPPED_CLASS_PREFIX = "skip writing class";
        private static final String CANNOT_FIND_PREFIX = "Preload Warning: Cannot find";
        private static final String LIB_DIR_NAME = "lib";
        private Path jri;
        private String archiveDir = "lib";
        private String applicationModule;
        private Path mainJar;
        private Path classListFile;
        private Path archiveFile;
        private List<String> classList;
        private boolean createArchive = true;
        private String target;
        private String targetOption;
        private String targetDescription;
        private boolean logOutput;
        private List<String> jvmOptions = Collections.emptyList();
        private List<String> args = Collections.emptyList();
        private String exitOnStartedValue = "!";
        private int maxWaitSeconds = 1000;

        private Builder() {
        }

        public Builder jri(Path jri) {
            this.jri = jri;
            this.javaPath();
            return this;
        }

        public Builder applicationJar(Path mainJar) {
            this.mainJar = Objects.requireNonNull(mainJar).isAbsolute() ? Builder.assertJar(mainJar) : Builder.assertJar(this.jri.resolve(mainJar));
            return this;
        }

        public Builder applicationModule(String mainModuleName) {
            this.applicationModule = Objects.requireNonNull(mainModuleName);
            return this;
        }

        public Builder jvmOptions(List<String> jvmOptions) {
            if (Builder.isValid(jvmOptions)) {
                this.jvmOptions = jvmOptions;
            }
            return this;
        }

        public Builder args(List<String> args) {
            if (Builder.isValid(args)) {
                this.args = args;
            }
            return this;
        }

        public Builder archiveFile(Path archiveFile) {
            this.archiveFile = Objects.requireNonNull(archiveFile);
            return this;
        }

        public Builder createArchive(boolean createArchive) {
            this.createArchive = createArchive;
            return this;
        }

        public Builder logOutput(boolean logOutput) {
            this.logOutput = logOutput;
            return this;
        }

        public Builder maxWaitSeconds(int maxWaitSeconds) {
            this.maxWaitSeconds = maxWaitSeconds;
            return this;
        }

        public Builder classListFile(Path classListFile) {
            this.classListFile = FileUtils.assertFile((Path)classListFile);
            return this;
        }

        public Builder exitOnStartedValue(String exitOnStartedValue) {
            this.exitOnStartedValue = Objects.requireNonNull(exitOnStartedValue);
            return this;
        }

        public ClassDataSharing build() throws Exception {
            Objects.requireNonNull(this.jri, "java home required");
            if (this.mainJar == null && this.applicationModule == null) {
                throw new IllegalStateException("Either application jar or module name required");
            }
            if (this.mainJar != null && this.applicationModule != null) {
                throw new IllegalStateException("Cannot specify both application jar and module name");
            }
            if (this.mainJar != null) {
                this.targetOption = "-jar";
                this.target = this.jri.relativize(this.mainJar).toString();
                this.targetDescription = FileUtils.fileName((Path)this.mainJar);
            } else {
                this.targetOption = "-m";
                this.target = this.applicationModule;
                this.targetDescription = "module " + this.target + " in " + this.jri;
            }
            if (this.classListFile == null) {
                this.classListFile = Builder.tempFile(CLASS_LIST_FILE_SUFFIX);
                this.classList = this.buildClassList();
            } else {
                this.classList = this.loadClassList();
            }
            if (this.createArchive) {
                if (this.archiveFile == null) {
                    this.archiveFile = FileUtils.assertDir((Path)this.jri.resolve(this.archiveDir)).resolve(ARCHIVE_NAME);
                }
                this.buildCdsArchive();
            }
            return new ClassDataSharing(this);
        }

        private List<String> buildClassList() throws Exception {
            this.execute("Creating startup class list for " + this.targetDescription, XSHARE_OFF, XX_DUMP_LOADED_CLASS_LIST + this.classListFile, UTF_8_ENCODING);
            return this.loadClassList();
        }

        private void buildCdsArchive() throws Exception {
            String action = "Creating Class Data Sharing archive for " + this.targetDescription;
            if (Constants.CDS_REQUIRES_UNLOCK_OPTION) {
                this.execute(action, "-XX:+UnlockDiagnosticVMOptions", XSHARE_DUMP, XX_SHARED_ARCHIVE_FILE + this.archiveFile, XX_SHARED_CLASS_LIST_FILE + this.classListFile, UTF_8_ENCODING);
            } else {
                this.execute(action, XSHARE_DUMP, XX_SHARED_ARCHIVE_FILE + this.archiveFile, XX_SHARED_CLASS_LIST_FILE + this.classListFile, UTF_8_ENCODING);
            }
            if (Constants.OS == OSType.Windows) {
                this.archiveFile.toFile().setWritable(true);
            }
        }

        private List<String> loadClassList() throws IOException {
            return Files.readAllLines(this.classListFile);
        }

        private void execute(String action, String ... jvmArgs) throws Exception {
            PrintStream stdErr;
            PrintStream stdOut;
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            ArrayList<String> command = new ArrayList<String>();
            command.add(this.javaPath().toString());
            command.addAll(this.jvmOptions);
            command.add(EXIT_ON_STARTED + this.exitOnStartedValue);
            command.addAll(Arrays.asList(jvmArgs));
            command.add(this.targetOption);
            command.add(this.target);
            command.addAll(this.args);
            processBuilder.command(command);
            processBuilder.directory(this.jri.toFile());
            if (this.logOutput) {
                stdOut = PrintStreams.apply((PrintStream)PrintStreams.STDOUT, (Function)LogFormatter.of((Log.Level)Log.Level.DEBUG));
                stdErr = PrintStreams.apply((PrintStream)PrintStreams.STDERR, (Function)LogFormatter.of((Log.Level)Log.Level.WARN));
            } else {
                stdOut = PrintStreams.DEVNULL;
                stdErr = PrintStreams.DEVNULL;
            }
            ProcessMonitor.builder().description(action).processBuilder(processBuilder).stdOut(stdOut).stdErr(stdErr).filter(Builder::filter).build().execute((long)this.maxWaitSeconds, TimeUnit.SECONDS);
        }

        private static boolean filter(String line) {
            return !line.startsWith(SKIPPED_CLASS_PREFIX) && !line.startsWith(CANNOT_FIND_PREFIX);
        }

        private Path javaPath() {
            return JavaRuntime.javaCommand(this.jri);
        }

        private static boolean isValid(Collection<?> value) {
            return value != null && !value.isEmpty();
        }

        private static Path tempFile(String suffix) throws IOException {
            File file = File.createTempFile(FILE_PREFIX, suffix);
            file.deleteOnExit();
            return file.toPath();
        }

        private static Path assertJar(Path path) {
            String fileName = FileUtils.fileName((Path)FileUtils.assertFile((Path)path));
            if (!fileName.endsWith(JAR_SUFFIX)) {
                throw new IllegalArgumentException(path + " is not a jar");
            }
            return path;
        }
    }
}

