/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.linker;

import io.helidon.build.util.FileUtils;
import io.helidon.build.util.Log;
import io.helidon.build.util.Strings;
import io.helidon.build.util.SystemLogWriter;
import io.helidon.linker.util.Constants;
import io.helidon.linker.util.JavaRuntime;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class Configuration {
    private final JavaRuntime jdk;
    private final Path mainJar;
    private final List<String> defaultJvm;
    private final List<String> defaultArgs;
    private final List<String> defaultDebug;
    private final List<String> additionalJlinkArgs;
    private final Set<String> additionalModules;
    private final Path jriDirectory;
    private final boolean verbose;
    private final boolean stripDebug;
    private final boolean cds;
    private final boolean test;
    private final int maxAppStartSeconds;

    public static Builder builder() {
        return new Builder();
    }

    private Configuration(Builder builder) {
        this.jdk = builder.jdk;
        this.mainJar = builder.mainJar;
        this.defaultJvm = builder.defaultJvm;
        this.defaultArgs = builder.defaultArgs;
        this.defaultDebug = builder.defaultDebug;
        this.additionalModules = builder.additionalModules;
        this.additionalJlinkArgs = builder.additionalJlinkArgs;
        this.jriDirectory = builder.jriDirectory;
        this.verbose = builder.verbose;
        this.stripDebug = builder.stripDebug;
        this.cds = builder.cds;
        this.test = builder.test;
        this.maxAppStartSeconds = builder.maxAppStartSeconds;
    }

    public JavaRuntime jdk() {
        return this.jdk;
    }

    public Path jriDirectory() {
        return this.jriDirectory;
    }

    public Path mainJar() {
        return this.mainJar;
    }

    public List<String> defaultDebugOptions() {
        return this.defaultDebug;
    }

    public List<String> defaultJvmOptions() {
        return this.defaultJvm;
    }

    public List<String> defaultArgs() {
        return this.defaultArgs;
    }

    public List<String> additionalJlinkArgs() {
        return this.additionalJlinkArgs;
    }

    public Set<String> additionalModules() {
        return this.additionalModules;
    }

    public boolean cds() {
        return this.cds;
    }

    public boolean test() {
        return this.test;
    }

    public boolean verbose() {
        return this.verbose;
    }

    public boolean stripDebug() {
        return this.stripDebug;
    }

    public int maxAppStartSeconds() {
        return this.maxAppStartSeconds;
    }

    public static final class Builder {
        static final String DEFAULT_DEBUG = "-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=*:5005";
        static final int DEFAULT_MAX_APP_START_SECONDS = 1000;
        private JavaRuntime jdk;
        private Path mainJar;
        private List<String> defaultJvm = Collections.emptyList();
        private List<String> defaultArgs = Collections.emptyList();
        private List<String> defaultDebug;
        private List<String> additionalJlinkArgs = Collections.emptyList();
        private Set<String> additionalModules;
        private Path jriDirectory;
        private boolean replace;
        private boolean verbose;
        private boolean stripDebug;
        private boolean cds = true;
        private boolean test = true;
        private Log.Writer logWriter;
        private int maxAppStartSeconds = 1000;

        private Builder() {
            this.defaultDebug = List.of(DEFAULT_DEBUG);
            this.additionalModules = Collections.emptySet();
        }

        public Builder commandLine(String ... args) {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (arg.startsWith("--")) {
                    if (arg.equalsIgnoreCase("--jri")) {
                        this.jriDirectory(Paths.get(Builder.argAt(++i, args), new String[0]));
                        continue;
                    }
                    if (arg.equalsIgnoreCase("--defaultJvmOptions")) {
                        this.defaultJvmOptions(Builder.argAt(++i, args));
                        continue;
                    }
                    if (arg.equalsIgnoreCase("--defaultDebugOptions")) {
                        this.defaultDebugOptions(Builder.argAt(++i, args));
                        continue;
                    }
                    if (arg.equalsIgnoreCase("--defaultArgs")) {
                        this.defaultArgs(Builder.argAt(++i, args));
                        continue;
                    }
                    if (arg.equalsIgnoreCase("--additionalJlinkArgs")) {
                        this.additionalJlinkArgs(Builder.argAt(++i, args));
                        continue;
                    }
                    if (arg.equalsIgnoreCase("--additionalModules")) {
                        this.additionalModules(Builder.argAt(++i, args));
                        continue;
                    }
                    if (arg.equalsIgnoreCase("--maxAppStartSeconds")) {
                        this.maxAppStartSeconds(Integer.parseInt(Builder.argAt(++i, args)));
                        continue;
                    }
                    if (arg.equalsIgnoreCase("--replace")) {
                        this.replace(true);
                        continue;
                    }
                    if (arg.equalsIgnoreCase("--skipCds")) {
                        this.cds(false);
                        continue;
                    }
                    if (arg.equalsIgnoreCase("--skipTest")) {
                        this.test(false);
                        continue;
                    }
                    if (arg.equalsIgnoreCase("--verbose")) {
                        this.verbose(true);
                        continue;
                    }
                    if (arg.equalsIgnoreCase("--stripDebug")) {
                        this.stripDebug(true);
                        continue;
                    }
                    throw new IllegalArgumentException("Unknown argument: " + arg);
                }
                if (this.mainJar == null) {
                    this.mainJar(FileUtils.assertExists((Path)Paths.get(arg, new String[0])));
                    continue;
                }
                throw new IllegalArgumentException("Unknown argument: " + arg);
            }
            return this;
        }

        public Builder mainJar(Path mainJar) {
            this.mainJar = FileUtils.assertFile((Path)mainJar);
            return this;
        }

        public Builder defaultJvmOptions(String jvmOptions) {
            this.defaultJvmOptions(Builder.toList(jvmOptions));
            return this;
        }

        public Builder defaultJvmOptions(List<String> jvmOptions) {
            if (Builder.isValid(jvmOptions)) {
                this.defaultJvm = Builder.split(jvmOptions);
            }
            return this;
        }

        public Builder defaultArgs(String args) {
            this.defaultArgs(Builder.toList(args));
            return this;
        }

        public Builder defaultArgs(List<String> args) {
            if (Builder.isValid(args)) {
                this.defaultArgs = Builder.split(args);
            }
            return this;
        }

        public Builder defaultDebugOptions(String debugOptions) {
            this.defaultDebugOptions(Builder.toList(debugOptions));
            return this;
        }

        public Builder defaultDebugOptions(List<String> debugOptions) {
            if (Builder.isValid(debugOptions)) {
                this.defaultDebug = Builder.split(debugOptions);
            }
            return this;
        }

        public Builder additionalJlinkArgs(String args) {
            this.additionalJlinkArgs(Builder.toList(args));
            return this;
        }

        public Builder additionalJlinkArgs(List<String> args) {
            if (Builder.isValid(args)) {
                this.additionalJlinkArgs = Builder.split(args);
            }
            return this;
        }

        public Builder additionalModules(String modules) {
            this.additionalModules(Builder.toSet(modules));
            return this;
        }

        public Builder additionalModules(Set<String> modules) {
            if (Builder.isValid(modules)) {
                this.additionalModules = modules;
            }
            return this;
        }

        public Builder jriDirectory(Path jriDirectory) {
            this.jriDirectory = jriDirectory;
            return this;
        }

        public Builder replace(boolean replace) {
            this.replace = replace;
            return this;
        }

        public Builder cds(boolean cds) {
            this.cds = cds;
            return this;
        }

        public Builder test(boolean test) {
            this.test = test;
            return this;
        }

        public Builder verbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public Builder logWriter(Log.Writer logWriter) {
            this.logWriter = Objects.requireNonNull(logWriter);
            return this;
        }

        public Builder stripDebug(boolean stripDebug) {
            this.stripDebug = stripDebug;
            return this;
        }

        public Builder maxAppStartSeconds(int maxAppStartSeconds) {
            this.maxAppStartSeconds = maxAppStartSeconds;
            return this;
        }

        public Configuration build() throws IOException {
            if (this.mainJar == null) {
                throw new IllegalArgumentException("applicationJar required");
            }
            this.jdk = JavaRuntime.current(true);
            if (this.jdk.version().major() < 9) {
                throw new IllegalArgumentException(this.jdk + " is an unsupported version,9 or higher required");
            }
            if (this.cds && Constants.DOCKER_BUILD && this.jdk.version().major() < 10) {
                throw new IllegalArgumentException("Class Data Sharing cannot be used in Docker with JDK " + this.jdk.version().major() + ". Use JDK 10+ or disable CDS by setting addClassDataSharingArchive to false in the plugin configuration.");
            }
            this.jriDirectory = JavaRuntime.prepareJriDirectory(this.jriDirectory, this.mainJar, this.replace);
            if (this.logWriter == null) {
                this.logWriter = SystemLogWriter.create((Log.Level)(this.verbose ? Log.Level.DEBUG : Log.Level.INFO));
            }
            Log.writer((Log.Writer)this.logWriter);
            return new Configuration(this);
        }

        private static List<String> toList(String value) {
            if (Strings.isValid((String)value)) {
                return Arrays.asList(value.split(" "));
            }
            return null;
        }

        private static Set<String> toSet(String value) {
            if (Strings.isValid((String)value)) {
                return Set.of(value.split(" "));
            }
            return null;
        }

        private static boolean isValid(Collection<?> value) {
            return value != null && !value.isEmpty();
        }

        private static List<String> split(List<String> list) {
            if (list.size() == 1) {
                return Arrays.asList(list.get(0).split(" "));
            }
            return list;
        }

        private static String argAt(int index, String[] args) {
            if (index < args.length) {
                return args[index];
            }
            throw new IllegalArgumentException(args[index - 1] + ": missing required argument");
        }
    }
}

