/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.linker;

import io.helidon.build.util.FileUtils;
import io.helidon.build.util.Log;
import io.helidon.build.util.StreamUtils;
import io.helidon.linker.ResourceContainer;
import io.helidon.linker.util.Constants;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.module.ModuleDescriptor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.ZipEntry;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.IndexWriter;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.UnsupportedVersion;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public final class Jar
implements ResourceContainer {
    private static final String JMOD_SUFFIX = ".jmod";
    private static final Set<String> SUPPORTED_SUFFIXES = Set.of(".jar", ".zip", ".jmod");
    private static final String BEANS_RESOURCE_PATH = "META-INF/beans.xml";
    private static final String JANDEX_INDEX_RESOURCE_PATH = "META-INF/jandex.idx";
    private static final String CLASS_FILE_SUFFIX = ".class";
    private static final String JMOD_CLASSES_PREFIX = "classes/";
    private static final String MODULE_INFO_CLASS = "module-info.class";
    private static final String SIGNATURE_PREFIX = "META-INF/";
    private static final String SIGNATURE_SUFFIX = ".SF";
    private final Path path;
    private final boolean isJmod;
    private final JarFile jar;
    private final Manifest manifest;
    private final boolean isMultiRelease;
    private final boolean isBeansArchive;
    private final boolean isSigned;
    private final ModuleDescriptor descriptor;
    private final AtomicReference<Set<String>> resources;
    private Index index;
    private boolean builtIndex;

    public static boolean isJar(Path path) {
        String name;
        int lastDot;
        if (Files.isRegularFile(path, new LinkOption[0]) && (lastDot = (name = FileUtils.fileName((Path)path)).lastIndexOf(46)) >= 0) {
            return SUPPORTED_SUFFIXES.contains(name.substring(lastDot));
        }
        return false;
    }

    public static Jar open(Path jarPath) {
        if (!Jar.isJar(jarPath)) {
            throw new IllegalArgumentException("Not a jar: " + jarPath);
        }
        return new Jar(jarPath);
    }

    private Jar(Path path) {
        this.path = FileUtils.assertFile((Path)path);
        this.isJmod = FileUtils.fileName((Path)path).endsWith(JMOD_SUFFIX);
        try {
            this.jar = new JarFile(path.toFile());
            this.manifest = this.jar.getManifest();
            this.isMultiRelease = !this.isJmod && Jar.isMultiRelease(this.manifest);
            this.isSigned = !this.isJmod && this.hasSignatureFile();
            this.isBeansArchive = !this.isJmod && this.hasEntry(BEANS_RESOURCE_PATH);
            Entry moduleInfo = this.findEntry(this.isJmod ? "classes/module-info.class" : MODULE_INFO_CLASS);
            this.descriptor = moduleInfo != null ? ModuleDescriptor.read(moduleInfo.data()) : null;
            this.resources = new AtomicReference();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String name() {
        return FileUtils.fileName((Path)this.path);
    }

    public Path path() {
        return this.path;
    }

    public boolean isJmod() {
        return this.isJmod;
    }

    public List<Path> classPath() {
        Object classPath;
        if (this.manifest != null && (classPath = this.manifest.getMainAttributes().get(Attributes.Name.CLASS_PATH)) != null) {
            Path root = Objects.requireNonNull(this.path().getParent());
            return Arrays.stream(((String)classPath).split(" ")).map(root::resolve).filter(file -> Files.exists(file, new LinkOption[0])).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public Manifest manifest() {
        return this.manifest;
    }

    public Stream<Entry> entries() {
        Iterator<JarEntry> iterator = this.jar.entries().asIterator();
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).map(x$0 -> new Entry((JarEntry)x$0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsResource(String resourcePath) {
        Set<String> paths = this.resources.get();
        if (paths == null) {
            AtomicReference<Set<String>> atomicReference = this.resources;
            synchronized (atomicReference) {
                paths = this.entries().map(ZipEntry::getName).collect(Collectors.toSet());
                this.resources.set(paths);
            }
        }
        return paths.contains(resourcePath);
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public boolean isMultiRelease() {
        return this.isMultiRelease;
    }

    public boolean isBeansArchive() {
        return this.isBeansArchive;
    }

    public boolean hasIndex() {
        return this.isBeansArchive && this.index != null;
    }

    public boolean hasModuleDescriptor() {
        return this.descriptor != null;
    }

    public ModuleDescriptor moduleDescriptor() {
        return this.descriptor;
    }

    public Path copyToDirectory(Path targetDir, boolean ensureIndex, boolean stripDebug) {
        Path fileName = this.path.getFileName();
        Path targetFile = FileUtils.assertDir((Path)targetDir).resolve(fileName);
        if (ensureIndex) {
            this.ensureIndex();
        }
        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(targetFile, new OpenOption[0]));){
            if (this.builtIndex) {
                this.copy(out, true, stripDebug);
            } else if (stripDebug) {
                this.copy(out, false, true);
            } else {
                StreamUtils.transfer((InputStream)Files.newInputStream(this.path, new OpenOption[0]), (OutputStream)out);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (Constants.OS.isPosix()) {
            try {
                Files.setPosixFilePermissions(targetFile, Set.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_READ, PosixFilePermission.OTHERS_READ));
            }
            catch (IOException e) {
                Log.warn((String)"Unable to set %s read-only: %s", (Object[])new Object[]{e.getMessage()});
            }
        }
        return targetFile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Jar jar = (Jar)o;
        return this.path.equals(jar.path);
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }

    public String toString() {
        return this.isSigned ? this.name() + " (signed)" : this.name();
    }

    private void ensureIndex() {
        if (this.isBeansArchive) {
            if (this.hasEntry(JANDEX_INDEX_RESOURCE_PATH)) {
                this.index = this.loadIndex();
            }
            if (this.index == null) {
                if (this.isSigned) {
                    Log.warn((String)"Cannot add Jandex index to signed jar %s", (Object[])new Object[]{this.name()});
                } else {
                    this.index = this.buildIndex();
                    this.builtIndex = true;
                }
            }
        }
    }

    private Index loadIndex() {
        block11: {
            Index index;
            block10: {
                Log.info((String)"  checking index in CDI beans archive %s", (Object[])new Object[]{this});
                InputStream in = this.getEntry(JANDEX_INDEX_RESOURCE_PATH).data();
                try {
                    index = new IndexReader(in).read();
                    if (in == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IllegalArgumentException e) {
                        Log.warn((String)"  Jandex index in %s is not valid, will re-create: %s", (Object[])new Object[]{this.path, e.getMessage()});
                        break block11;
                    }
                    catch (UnsupportedVersion e) {
                        Log.warn((String)"  Jandex index in %s is an unsupported version, will re-create: %s", (Object[])new Object[]{this.path, e.getMessage()});
                        break block11;
                    }
                    catch (IOException e) {
                        Log.warn((String)"  Jandex index in %s cannot be read, will re-create: %s", (Object[])new Object[]{this.path, e.getMessage()});
                    }
                }
                in.close();
            }
            return index;
        }
        return null;
    }

    private Index buildIndex() {
        Log.info((String)"  creating missing index for CDI beans archive %s", (Object[])new Object[]{this});
        Indexer indexer = new Indexer();
        this.classEntries().forEach(entry -> {
            try {
                indexer.index(entry.data());
            }
            catch (IOException e) {
                Log.warn((String)"  could not index class %s in %s: %s", (Object[])new Object[]{entry.path(), this, e.getMessage()});
            }
        });
        return indexer.complete();
    }

    private boolean hasSignatureFile() {
        return this.entries().anyMatch(e -> {
            String path = e.path();
            return path.startsWith(SIGNATURE_PREFIX) && path.endsWith(SIGNATURE_SUFFIX);
        });
    }

    private boolean hasEntry(String path) {
        return this.entries().anyMatch(entry -> entry.path().equals(path));
    }

    private Entry findEntry(String path) {
        return this.entries().filter(entry -> entry.path().equals(path)).findFirst().orElse(null);
    }

    private Entry getEntry(String path) {
        return this.entries().filter(entry -> entry.path().equals(path)).findFirst().orElseThrow(() -> new IllegalStateException("Could not get '" + path + "' entry."));
    }

    private Stream<Entry> classEntries() {
        return this.entries().filter(Jar::isNormalClassFile);
    }

    private void copy(OutputStream out, boolean addIndex, boolean stripDebug) throws IOException {
        try (JarOutputStream jar = new JarOutputStream(out);){
            if (addIndex) {
                this.addIndex(jar);
            }
            this.entries().filter(e -> !e.path().equals(JANDEX_INDEX_RESOURCE_PATH)).forEach(entry -> {
                try {
                    jar.putNextEntry(Jar.newJarEntry(entry));
                    if (!entry.isDirectory()) {
                        StreamUtils.transfer((InputStream)this.data((Entry)entry, stripDebug), (OutputStream)jar);
                    }
                    jar.flush();
                    jar.closeEntry();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
    }

    private InputStream data(Entry entry, boolean stripDebug) throws IOException {
        if (stripDebug && Jar.isNormalClassFile(entry) && !this.isSigned) {
            ClassReader reader = new ClassReader(entry.data());
            ClassWriter writer = new ClassWriter(1);
            reader.accept((ClassVisitor)writer, 2);
            return new ByteArrayInputStream(writer.toByteArray());
        }
        return entry.data();
    }

    private static boolean isNormalClassFile(Entry entry) {
        String name = entry.path();
        return name.endsWith(CLASS_FILE_SUFFIX) && !name.equals(MODULE_INFO_CLASS);
    }

    private static JarEntry newJarEntry(Entry entry) {
        int method;
        JarEntry result = new JarEntry(entry.getName());
        if (result.getCreationTime() != null) {
            result.setCreationTime(entry.getCreationTime());
        }
        if (result.getLastModifiedTime() != null) {
            result.setLastModifiedTime(entry.getLastModifiedTime());
        }
        if (entry.getExtra() != null) {
            result.setExtra(entry.getExtra());
        }
        if (result.getComment() != null) {
            result.setComment(entry.getComment());
        }
        if (!(entry.isDirectory() || (method = entry.getMethod()) != 0 && method != 8)) {
            result.setMethod(method);
        }
        return result;
    }

    private void addIndex(JarOutputStream jar) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IndexWriter writer = new IndexWriter((OutputStream)out);
        try {
            writer.write(this.index);
            ByteArrayInputStream data = new ByteArrayInputStream(out.toByteArray());
            JarEntry entry = new JarEntry(JANDEX_INDEX_RESOURCE_PATH);
            entry.setLastModifiedTime(FileTime.fromMillis(System.currentTimeMillis()));
            jar.putNextEntry(entry);
            StreamUtils.transfer((InputStream)data, (OutputStream)jar);
            jar.flush();
            jar.closeEntry();
        }
        catch (IOException e) {
            Log.warn((String)"Unable to add index: %s", (Object[])new Object[]{e});
        }
    }

    private static boolean isMultiRelease(Manifest manifest) {
        return manifest != null && "true".equalsIgnoreCase(Jar.mainAttribute(manifest, Attributes.Name.MULTI_RELEASE));
    }

    private static String mainAttribute(Manifest manifest, Attributes.Name name) {
        Object value;
        if (manifest != null && (value = manifest.getMainAttributes().get(name)) != null) {
            return value.toString();
        }
        return null;
    }

    public final class Entry
    extends JarEntry {
        private Entry(JarEntry entry) {
            super(entry);
        }

        public String path() {
            return this.getName();
        }

        public InputStream data() {
            try {
                return Jar.this.jar.getInputStream(this);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

