/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.linker;

import io.helidon.build.util.FileUtils;
import io.helidon.build.util.OSType;
import io.helidon.linker.StartScript;
import io.helidon.linker.util.Constants;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;

public class StartScriptTemplate
extends StartScript.SimpleTemplate {
    private static final String TEMPLATE_RESOURCE_PATH = Constants.OS == OSType.Windows ? "start-template.ps1" : "start-template.sh";
    private static final String JAR_NAME_VAR = "<JAR_NAME>";
    private static final String DEFAULT_ARGS_VAR = "<DEFAULT_APP_ARGS>";
    private static final String DEFAULT_JVM_VAR = "<DEFAULT_APP_JVM>";
    private static final String DEFAULT_DEBUG_VAR = "<DEFAULT_APP_DEBUG>";
    private static final String HAS_CDS_VAR = "<HAS_CDS>";
    private static final String HAS_DEBUG_VAR = "<HAS_DEBUG>";
    private static final String CDS_UNLOCK_OPTION_VAR = "<CDS_UNLOCK>";
    private static final String DEFAULT_ARGS_DESC_VAR = "<DEFAULT_APP_ARGS_DESC>";
    private static final String DEFAULT_JVM_DESC_VAR = "<DEFAULT_APP_JVM_DESC>";
    private static final String DEFAULT_DEBUG_DESC_VAR = "<DEFAULT_APP_DEBUG_DESC>";
    private static final String EXIT_ON_STARTED_VAR = "<EXIT_ON_STARTED>";
    private static final String STAT_FORMAT_VAR = "<STAT_FORMAT>";
    private static final String MODULES_TIME_STAMP_VAR = "<MODULES_TIME_STAMP>";
    private static final String JAR_TIME_STAMP_VAR = "<JAR_TIME_STAMP>";
    private static final String MODULES_FILE = "lib/modules";
    private static final String OVERRIDES = "Overrides %s${default%s}%s.";
    private static final String CHECK_TIME_STAMPS = Constants.OS == OSType.Windows ? "function checkTimeStamps" : "checkTimeStamps()";
    private static final String SETUP_CDS = Constants.OS == OSType.Windows ? "function setupCds" : "setupCds()";
    private static final String SETS = "Sets default %s.";
    private static final String CDS = "cds";
    private static final String DEBUG = "debug";
    private static final String COPY_INSTRUCTIONS_VAR = "<COPY_INSTRUCTIONS>";
    private static final String NO_CDS = ", use the --noCds option or disable CDS in image generation.";
    private static final String COPY_NOT_SUPPORTED = "Copies are not supported in this Java version: avoid them, use the --noCds option or disable CDS in image generation.";
    private static final String COPY_SUPPORTED = "Use a timestamp preserving copy option (e.g. 'cp -rp'), use the --noCds option or disable CDS in image generation.";

    public StartScriptTemplate() {
        super(TEMPLATE_RESOURCE_PATH);
        this.removeLines((index, line) -> StartScriptTemplate.isComment(line));
    }

    @Override
    public String render(StartScript.TemplateConfig config) {
        if (!config.cdsInstalled()) {
            this.removeFunction(CHECK_TIME_STAMPS);
            this.removeFunction(SETUP_CDS);
            this.removeLines(CDS, true);
        }
        if (!config.debugInstalled()) {
            this.removeLines(DEBUG, true);
        }
        String name = FileUtils.fileName((Path)config.mainJar());
        String jvm = String.join((CharSequence)" ", config.defaultJvmOptions());
        String jvmDesc = StartScriptTemplate.description(config.defaultJvmOptions(), "JVM options", "Jvm");
        String args = String.join((CharSequence)" ", config.defaultArgs());
        String argsDesc = StartScriptTemplate.description(config.defaultArgs(), "arguments", "Args");
        List<String> debugOptions = config.debugInstalled() ? config.defaultDebugOptions() : Collections.emptyList();
        String debug = String.join((CharSequence)" ", debugOptions);
        String debugDesc = StartScriptTemplate.description(debugOptions, "debug options", "Debug");
        String hasCds = config.cdsInstalled() ? "yes" : "";
        String hasDebug = config.debugInstalled() ? "yes" : "";
        String cdsUnlock = config.cdsRequiresUnlock() ? "-XX:+UnlockDiagnosticVMOptions " : "";
        String statFormat = Constants.OS.statFormat();
        String modulesModTime = StartScriptTemplate.lastModifiedTime(config.installHomeDirectory().resolve(MODULES_FILE));
        String jarModTime = StartScriptTemplate.lastModifiedTime(config.mainJar());
        String copyInstructions = config.cdsSupportsImageCopy() ? COPY_SUPPORTED : COPY_NOT_SUPPORTED;
        this.replace(JAR_NAME_VAR, name);
        this.replace(DEFAULT_JVM_VAR, jvm);
        this.replace(DEFAULT_JVM_DESC_VAR, jvmDesc);
        this.replace(DEFAULT_ARGS_VAR, args);
        this.replace(DEFAULT_ARGS_DESC_VAR, argsDesc);
        this.replace(DEFAULT_DEBUG_VAR, debug);
        this.replace(DEFAULT_DEBUG_DESC_VAR, debugDesc);
        this.replace(HAS_CDS_VAR, hasCds);
        this.replace(HAS_DEBUG_VAR, hasDebug);
        this.replace(CDS_UNLOCK_OPTION_VAR, cdsUnlock);
        this.replace(STAT_FORMAT_VAR, statFormat);
        this.replace(MODULES_TIME_STAMP_VAR, modulesModTime);
        this.replace(JAR_TIME_STAMP_VAR, jarModTime);
        this.replace(COPY_INSTRUCTIONS_VAR, copyInstructions);
        this.replace(EXIT_ON_STARTED_VAR, config.exitOnStartedValue());
        return this.toString();
    }

    private static String description(List<String> defaults, String description, String varName) {
        if (defaults.isEmpty()) {
            return String.format(SETS, description);
        }
        String escapedQuote = Constants.OS.escapedQuote();
        return String.format(OVERRIDES, escapedQuote, varName, escapedQuote);
    }

    private void removeFunction(String functionName) {
        int startIndex = this.indexOf(0, functionName, false);
        int endIndex = this.indexOfEquals(startIndex, "}") + 1;
        this.removeLines((index, line) -> index >= startIndex && index <= endIndex);
    }

    private static boolean isComment(String line) {
        int length = line.length();
        return length > 0 && line.charAt(0) == '#' && (length == 1 || line.charAt(1) != '!');
    }
}

