/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.linker.util;

import io.helidon.build.util.OSType;
import io.helidon.build.util.StyleFunction;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

public final class Constants {
    public static final OSType OS = OSType.currentOS();
    public static final int MINIMUM_JDK_VERSION = 9;
    public static final boolean DOCKER_BUILD = "true".equals(System.getProperty("docker.build"));
    public static final int MINIMUM_DOCKER_JDK_VERSION = 10;
    public static final boolean JDEPS_REQUIRES_MISSING_DEPS_OPTION;
    public static final boolean CDS_REQUIRES_UNLOCK_OPTION;
    public static final String CDS_UNLOCK_OPTIONS = "-XX:+UnlockDiagnosticVMOptions";
    public static final boolean CDS_SUPPORTS_IMAGE_COPY;
    public static final String EOL;
    public static final String DIR_SEP;
    public static final String JRI_DIR_SUFFIX = "-jri";
    public static final Function<String, String> INDENT;
    public static final Set<String> EXCLUDED_MODULES;
    public static final String DEBUGGER_MODULE = "jdk.jdwp.agent";
    public static final String WINDOWS_SCRIPT_EXECUTION_ERROR = "FullyQualifiedErrorId";
    public static final List<String> WINDOWS_SCRIPT_EXECUTION_POLICY_ERROR;
    public static final String WINDOWS_SCRIPT_EXECUTION_POLICY_ERROR_HELP;

    private Constants() {
    }

    static {
        EOL = System.getProperty("line.separator");
        DIR_SEP = File.separator;
        INDENT = line -> "    " + line;
        EXCLUDED_MODULES = Set.of("java.xml.ws.annotation");
        WINDOWS_SCRIPT_EXECUTION_POLICY_ERROR = List.of("UnauthorizedAccess", "Execution", "Policies");
        WINDOWS_SCRIPT_EXECUTION_POLICY_ERROR_HELP = EOL + EOL + StyleFunction.Bold.apply((Object)"To enable script execution, run the following command: ") + EOL + EOL + "    " + StyleFunction.BoldBrightYellow.apply((Object)"powershell Set-ExecutionPolicy -Scope CurrentUser -ExecutionPolicy RemoteSigned") + EOL + EOL + StyleFunction.Bold.apply((Object)"and answer 'Y' if prompted.");
        Runtime.Version version = Runtime.version();
        int feature = version.feature();
        int update = version.update();
        JDEPS_REQUIRES_MISSING_DEPS_OPTION = feature > 11 || feature == 11 && update >= 11;
        CDS_REQUIRES_UNLOCK_OPTION = feature <= 10;
        CDS_SUPPORTS_IMAGE_COPY = feature >= 10;
    }
}

