/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.linker;

import io.helidon.build.common.InputStreams;
import io.helidon.build.common.logging.Log;
import io.helidon.build.linker.Jar;
import io.helidon.build.linker.util.Constants;
import io.helidon.build.linker.util.JavaRuntime;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.module.ModuleDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.spi.ToolProvider;
import java.util.stream.Stream;

public final class JavaDependencies {
    private static final ToolProvider JDEPS = ToolProvider.findFirst("jdeps").orElseThrow(() -> new IllegalStateException("jdeps not found"));
    private static final String MULTI_RELEASE_ARG = "--multi-release";
    private static final String SYSTEM_ARG = "--system";
    private static final String LIST_DEPS_ARG = "--list-deps";
    private static final String IGNORE_MISSING_DEPS_ARG = "--ignore-missing-deps";
    private static final String JAVA_BASE_MODULE_NAME = "java.base";
    private static final Set<String> KNOWN_SPLIT_PACKAGES = Set.of("javax.annotation", "javax.activation");
    private static final Map<String, BiConsumer<String, Jar>> PREFIX_HANDLERS = Map.of("split package", JavaDependencies::split, "not found", JavaDependencies::ignore, "unnamed module", JavaDependencies::ignore, "jdk8internals", JavaDependencies::debug, "JDK removed internal API", JavaDependencies::debug);
    private final JavaRuntime javaHome;
    private final Set<String> javaModuleNames;
    private final Set<String> dependencies;

    public static Set<String> collect(Stream<Jar> jars, JavaRuntime javaHome) {
        return new JavaDependencies(javaHome).collect(jars);
    }

    private JavaDependencies(JavaRuntime javaHome) {
        this.javaHome = Objects.requireNonNull(javaHome);
        this.javaModuleNames = javaHome.moduleNames();
        this.dependencies = new HashSet<String>();
        this.dependencies.add(JAVA_BASE_MODULE_NAME);
    }

    private Set<String> collect(Stream<Jar> jars) {
        jars.forEach(jar -> {
            if (jar.hasModuleDescriptor()) {
                this.addModule(jar.moduleDescriptor());
            } else {
                Optional<Jar.Entry> moduleInfo = jar.entries().filter(it -> it.getName().endsWith("/module-info.class")).findFirst();
                if (moduleInfo.isPresent()) {
                    this.addModule(moduleInfo.get());
                } else {
                    this.addJar((Jar)jar);
                }
            }
        });
        HashSet<String> closure = new HashSet<String>();
        this.dependencies.forEach(moduleName -> this.addDependency((String)moduleName, (Set<String>)closure));
        return closure;
    }

    private void addDependency(String moduleName, Set<String> result) {
        if (!result.contains(moduleName)) {
            result.add(moduleName);
            Jar jar = this.javaHome.jmod(moduleName);
            jar.moduleDescriptor().requires().forEach(r -> this.addDependency(r.name(), result));
        }
    }

    private void addModule(Jar.Entry entry) {
        try {
            this.addModule(ModuleDescriptor.read(entry.data()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void addModule(ModuleDescriptor descriptor) {
        Log.info((String)"  checking module %s", (Object[])new Object[]{descriptor.name()});
        descriptor.requires().stream().map(ModuleDescriptor.Requires::name).filter(this.javaModuleNames::contains).forEach(this.dependencies::add);
    }

    private void addJar(Jar jar) {
        Log.info((String)"  checking %s", (Object[])new Object[]{jar});
        ArrayList<String> args = new ArrayList<String>();
        if (!this.javaHome.isCurrent()) {
            args.add(SYSTEM_ARG);
            args.add(this.javaHome.path().toString());
        }
        if (jar.isMultiRelease()) {
            args.add(MULTI_RELEASE_ARG);
            args.add(this.javaHome.featureVersion());
        }
        if (Constants.JDEPS_REQUIRES_MISSING_DEPS_OPTION) {
            args.add(IGNORE_MISSING_DEPS_ARG);
        }
        args.add(LIST_DEPS_ARG);
        args.add(jar.path().toString());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int result = JDEPS.run(InputStreams.toPrintStream((OutputStream)out, (boolean)false), System.err, args.toArray(new String[0]));
        if (result != 0) {
            throw new RuntimeException("Could not collect dependencies of " + jar);
        }
        Arrays.stream(InputStreams.toString((ByteArrayOutputStream)out).split(Constants.EOL)).map(String::trim).filter(line -> !line.isEmpty()).forEach(line -> this.handleJdepsResultLine((String)line, jar));
    }

    private void handleJdepsResultLine(String line, Jar jar) {
        if (this.javaModuleNames.contains(line)) {
            this.dependencies.add(line);
        } else {
            for (Map.Entry<String, BiConsumer<String, Jar>> entry : PREFIX_HANDLERS.entrySet()) {
                if (!line.contains(entry.getKey())) continue;
                entry.getValue().accept(line, jar);
                return;
            }
            if (!line.contains(":") && line.contains("/")) {
                this.handleJdepsResultLine(line.split("/")[0], jar);
            } else if (!Constants.EXCLUDED_MODULES.contains(line)) {
                throw new IllegalStateException("Unhandled dependency: " + JavaDependencies.toString(line, jar));
            }
        }
    }

    private static String toString(String line, Jar jar) {
        return jar + " -> " + line;
    }

    private static void ignore(String line, Jar jar) {
    }

    private static void debug(String line, Jar jar) {
        Log.debug((String)JavaDependencies.toString(line, jar), (Object[])new Object[0]);
    }

    private static void warn(String line, Jar jar) {
        Log.warn((String)JavaDependencies.toString(line, jar), (Object[])new Object[0]);
    }

    private static void split(String line, Jar jar) {
        for (String ignored : KNOWN_SPLIT_PACKAGES) {
            if (!line.contains(ignored)) continue;
            return;
        }
        JavaDependencies.warn(line, jar);
    }
}

