/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.link;

import io.helidon.build.util.Log;
import io.helidon.build.util.MavenLogWriter;
import io.helidon.linker.Configuration;
import io.helidon.linker.Linker;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="jlink-image", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class JLinkImageMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    private File buildDirectory;
    @Parameter(defaultValue="${project.build.finalName}", readonly=true, required=true)
    private String finalName;
    @Parameter(defaultValue="true", property="jlink.image.addClassDataSharingArchive")
    private boolean addClassDataSharingArchive;
    @Parameter(defaultValue="true", property="jlink.image.testImage")
    private boolean testImage;
    @Parameter(property="jlink.image.defaultJvmOptions")
    private List<String> defaultJvmOptions;
    @Parameter(property="jlink.image.defaultDebugOptions")
    private List<String> defaultDebugOptions;
    @Parameter(property="jlink.image.defaultArgs")
    private List<String> defaultArgs;
    @Parameter(property="jlink.image.additionalJlinkArgs")
    private List<String> additionalJlinkArgs;
    @Parameter(property="jlink.image.additionalModules")
    private Set<String> additionalModules;
    @Parameter(defaultValue="60", property="jlink.image.maxAppStartSeconds")
    private int maxAppStartSeconds;
    @Parameter(defaultValue="false", property="jlink.image.stripDebug")
    private boolean stripDebug;
    @Parameter(defaultValue="false", property="jlink.image.skip")
    private boolean skipJavaImage;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipJavaImage) {
            this.getLog().info((CharSequence)"Skipping execution.");
            return;
        }
        Path buildDir = this.buildDirectory.toPath();
        Path mainJar = this.mainJar(buildDir);
        Path outputDir = buildDir.resolve(this.finalName + "-jri");
        MavenLogWriter writer = new MavenLogWriter(this.getLog());
        try {
            Configuration config = Configuration.builder().logWriter((Log.Writer)writer).verbose(this.getLog().isDebugEnabled()).mainJar(mainJar).defaultJvmOptions(this.defaultJvmOptions).defaultArgs(this.defaultArgs).additionalJlinkArgs(this.additionalJlinkArgs).defaultDebugOptions(this.defaultDebugOptions).additionalModules(this.additionalModules).cds(this.addClassDataSharingArchive).stripDebug(this.stripDebug).test(this.testImage).jriDirectory(outputDir).maxAppStartSeconds(this.maxAppStartSeconds).replace(true).build();
            Linker.linker((Configuration)config).link();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Image generation error", e);
        }
    }

    private Path mainJar(Path buildDir) throws MojoFailureException {
        File artifact = this.project.getArtifact().getFile();
        Path result = artifact == null ? buildDir.resolve(this.project.getBuild().getFinalName() + ".jar") : artifact.toPath();
        if (!Files.exists(result, new LinkOption[0])) {
            throw new MojoFailureException("Artifact does not exist: " + result.toAbsolutePath());
        }
        return result;
    }
}

