/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven;

import io.helidon.build.licensing.Report;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="report", aggregator=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class ReportMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="skip", defaultValue="false", readonly=true, required=true)
    private Boolean skip;
    @Parameter(property="failOnError", defaultValue="false", readonly=true, required=true)
    private Boolean failOnError;
    @Parameter(property="modules", readonly=true)
    private String modules;
    @Parameter(property="inputFileName", defaultValue="HELIDON_THIRD_PARTY_LICENSES.xml", required=true)
    private String inputFileName;
    @Parameter(property="inputFileDir")
    private String inputFileDir;
    @Parameter(property="outputFileFormat", defaultValue="txt", required=true)
    private String outputFileFormat;
    @Parameter(property="outputFileName", defaultValue="HELIDON_THIRD_PARTY_LICENSES.txt", required=true)
    private String outputFileName;
    @Parameter(property="outputFileDir", defaultValue="${project.build.directory}")
    private String outputFileDir;
    @Parameter(property="includeVersion", defaultValue="false")
    private String includeVersion;

    public void execute() throws MojoExecutionException {
        block5: {
            if (this.skip.booleanValue()) {
                return;
            }
            Report.Builder builder = Report.builder().inputFileName(this.inputFileName).moduleList(this.modules).inputFileDir(this.inputFileDir).outputFileFormat(this.outputFileFormat).outputFileName(this.outputFileName).outputFileDir(this.outputFileDir).includeVersion(Boolean.valueOf(this.includeVersion)).outputHandler(s -> this.getLog().info((CharSequence)s)).errorHandler(s -> this.getLog().error((CharSequence)s));
            if (this.modules == null || this.modules.isEmpty()) {
                this.getLog().debug((CharSequence)("No module list configured. Using dependencies of " + this.project.getArtifactId()));
                Set<String> moduleList = this.getHelidonDependencies(this.project);
                this.getLog().debug((CharSequence)("Scanned Modules: " + moduleList));
                builder.moduleList(moduleList);
            } else {
                this.getLog().debug((CharSequence)("Configured Modules: " + this.modules));
                builder.moduleList(this.modules);
            }
            try {
                builder.build().execute();
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)e.toString());
                if (!this.failOnError.booleanValue()) break block5;
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
    }

    private Set<String> getHelidonDependencies(MavenProject project) {
        Set artifacts;
        TreeSet<String> helidonDependencies = new TreeSet<String>();
        this.getLog().info((CharSequence)("Scanning " + project.getName()));
        String gid = project.getGroupId();
        if (this.isHelidonGroup(gid)) {
            helidonDependencies.add(project.getArtifactId());
        }
        if ((artifacts = project.getArtifacts()) != null && !artifacts.isEmpty()) {
            for (Artifact artifact : artifacts) {
                gid = artifact.getGroupId();
                if (!this.isHelidonGroup(gid)) continue;
                helidonDependencies.add(artifact.getArtifactId());
            }
        } else {
            this.getLog().debug((CharSequence)("No dependencies for " + project.getName()));
        }
        List subProjects = project.getCollectedProjects();
        if (subProjects != null && !subProjects.isEmpty()) {
            for (MavenProject p : subProjects) {
                helidonDependencies.addAll(this.getHelidonDependencies(p));
            }
        }
        return helidonDependencies;
    }

    private boolean isHelidonGroup(String name) {
        return name != null && name.startsWith("io.helidon");
    }
}

