/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.services;

import io.helidon.build.common.logging.Log;
import java.io.File;
import java.io.IOException;
import java.lang.module.ModuleDescriptor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="services", defaultPhase=LifecyclePhase.COMPILE, threadSafe=true)
public class ServicesMojo
extends AbstractMojo {
    @Parameter(defaultValue="false", property="helidon.services.skip")
    private boolean skip;
    @Parameter(defaultValue="${project.build.sourceDirectory}")
    private File javaDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File targetDirectory;
    @Parameter(defaultValue="${project.basedir}")
    private File baseDir;
    @Parameter(defaultValue="${project.basedir}/src/main/resources")
    private File resourceDirectory;
    @Parameter(property="helidon.services.failOnMissingModuleInfo", defaultValue="true")
    private boolean failOnMissingModuleInfo;
    @Parameter(property="helidon.services.mode", defaultValue="fail")
    private String mode;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="helidon.services.comment", defaultValue="# This file was generated by Helidon services Maven plugin.")
    private String comment;
    @Parameter(property="helidon.services.addComment", defaultValue="true")
    private boolean addComment;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            Log.info((String)"Skipping execution.", (Object[])new Object[0]);
            return;
        }
        if ("pom".equals(this.project.getPackaging())) {
            Log.info((String)"Skipping POM packaging project.", (Object[])new Object[0]);
            return;
        }
        Path sourcePath = this.javaDirectory.toPath();
        if (Files.notExists(sourcePath, new LinkOption[0])) {
            Log.info((String)("$(YELLOW Skipping project with no sources): " + sourcePath), (Object[])new Object[0]);
            return;
        }
        Path targetPath = this.targetDirectory.toPath();
        Path moduleInfo = targetPath.resolve("module-info.class");
        if (Files.notExists(moduleInfo, new LinkOption[0])) {
            if (this.failOnMissingModuleInfo) {
                throw new MojoExecutionException("Project does not contain module-info.class: " + moduleInfo);
            }
            Log.info((String)"$(YELLOW Skipping project with no module-info.)", (Object[])new Object[0]);
            return;
        }
        Log.info((String)("Mode is $(YELLOW " + this.mode + ")"), (Object[])new Object[0]);
        Path targetServices = targetPath.resolve("META-INF/services");
        if ("validate".equals(this.mode)) {
            this.validate(moduleInfo, this.existing(targetServices));
            return;
        }
        Path sourceServices = this.resourceDirectory.toPath().resolve("META-INF/services");
        List<Path> existing = this.existing(sourceServices);
        if ("fail".equals(this.mode)) {
            if (!existing.isEmpty()) {
                throw new MojoExecutionException("Project must not contain META-INF/services in source folder");
            }
            this.mode = "overwrite";
        }
        if ("ignore".equals(this.mode)) {
            if (!existing.isEmpty()) {
                Log.info((String)"Ignoring module-info.java, existing META-INF/services in source folder", (Object[])new Object[0]);
                Log.verbose((String)("Existing files: " + existing), (Object[])new Object[0]);
                return;
            }
            this.mode = "overwrite";
        }
        if ("overwrite".equals(this.mode)) {
            this.deleteExisting(targetServices);
            try {
                this.createServices(targetServices, moduleInfo);
            }
            catch (IOException e) {
                throw new MojoFailureException("Failed to create META-INF/services in target folder for " + moduleInfo, (Throwable)e);
            }
            return;
        }
        if ("clean".equals(this.mode)) {
            if (!existing.isEmpty()) {
                this.clean(sourceServices, moduleInfo, existing);
            }
            return;
        }
        throw new MojoExecutionException("Invalid plugin mode '" + this.mode + "'");
    }

    private void validate(Path moduleInfo, List<Path> existing) throws MojoFailureException, MojoExecutionException {
        Map<String, Provider> fromModuleInfo = this.loadModuleInfo(moduleInfo);
        Map<String, Provider> fromMetaInf = this.loadProviders(existing);
        if (fromModuleInfo.isEmpty() && fromMetaInf.isEmpty()) {
            Log.info((String)"There are no services defined in module.", (Object[])new Object[0]);
            return;
        }
        LinkedList problems = new LinkedList();
        fromMetaInf.forEach((service, provider) -> {
            if (!fromModuleInfo.containsKey(service)) {
                problems.add("Service " + service + " missing from module-info.java, providers: " + provider.providers());
            } else {
                Provider moduleInfoProvider = (Provider)fromModuleInfo.get(service);
                if (!moduleInfoProvider.providers().equals(provider.providers)) {
                    LinkedHashSet<String> missing = new LinkedHashSet<String>(provider.providers());
                    moduleInfoProvider.providers().forEach(missing::remove);
                    if (!missing.isEmpty()) {
                        problems.add("Service " + service + " is missing the following providers in module-info.java: " + missing);
                    }
                }
            }
        });
        fromModuleInfo.forEach((service, provider) -> {
            if (!fromMetaInf.containsKey(service)) {
                problems.add("Service " + service + " missing from META-INF/services, providers: " + provider.providers());
            } else {
                Provider metaInfProvider = (Provider)fromMetaInf.get(service);
                if (!metaInfProvider.providers().equals(provider.providers)) {
                    LinkedHashSet<String> missing = new LinkedHashSet<String>(provider.providers());
                    metaInfProvider.providers().forEach(missing::remove);
                    if (!missing.isEmpty()) {
                        problems.add("Service " + service + " is missing the following providers in META-INF/services: " + missing);
                    }
                }
            }
        });
        if (!problems.isEmpty()) {
            throw new MojoExecutionException("Mismatch between module-info.java and META-INF/services:\n" + String.join((CharSequence)"\n", problems));
        }
        Log.info((String)"Services are valid.", (Object[])new Object[0]);
    }

    private void clean(Path metaInfServices, Path moduleInfo, List<Path> existing) throws MojoFailureException, MojoExecutionException {
        Map<String, Provider> fromModuleInfo = this.loadModuleInfo(moduleInfo);
        if (fromModuleInfo.isEmpty()) {
            throw new MojoExecutionException("module-info.java does not define any service providers, yet the following providers are defined in META-INF/services: " + this.relativize(metaInfServices, existing));
        }
        Map<String, Provider> fromMetaInf = this.loadProviders(existing);
        LinkedList problems = new LinkedList();
        fromMetaInf.forEach((service, provider) -> {
            if (!fromModuleInfo.containsKey(service)) {
                problems.add("Service " + service + " missing from module-info.java, providers: " + provider.providers());
            } else {
                Provider moduleInfoProvider = (Provider)fromModuleInfo.get(service);
                if (!moduleInfoProvider.providers().equals(provider.providers)) {
                    LinkedHashSet<String> missing = new LinkedHashSet<String>(provider.providers());
                    moduleInfoProvider.providers().forEach(missing::remove);
                    if (!missing.isEmpty()) {
                        problems.add("Service " + service + " is missing the following providers in module-info.java: " + missing);
                    }
                }
            }
        });
        if (!problems.isEmpty()) {
            throw new MojoExecutionException("Mismatch between module-info.java and META-INF/services:\n" + String.join((CharSequence)"\n", problems));
        }
        Path resourcePath = this.resourceDirectory.toPath();
        Path srcMetaInfServices = resourcePath.resolve("META-INF/services");
        if (!Files.exists(srcMetaInfServices, new LinkOption[0])) {
            throw new MojoExecutionException("Cannot clean META-INF/services in sources, as path does not exist: " + srcMetaInfServices);
        }
        Path basePath = this.baseDir.toPath();
        for (Path path : existing) {
            Path source = srcMetaInfServices.resolve(path.getFileName());
            if (!Files.exists(source, new LinkOption[0])) {
                throw new MojoExecutionException("Cannot clean META-INF/services, file " + path + " exists in output, but file " + source + " does not exist in sources");
            }
            Log.info((String)("Deleting source file " + basePath.relativize(source)), (Object[])new Object[0]);
            try {
                Files.delete(source);
            }
            catch (IOException e) {
                throw new MojoFailureException("Failed to delete file " + source, (Throwable)e);
            }
        }
        try {
            Files.delete(srcMetaInfServices);
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to delete directory " + srcMetaInfServices, (Throwable)e);
        }
    }

    private List<String> relativize(Path metaInfServices, List<Path> existing) {
        ArrayList<String> relative = new ArrayList<String>(existing.size());
        for (Path path : existing) {
            relative.add(metaInfServices.relativize(path).toString());
        }
        return relative;
    }

    private Map<String, Provider> loadProviders(List<Path> existing) throws MojoFailureException {
        HashMap<String, Provider> providerMap = new HashMap<String, Provider>();
        for (Path path : existing) {
            String service = path.getFileName().toString();
            try {
                List<String> lines = Files.readAllLines(path);
                ArrayList<String> providers = new ArrayList<String>(lines.size());
                for (String line : lines) {
                    if (line.startsWith("#") || line.isBlank()) continue;
                    providers.add(line);
                }
                providerMap.put(service, Provider.create(service, providers));
            }
            catch (IOException e) {
                throw new MojoFailureException("Failed to read service provider definition: " + path);
            }
        }
        return providerMap;
    }

    private void createServices(Path metaInfServices, Path moduleInfo) throws IOException, MojoFailureException {
        metaInfServices = Files.createDirectories(metaInfServices, new FileAttribute[0]);
        Map<String, Provider> provides = this.loadModuleInfo(moduleInfo);
        if (provides.isEmpty()) {
            Log.info((String)"There are no services provided by this module.", (Object[])new Object[0]);
            return;
        }
        for (Provider provide : provides.values()) {
            Path serviceFile = metaInfServices.resolve(provide.service());
            ArrayList<String> providers = new ArrayList<String>();
            if (this.addComment) {
                providers.add(this.comment);
            }
            providers.addAll(provide.providers());
            Log.verbose((String)("Creating service file " + serviceFile), (Object[])new Object[0]);
            Log.debug((String)("File lines: \n" + String.join((CharSequence)"\n", providers)), (Object[])new Object[0]);
            Files.write(serviceFile, providers, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        Log.info((String)("Created $(CYAN " + provides.size() + ") META-INF/services files"), (Object[])new Object[0]);
    }

    private Map<String, Provider> loadModuleInfo(Path moduleInfo) throws MojoFailureException {
        try {
            ModuleDescriptor module = ModuleDescriptor.read(Files.newInputStream(moduleInfo, new OpenOption[0]));
            return module.provides().stream().map(Provider::create).collect(Collectors.toMap(Provider::service, Function.identity()));
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to load module descriptor " + moduleInfo, (Throwable)e);
        }
    }

    private List<Path> existing(Path metaInfServices) throws MojoFailureException {
        if (!Files.exists(metaInfServices, new LinkOption[0])) {
            return List.of();
        }
        try {
            return Files.list(metaInfServices).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to list META-INF/services directory " + metaInfServices, (Throwable)e);
        }
    }

    private void deleteExisting(Path metaInfServices) throws MojoFailureException {
        try {
            for (Path path : this.existing(metaInfServices)) {
                Files.delete(path);
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to delete existing META-INF/services records", (Throwable)e);
        }
    }

    static final class Provider {
        private final String service;
        private final Set<String> providers;

        private Provider(String service, List<String> providers) {
            this.service = service;
            this.providers = new LinkedHashSet<String>(providers);
        }

        static Provider create(ModuleDescriptor.Provides provides) {
            String service = provides.service();
            List<String> providers = provides.providers();
            return new Provider(service, providers);
        }

        public static Provider create(String service, List<String> providers) {
            return new Provider(service, providers);
        }

        String service() {
            return this.service;
        }

        Set<String> providers() {
            return this.providers;
        }
    }
}

