/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.util;

import io.helidon.build.util.AnsiConsoleInstaller;
import io.helidon.build.util.PrintStreams;
import org.fusesource.jansi.Ansi;

public class ConsoleUtils {
    private static final boolean ENABLED = AnsiConsoleInstaller.areAnsiEscapesEnabled();
    private static final char FIRST_ESC_CHAR = '\u001b';
    private static final char SECOND_ESC_CHAR = '[';
    private static final char[] SHOW_CURSOR = new char[]{'\u001b', '[', '?', '2', '5', 'h'};
    private static final char[] HIDE_CURSOR = new char[]{'\u001b', '[', '?', '2', '5', 'l'};

    public static boolean clearScreen() {
        return ConsoleUtils.clearScreen(0);
    }

    public static boolean clearScreen(int startRow) {
        if (ENABLED) {
            System.out.print(Ansi.ansi().cursor(startRow, 0).eraseScreen());
            System.out.flush();
            return true;
        }
        return false;
    }

    public static boolean rewriteLine(String message) {
        return ConsoleUtils.rewriteLine(message.length(), message);
    }

    public static boolean rewriteLine(int charsToBackUp, String message) {
        if (ENABLED) {
            System.out.print(Ansi.ansi().cursorLeft(charsToBackUp).a(message));
            System.out.flush();
            return true;
        }
        return false;
    }

    public static boolean hideCursor() {
        if (ENABLED) {
            System.out.print(HIDE_CURSOR);
            System.out.flush();
            return true;
        }
        return false;
    }

    public static boolean showCursor() {
        if (ENABLED) {
            System.out.print(SHOW_CURSOR);
            System.out.flush();
            return true;
        }
        return false;
    }

    public static void reset() {
        if (ENABLED) {
            PrintStreams.STDOUT.println(Ansi.ansi().reset().toString());
            PrintStreams.STDOUT.flush();
        }
    }

    private ConsoleUtils() {
    }
}

