/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.util;

import io.helidon.build.util.AnsiConsoleInstaller;
import io.helidon.build.util.Constants;
import io.helidon.build.util.Log;
import io.helidon.build.util.Style;
import io.helidon.build.util.StyleFunction;
import io.helidon.build.util.StyleRenderer;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;

public final class LogFormatter {
    private static final boolean STYLES_ENABLED = AnsiConsoleInstaller.areAnsiEscapesEnabled();
    private static final String WARN_PREFIX = STYLES_ENABLED ? StyleFunction.BoldYellow.apply("warning: ") : "WARNING: ";
    private static final String ERROR_PREFIX = STYLES_ENABLED ? StyleFunction.Red.apply("error: ") : "ERROR: ";
    private static final Map<Log.Level, StyleFunction> DEFAULT_STYLES = LogFormatter.defaultStyles();

    private LogFormatter() {
    }

    public static Function<String, String> of(Log.Level level) {
        return s -> LogFormatter.formatEntry(level, s);
    }

    public static String format(Log.Level level, Throwable thrown, String message, Object ... args) {
        String msg = LogFormatter.formatEntry(level, thrown, message, args);
        switch (level) {
            case DEBUG: 
            case VERBOSE: 
            case INFO: {
                return msg;
            }
            case WARN: {
                return WARN_PREFIX + msg;
            }
            case ERROR: {
                return ERROR_PREFIX + msg;
            }
        }
        throw new Error();
    }

    private static Map<Log.Level, StyleFunction> defaultStyles() {
        EnumMap<Log.Level, StyleFunction> styles = new EnumMap<Log.Level, StyleFunction>(Log.Level.class);
        styles.put(Log.Level.DEBUG, StyleFunction.Italic);
        styles.put(Log.Level.VERBOSE, StyleFunction.Plain);
        styles.put(Log.Level.INFO, StyleFunction.Plain);
        styles.put(Log.Level.WARN, StyleFunction.Plain);
        styles.put(Log.Level.ERROR, StyleFunction.ItalicRed);
        return styles;
    }

    private static String formatEntry(Log.Level level, String message) {
        return LogFormatter.toStyled(level, StyleRenderer.render(message));
    }

    private static String formatEntry(Log.Level level, Throwable thrown, String message, Object ... args) {
        String rendered = StyleRenderer.render(message, args);
        String styled = LogFormatter.toStyled(level, rendered);
        String trace = LogFormatter.toStyled(level, thrown);
        if (trace == null) {
            return styled;
        }
        if (styled.isEmpty()) {
            return trace;
        }
        return styled + Constants.EOL + trace;
    }

    private static String toStyled(Log.Level level, String message) {
        return Style.isStyled(message) ? message : LogFormatter.style(level, message);
    }

    private static String toStyled(Log.Level level, Throwable thrown) {
        if (thrown != null) {
            if (LogFormatter.isDebug(level)) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                try {
                    thrown.printStackTrace(pw);
                    String string = LogFormatter.style(Log.Level.DEBUG, sw.toString());
                    pw.close();
                    return string;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            pw.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {}
                }
            } else if (LogFormatter.isVerbose(level)) {
                return LogFormatter.style(Log.Level.DEBUG, thrown.toString());
            }
        }
        return null;
    }

    private static String style(Log.Level level, String message) {
        StyleFunction style = DEFAULT_STYLES.get((Object)level);
        return style == StyleFunction.Plain ? message : style.apply(message);
    }

    private static boolean isDebug(Log.Level level) {
        return Log.Level.DEBUG.ordinal() >= level.ordinal();
    }

    private static boolean isVerbose(Log.Level level) {
        return Log.Level.VERBOSE.ordinal() >= level.ordinal();
    }
}

