/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.util;

import io.helidon.build.util.Log;
import io.helidon.build.util.StyleRenderer;

public class MavenLogWriter
implements Log.Writer {
    private final org.apache.maven.plugin.logging.Log log;

    public static void install(org.apache.maven.plugin.logging.Log mavenLog) {
        Log.writer(new MavenLogWriter(mavenLog));
    }

    public MavenLogWriter(org.apache.maven.plugin.logging.Log log) {
        this.log = log;
    }

    @Override
    public boolean isDebug() {
        return this.log.isDebugEnabled();
    }

    @Override
    public boolean isVerbose() {
        return this.isDebug();
    }

    @Override
    public void write(Log.Level level, Throwable thrown, String message, Object ... args) {
        switch (level) {
            case DEBUG: 
            case VERBOSE: {
                if (!this.log.isDebugEnabled()) break;
                String msg = StyleRenderer.render(message, args);
                if (thrown == null) {
                    this.log.debug((CharSequence)msg);
                    break;
                }
                this.log.debug((CharSequence)msg, thrown);
                break;
            }
            case INFO: {
                if (!this.log.isInfoEnabled()) break;
                String msg = StyleRenderer.render(message, args);
                if (thrown == null) {
                    this.log.info((CharSequence)msg);
                    break;
                }
                this.log.info((CharSequence)msg, thrown);
                break;
            }
            case WARN: {
                if (!this.log.isWarnEnabled()) break;
                String msg = StyleRenderer.render(message, args);
                if (thrown == null) {
                    this.log.warn((CharSequence)msg);
                    break;
                }
                this.log.warn((CharSequence)msg, thrown);
                break;
            }
            case ERROR: {
                if (!this.log.isErrorEnabled()) break;
                String msg = StyleRenderer.render(message, args);
                if (thrown == null) {
                    this.log.error((CharSequence)msg);
                    break;
                }
                this.log.error((CharSequence)msg, thrown);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }
}

