/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.util;

import io.helidon.build.util.Constants;
import io.helidon.build.util.StyleFunction;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public final class PrintStreams {
    private static final String FAST_STREAMS_PROP = "io.helidon.build.util.fast.streams";
    private static final boolean FAST_STREAMS = Boolean.parseBoolean(System.getProperty("io.helidon.build.util.fast.streams", "true"));
    public static final PrintStream STDOUT = FAST_STREAMS ? new FastPrintStream(FileDescriptor.out) : System.out;
    public static final PrintStream STDERR = FAST_STREAMS ? new FastPrintStream(FileDescriptor.err) : System.err;
    public static final PrintStream RED_STDERR = new TransformedPrintStream(STDERR, StyleFunction.Red::apply);
    public static final PrintStream DEVNULL = new PrintStream(OutputStream.nullOutputStream());

    private PrintStreams() {
    }

    public static PrintStream autoFlush(PrintStream delegate) {
        return PrintStreams.delegate(delegate, (p, s) -> {
            p.print((String)s);
            p.flush();
        });
    }

    public static PrintStream delegate(PrintStream delegate, BiConsumer<PrintStream, String> function) {
        return new FunctionalDelegatePrintStream(delegate, function);
    }

    public static PrintStream accept(PrintStream delegate, Consumer<String> consumer) {
        return new ObservedPrintStream(delegate, consumer);
    }

    public static PrintStream apply(PrintStream delegate, Function<String, String> function) {
        return new TransformedPrintStream(delegate, function);
    }

    private static final class FastPrintStream
    extends PrintStream {
        FastPrintStream(FileDescriptor desc) {
            super((OutputStream)new FileOutputStream(desc), false, StandardCharsets.US_ASCII);
        }
    }

    private static final class FunctionalDelegatePrintStream
    extends PrintStreamAdapter {
        private final PrintStream delegate;
        private final BiConsumer<PrintStream, String> function;

        FunctionalDelegatePrintStream(PrintStream delegate, BiConsumer<PrintStream, String> function) {
            this.delegate = delegate;
            this.function = function;
        }

        @Override
        public void print(String s) {
            if (s != null && !s.isEmpty()) {
                this.function.accept(this.delegate, s);
            }
        }

        @Override
        public void flush() {
            this.delegate.flush();
        }
    }

    private static final class TransformedPrintStream
    extends PrintStreamAdapter {
        private final PrintStream delegate;
        private final Function<String, String> function;

        TransformedPrintStream(PrintStream delegate, Function<String, String> function) {
            this.delegate = delegate;
            this.function = function;
        }

        @Override
        public void print(String s) {
            if (s != null && !s.isEmpty()) {
                this.delegate.print(this.function.apply(s));
            }
        }

        @Override
        public void flush() {
            this.delegate.flush();
        }
    }

    private static final class ObservedPrintStream
    extends PrintStreamAdapter {
        private final PrintStream delegate;
        private final Consumer<String> consumer;

        ObservedPrintStream(PrintStream delegate, Consumer<String> consumer) {
            this.delegate = delegate;
            this.consumer = consumer;
        }

        @Override
        public void print(String s) {
            if (s != null && !s.isEmpty()) {
                this.delegate.print(s);
                this.consumer.accept(s);
            }
        }

        @Override
        public void flush() {
            this.delegate.flush();
        }
    }

    public static abstract class PrintStreamAdapter
    extends PrintStream {
        protected PrintStreamAdapter() {
            super(OutputStream.nullOutputStream());
        }

        @Override
        public abstract void print(String var1);

        @Override
        public abstract void flush();

        @Override
        public void println() {
            this.println(Constants.EOL);
        }

        @Override
        public void println(String s) {
            if (s != null) {
                this.print(s + Constants.EOL);
            }
        }

        @Override
        public void print(boolean x) {
            this.print(String.valueOf(x));
        }

        @Override
        public void print(char x) {
            this.print(String.valueOf(x));
        }

        @Override
        public void print(int x) {
            this.print(String.valueOf(x));
        }

        @Override
        public void print(long x) {
            this.print(String.valueOf(x));
        }

        @Override
        public void print(float x) {
            this.print(String.valueOf(x));
        }

        @Override
        public void print(double x) {
            this.print(String.valueOf(x));
        }

        @Override
        public void print(char[] x) {
            this.print(String.valueOf(x));
        }

        @Override
        public void print(Object x) {
            this.print(String.valueOf(x));
        }

        @Override
        public void println(boolean x) {
            this.println(String.valueOf(x));
        }

        @Override
        public void println(char x) {
            this.println(String.valueOf(x));
        }

        @Override
        public void println(int x) {
            this.println(String.valueOf(x));
        }

        @Override
        public void println(long x) {
            this.println(String.valueOf(x));
        }

        @Override
        public void println(float x) {
            this.println(String.valueOf(x));
        }

        @Override
        public void println(double x) {
            this.println(String.valueOf(x));
        }

        @Override
        public void println(char[] x) {
            this.println(String.valueOf(x));
        }

        @Override
        public void println(Object x) {
            this.println(String.valueOf(x));
        }

        @Override
        public PrintStream printf(String format, Object ... args) {
            return this.format(format, args);
        }

        @Override
        public PrintStream printf(Locale l, String format, Object ... args) {
            return this.format(l, format, args);
        }

        @Override
        public PrintStream format(String format, Object ... args) {
            return super.format(format, args);
        }

        @Override
        public PrintStream format(Locale l, String format, Object ... args) {
            return super.format(l, format, args);
        }
    }
}

