/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.util;

import io.helidon.build.util.Style;
import org.fusesource.jansi.Ansi;

public class StyleRenderer {
    private static final String START_TOKEN = "$(";
    private static final int START_TOKEN_LEN = "$(".length();
    private static final char ESCAPE_CHAR = '\\';
    private static final char STYLES_SEP_CHAR = ' ';
    private static final String STYLE_SEP = ",";
    private static final char END_TOKEN_CHAR = ')';
    private static final String ESCAPED_END_TOKEN = "\\)";
    private static final String END_TOKEN = ")";
    private static final Style NONE = Style.none();
    private final String text;
    private final int textLength;
    private final Ansi ansi;
    private int textStart;
    private int tokenStart;
    private int tokenEnd;
    private Style nestedStyle;

    private StyleRenderer(String text, int tokenStart) {
        this.text = text;
        this.textLength = text.length();
        this.ansi = Ansi.ansi();
        this.tokenStart = tokenStart;
        this.nestedStyle = NONE;
    }

    public static String render(String text) {
        int tokenStart = text.indexOf(START_TOKEN);
        if (tokenStart >= 0) {
            return new StyleRenderer(text, tokenStart).render();
        }
        return text;
    }

    public static String render(String format, Object ... args) {
        return StyleRenderer.render(String.format(format, args));
    }

    private String render() {
        while (this.tokenStart >= 0) {
            if (this.textStart < this.tokenStart) {
                this.ansi.a((CharSequence)this.text, this.textStart, this.tokenStart);
            }
            if (this.replaceNext(this.tokenStart)) continue;
        }
        if (this.textStart < this.textLength) {
            this.ansi.a(this.text.substring(this.textStart));
        }
        return this.ansi.toString();
    }

    private boolean replaceNext(int tokenStart) {
        int stylesStart = tokenStart + START_TOKEN_LEN;
        int stylesEnd = this.text.indexOf(32, stylesStart);
        if (stylesEnd < 0) {
            return false;
        }
        this.tokenEnd = this.tokenEnd(stylesEnd);
        if (this.tokenEnd < 0) {
            return false;
        }
        return this.replaceNext(stylesStart, stylesEnd);
    }

    private boolean replaceNext(int stylesStart, int stylesEnd) {
        int nextTokenStart = this.tokenStart(stylesEnd);
        boolean nested = nextTokenStart >= 0 && nextTokenStart < this.tokenEnd;
        int styledTextStart = stylesEnd + 1;
        int styledTextEnd = nested ? nextTokenStart : this.tokenEnd;
        String styleNames = this.text.substring(stylesStart, stylesEnd);
        String styledText = this.text.substring(styledTextStart, styledTextEnd);
        String unescapedText = styledText.replace(ESCAPED_END_TOKEN, END_TOKEN);
        Style style = Style.of(styleNames.split(STYLE_SEP));
        style.apply(this.ansi).a(unescapedText);
        if (nested) {
            this.push(style);
            if (this.replaceNext(nextTokenStart)) {
                this.pop();
                this.tokenEnd = this.tokenEnd(this.textStart);
                if (this.tokenEnd < 0) {
                    style.reset(this.ansi);
                    return false;
                }
                this.ansi.a((CharSequence)this.text, this.textStart, this.tokenEnd);
                nextTokenStart = this.tokenStart(this.tokenEnd);
            } else {
                return false;
            }
        }
        this.tokenStart = nextTokenStart;
        this.textStart = this.tokenEnd + 1;
        style.reset(this.ansi);
        return true;
    }

    private void push(Style style) {
        if (this.nestedStyle == NONE) {
            this.nestedStyle = style;
        } else if (!(this.nestedStyle instanceof Style.StyleList)) {
            this.nestedStyle = new Style.StyleList(this.nestedStyle).add(style);
        } else {
            ((Style.StyleList)this.nestedStyle).add(style);
        }
    }

    private void pop() {
        this.nestedStyle.apply(this.ansi);
        if (this.nestedStyle instanceof Style.StyleList) {
            ((Style.StyleList)this.nestedStyle).pop();
        }
    }

    private int tokenStart(int stylesEnd) {
        return this.text.indexOf(START_TOKEN, stylesEnd + 1);
    }

    private int tokenEnd(int stylesEnd) {
        int tokenEnd;
        while (stylesEnd < this.textLength && (tokenEnd = this.text.indexOf(41, stylesEnd)) >= 0) {
            if (this.text.charAt(tokenEnd - 1) != '\\') {
                return tokenEnd;
            }
            stylesEnd = tokenEnd + 1;
        }
        return -1;
    }
}

