/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;

class LineReader {
    private final BufferedReader reader;
    private final Consumer<String> lineConsumer;
    private final Runnable flushAction;
    private final char[] buf = new char[1024];
    private String remaining;

    LineReader(InputStream is, Consumer<String> lineConsumer, Runnable flushAction) {
        this.reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        this.lineConsumer = lineConsumer;
        this.flushAction = flushAction;
    }

    boolean tick() throws IOException {
        if (this.reader.ready()) {
            this.readLines(true);
            return true;
        }
        return false;
    }

    private void readLines(boolean flush) throws IOException {
        int len = this.reader.read(this.buf);
        String str = new String(this.buf, 0, len);
        String content = this.remaining != null ? this.remaining + str : str;
        this.remaining = null;
        String[] lines = content.split("\\R");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (i == lines.length - 1 && !content.endsWith("\n") && !content.endsWith("\r")) {
                this.remaining = line;
                continue;
            }
            this.lineConsumer.accept(line);
        }
        if (flush) {
            this.flushAction.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drain() {
        try {
            try {
                while (this.reader.ready()) {
                    this.readLines(false);
                    if (this.remaining.isEmpty()) continue;
                    String line = this.remaining;
                    this.remaining = null;
                    this.lineConsumer.accept(line);
                }
            }
            finally {
                try {
                    this.flushAction.run();
                }
                finally {
                    this.reader.close();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

