/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.util;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class SubstitutionVariables {
    private static final String SUBSTITUTION_PREFIX = "${";
    private static final char SUBSTITUTION_SUFFIX = '}';
    private static final int MAX_RECURSION_DEPTH = 32;
    private static final char ESCAPE_CHAR = '\\';
    private final NotFoundAction notFoundAction;
    private final List<Function<String, String>> sources;

    @SafeVarargs
    private SubstitutionVariables(NotFoundAction notFoundAction, Function<String, String> ... variableSources) {
        if (variableSources.length <= 0) {
            throw new IllegalArgumentException("At least one variable source required");
        }
        this.notFoundAction = notFoundAction;
        this.sources = List.of(variableSources);
    }

    public static SubstitutionVariables of(Map<String, String> source) {
        return SubstitutionVariables.of(NotFoundAction.Fail, source);
    }

    public static SubstitutionVariables of(NotFoundAction notFoundAction, Map<String, String> source) {
        Function[] functionArray = new Function[1];
        functionArray[0] = source::get;
        return new SubstitutionVariables(notFoundAction, functionArray);
    }

    @SafeVarargs
    public static SubstitutionVariables of(Function<String, String> ... sources) {
        return SubstitutionVariables.of(NotFoundAction.Fail, sources);
    }

    @SafeVarargs
    public static SubstitutionVariables of(NotFoundAction notFoundAction, Function<String, String> ... sources) {
        return new SubstitutionVariables(notFoundAction, sources);
    }

    public static Function<String, String> systemPropertyOrEnvVarSource() {
        return SubstitutionVariables::systemPropertyOrEnvVar;
    }

    public static String systemPropertyOrEnvVar(String propertyName) {
        String result = System.getProperty(Objects.requireNonNull(propertyName));
        if (result == null && (result = System.getenv(propertyName)) == null) {
            result = System.getenv(propertyName.replace(".", "_").toUpperCase());
        }
        return result;
    }

    public String resolve(String value) {
        return this.resolve(0, value, value, 0);
    }

    private String resolve(int startIndex, String value, String originalValue, int depth) {
        if (depth < 32) {
            int start = value.indexOf(SUBSTITUTION_PREFIX, startIndex);
            if (start >= 0) {
                if (start > 1 && value.charAt(start - 1) == '\\') {
                    String unescapedValue = value.substring(0, start - 1) + value.substring(start);
                    return this.resolve(start + 1, unescapedValue, originalValue, depth + 1);
                }
                int end = value.indexOf(125, start);
                if (end >= 0) {
                    String key = value.substring(start + 2, end);
                    String substitute = this.substitutionValueFor(key);
                    if (substitute == null) {
                        switch (this.notFoundAction) {
                            case Collapse: {
                                substitute = "";
                                break;
                            }
                            case AsIs: {
                                return this.resolve(end, value, originalValue, depth + 1);
                            }
                            default: {
                                throw new IllegalArgumentException("Substitution not found for \"" + key + "\" in \"" + value + "\"");
                            }
                        }
                    }
                    String prefix = value.substring(0, start);
                    String suffix = value.substring(end + 1);
                    return this.resolve(startIndex, prefix + substitute + suffix, originalValue, depth + 1);
                }
                throw new IllegalArgumentException("Closing '}' missing in \"" + value + "\"");
            }
        } else {
            throw new IllegalArgumentException("Max recursion (32) depth reached for \"" + originalValue + "\"");
        }
        return value;
    }

    private String substitutionValueFor(String key) {
        for (Function<String, String> source : this.sources) {
            String result = source.apply(key);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static enum NotFoundAction {
        Fail,
        AsIs,
        Collapse;

    }
}

