/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.util;

import io.helidon.build.util.DefaultLogWriter;
import io.helidon.build.util.Log;
import io.helidon.build.util.PrintStreams;
import java.io.PrintStream;

public final class SystemLogWriter
extends DefaultLogWriter {
    private final PrintStream stdErr;
    private final PrintStream stdOut = PrintStreams.autoFlush(PrintStreams.STDOUT);

    public static SystemLogWriter install(Log.Level level) {
        SystemLogWriter writer = SystemLogWriter.create(level);
        Log.writer(writer);
        return writer;
    }

    public static SystemLogWriter create() {
        return new SystemLogWriter();
    }

    public static SystemLogWriter create(Log.Level level) {
        return new SystemLogWriter(level);
    }

    private SystemLogWriter() {
        this.stdErr = PrintStreams.autoFlush(PrintStreams.STDERR);
    }

    private SystemLogWriter(Log.Level level) {
        super(level);
        this.stdErr = PrintStreams.autoFlush(PrintStreams.STDERR);
    }

    @Override
    public PrintStream stdOut() {
        return this.stdOut;
    }

    @Override
    public PrintStream stdErr() {
        return this.stdErr;
    }

    @Override
    public boolean isSystem() {
        return true;
    }
}

