/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.util;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.DefaultMustacheVisitor;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import com.github.mustachejava.MustacheFactory;
import com.github.mustachejava.MustacheVisitor;
import com.github.mustachejava.TemplateContext;
import com.github.mustachejava.codes.ValueCode;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;

public abstract class MustacheHelper {
    public static final String MUSTACHE_EXT = ".mustache";
    private static final MustacheFactory MUSTACHE_FACTORY = new MustacheFactoryImpl();

    private MustacheHelper() {
    }

    public static void renderMustacheTemplate(File templateFile, String name, Path target, Object scope) throws IOException {
        MustacheHelper.renderMustacheTemplate(new FileInputStream(templateFile), name, target, scope);
    }

    public static void renderMustacheTemplate(InputStream is, String name, Path target, Object scope) throws IOException {
        Mustache m = MUSTACHE_FACTORY.compile((Reader)new InputStreamReader(is), name);
        Files.createDirectories(target.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(target, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            m.execute((Writer)writer, scope).flush();
        }
    }

    private static final class MustacheFactoryImpl
    extends DefaultMustacheFactory {
        private MustacheFactoryImpl() {
        }

        public MustacheVisitor createMustacheVisitor() {
            return new DefaultMustacheVisitor(this){

                public void value(TemplateContext tc, String variable, boolean encoded) {
                    this.list.add(new ValueCode(tc, this.df, variable, encoded){

                        public Writer execute(Writer writer, List<Object> scopes) {
                            try {
                                Object object = this.get(scopes);
                                if (object instanceof NotEncoded) {
                                    writer.write(this.oh.stringify(object));
                                    return this.appendText(this.run(writer, scopes));
                                }
                                return super.execute(writer, scopes);
                            }
                            catch (Exception e) {
                                throw new MustacheException("Failed to get value for " + this.name, (Throwable)e, this.tc);
                            }
                        }
                    });
                }
            };
        }
    }

    public static final class RawString
    implements NotEncoded {
        private final String value;

        public RawString(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static interface NotEncoded {
    }
}

