/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class Strings {
    public static boolean isValid(String value) {
        return value != null && !value.isBlank();
    }

    public static boolean isNotValid(String value) {
        return value == null || value.isBlank();
    }

    public static String normalizeNewLines(String value) {
        if (value == null) {
            return value;
        }
        return value.replaceAll("\r\n", "\n");
    }

    public static String read(InputStream inputStream) {
        try {
            return new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static String replaceWhitespaces(String str, String replacement) {
        Objects.requireNonNull(replacement, "Replacement must not be null");
        if (str == null) {
            return null;
        }
        return str.replaceAll("\\s+", replacement);
    }

    public static String replaceAll(String str, String ... replacements) {
        if (str == null || replacements == null) {
            return str;
        }
        if (replacements.length % 2 != 0) {
            throw new IllegalArgumentException("replacements should be even");
        }
        for (int i = 0; i < replacements.length; i += 2) {
            str = str.replaceAll(replacements[i], replacements[i + 1]);
        }
        return str;
    }

    private Strings() {
    }
}

