/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.util;

import io.helidon.build.util.AnsiConsoleInstaller;
import io.helidon.build.util.Log;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.fusesource.jansi.Ansi;

public class Style {
    private static final Style NONE = new Style();
    private static final Style PLAIN = new Emphasis(Ansi.Attribute.RESET);
    private static final Style BOLD = new Emphasis(Ansi.Attribute.INTENSITY_BOLD);
    private static final Style ITALIC = new Emphasis(Ansi.Attribute.ITALIC);
    private static final Style FAINT = new Emphasis(Ansi.Attribute.INTENSITY_FAINT);
    private static final Style BOLD_ITALIC = new StyleList(BOLD).add(ITALIC);
    private static final Style NEGATIVE = new Emphasis(Ansi.Attribute.NEGATIVE_ON);
    private static final boolean ENABLED = AnsiConsoleInstaller.install();
    private static final Map<String, Style> STYLES = Style.stylesByName();
    private static final char ESC_CH1 = '\u001b';
    private static final char ESC_CH2 = '[';
    private static final char CMD_CH2 = ']';
    private static final char BEL = '\u0007';
    private static final char ST_CH2 = '\\';
    private static final char CHARSET0_CH2 = '(';
    private static final char CHARSET1_CH2 = ')';
    private static final String ANSI_ESCAPE_BEGIN = "\u001b[";

    public static Map<String, Style> styles() {
        return STYLES;
    }

    public static Style none() {
        return NONE;
    }

    public static Style named(String name) {
        return Style.named(name, false);
    }

    public static Style named(String name, boolean required) {
        Style style = STYLES.get(name);
        if (style == null) {
            if (required) {
                throw new IllegalArgumentException("Unknown style: " + name);
            }
            return NONE;
        }
        return ENABLED ? style : NONE;
    }

    public static List<String> colorNames() {
        return List.of("red", "yellow", "green", "cyan", "blue", "magenta", "white", "black", "default", "bold", "negative");
    }

    public static List<String> backgroundColorNames() {
        return List.of("bg_red", "bg_yellow", "bg_green", "bg_cyan", "bg_blue", "bg_magenta", "bg_white", "bg_black", "bg_default", "bg_negative");
    }

    public static List<String> emphasisNames() {
        return List.of("italic", "bold", "faint", "plain", "underline", "strikethrough", "negative", "conceal", "blink");
    }

    public static Style of(String ... names) {
        if (names.length == 0) {
            return NONE;
        }
        if (names.length == 1) {
            return Style.named(names[0]);
        }
        return new StyleList(names);
    }

    public static Style of(Ansi.Color color, boolean background, boolean bright) {
        return new Hue(color, background, bright);
    }

    public static Style of(Ansi.Attribute ... attributes) {
        if (attributes.length == 0) {
            return NONE;
        }
        if (attributes.length == 1) {
            return new Emphasis(attributes[0]);
        }
        return new StyleList(attributes);
    }

    public static Style of(Style ... styles) {
        if (styles.length == 0) {
            return NONE;
        }
        if (styles.length == 1) {
            return styles[0];
        }
        return new StyleList(styles);
    }

    public static boolean isStyled(String text) {
        return text != null && text.contains(ANSI_ESCAPE_BEGIN);
    }

    public static String strip(String input) {
        AnsiState state = AnsiState.ESC1;
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[1024];
        int pos = 0;
        for (int index = 0; index < input.length(); ++index) {
            char c = input.charAt(index);
            switch (state) {
                case ESC1: {
                    if (c == '\u001b') {
                        buffer[pos++] = c;
                        state = AnsiState.ESC2;
                        break;
                    }
                    sb.append(c);
                    break;
                }
                case ESC2: {
                    buffer[pos++] = c;
                    if (c == '[') {
                        state = AnsiState.NEXT_ARG;
                        break;
                    }
                    if (c == ']') {
                        state = AnsiState.CMD;
                        break;
                    }
                    if (c == '(') {
                        state = AnsiState.CHARSET;
                        break;
                    }
                    if (c == ')') {
                        state = AnsiState.CHARSET;
                        break;
                    }
                    sb.append(buffer, 0, pos);
                    pos = 0;
                    state = AnsiState.ESC1;
                    break;
                }
                case NEXT_ARG: {
                    buffer[pos++] = c;
                    if ('\"' == c) {
                        state = AnsiState.STR_ARG_END;
                        break;
                    }
                    if ('0' <= c && c <= '9') {
                        state = AnsiState.INT_ARG_END;
                        break;
                    }
                    if (c == ';' || c == '?' || c == '=') break;
                    pos = 0;
                    state = AnsiState.ESC1;
                    break;
                }
                case INT_ARG_END: {
                    buffer[pos++] = c;
                    if ('0' <= c && c <= '9') break;
                    if (c == ';') {
                        state = AnsiState.NEXT_ARG;
                        break;
                    }
                    pos = 0;
                    state = AnsiState.ESC1;
                    break;
                }
                case STR_ARG_END: {
                    buffer[pos++] = c;
                    if ('\"' == c) break;
                    if (c == ';') {
                        state = AnsiState.NEXT_ARG;
                        break;
                    }
                    pos = 0;
                    state = AnsiState.ESC1;
                    break;
                }
                case CMD: {
                    buffer[pos++] = c;
                    if ('0' <= c && c <= '9') {
                        state = AnsiState.CMD_END;
                        break;
                    }
                    sb.append(buffer, 0, pos);
                    pos = 0;
                    state = AnsiState.ESC1;
                    break;
                }
                case CMD_END: {
                    buffer[pos++] = c;
                    if (';' == c) {
                        state = AnsiState.CMD_PARAM;
                        break;
                    }
                    if ('0' <= c && c <= '9') break;
                    sb.append(buffer, 0, pos);
                    pos = 0;
                    state = AnsiState.ESC1;
                    break;
                }
                case CMD_PARAM: {
                    buffer[pos++] = c;
                    if ('\u0007' == c) {
                        pos = 0;
                        state = AnsiState.ESC1;
                        break;
                    }
                    if ('\u001b' != c) break;
                    state = AnsiState.ST;
                    break;
                }
                case ST: {
                    buffer[pos++] = c;
                    if ('\\' == c) {
                        pos = 0;
                        state = AnsiState.ESC1;
                        break;
                    }
                    state = AnsiState.CMD_PARAM;
                    break;
                }
                case CHARSET: {
                    pos = 0;
                    state = AnsiState.ESC1;
                    break;
                }
            }
            if (index < buffer.length) continue;
            sb.append(buffer, 0, pos);
            pos = 0;
            state = AnsiState.ESC1;
        }
        return sb.toString();
    }

    public static void main(String ... args) {
        boolean list = false;
        if (args.length == 1) {
            if (args[0].equals("--list")) {
                list = true;
            } else if (!args[0].equals("--table")) {
                throw new IllegalArgumentException("Unknown argument: " + args[0]);
            }
        }
        if (list) {
            Style.styles().forEach((name, style) -> Log.info("%14s [ %s ]", name, style.apply("example")));
        } else {
            Style.logSummaryTables();
        }
    }

    public static void logSummaryTables() {
        Log.info();
        Style.logTextSummaryTable();
        Log.info();
        Style.logBackgroundSummaryTable();
        Log.info();
    }

    public static void logTextSummaryTable() {
        Style.logTable(Style.colorNames(), false);
    }

    public static void logBackgroundSummaryTable() {
        Style.logTable(Style.backgroundColorNames(), true);
    }

    private static void logTable(List<String> names, boolean background) {
        String header = background ? "Background Color" : "Text Color";
        String example = " Example 1234 !@#$% ";
        String rowFormat = "\u2502 %-19s\u2502 %22s \u2502 %22s \u2502 %22s \u2502 %22s \u2502";
        Log.info("\u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u252c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u252c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u252c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u252c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2510", new Object[0]);
        Log.info("\u2502 %-19s\u2502        Plain         \u2502        Italic        \u2502         Bold         \u2502    Italic & Bold     \u2502", header);
        Log.info("\u251c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2524", new Object[0]);
        names.forEach(name -> {
            String textColor = background ? "default" : name;
            String backgroundColor = background ? name : "bg_default";
            Object textColorBright = background ? textColor : textColor + "!";
            Object backgroundColorBright = background ? backgroundColor + "!" : backgroundColor;
            String plain = Style.of(backgroundColor, textColor).apply(example);
            String italic = Style.of(backgroundColor, textColor, "italic").apply(example);
            String bold = Style.of(backgroundColor, textColor, "bold").apply(example);
            String italicBold = Style.of(backgroundColor, textColor, "ITALIC").apply(example);
            String plainBright = Style.of(new String[]{backgroundColorBright, textColorBright}).apply(example);
            String italicBright = Style.of(new String[]{backgroundColorBright, textColorBright, "italic"}).apply(example);
            String boldBright = Style.of(new String[]{backgroundColorBright, textColorBright, "bold"}).apply(example);
            String italicBoldBright = Style.of(new String[]{backgroundColorBright, textColorBright, "ITALIC"}).apply(example);
            Log.info(rowFormat, name, plain, italic, bold, italicBold);
            Log.info(rowFormat, name + "!", plainBright, italicBright, boldBright, italicBoldBright);
        });
        Log.info("\u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2534\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2534\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2534\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2534\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2518", new Object[0]);
    }

    public String apply(Object text) {
        return this.apply(Ansi.ansi()).a(text).reset().toString();
    }

    public Ansi apply(Ansi ansi) {
        return ansi;
    }

    public Ansi reset(Ansi ansi) {
        return ansi;
    }

    public String toString() {
        return "none";
    }

    private static Map<String, Style> stylesByName() {
        LinkedHashMap<String, Style> styles = new LinkedHashMap<String, Style>();
        styles.put("none", Style.none());
        styles.put("bg_none", Style.none());
        Style.colorNames().stream().filter(name -> !name.equals("bold")).forEach(lowerName -> {
            boolean negative = lowerName.equals("negative");
            String upperName = lowerName.toUpperCase(Locale.ENGLISH);
            Ansi.Color color = negative ? null : Ansi.Color.valueOf((String)upperName);
            Style basic = negative ? NEGATIVE : Style.of(color, false, false);
            Style bright = negative ? NEGATIVE : Style.of(color, false, true);
            Style bold = Style.of(BOLD, basic);
            Style italic = Style.of(ITALIC, basic);
            Style italicBold = Style.of(BOLD_ITALIC, basic);
            Style boldBright = Style.of(BOLD, bright);
            Style italicBright = Style.of(bright, ITALIC);
            Style italicBoldBright = Style.of(BOLD, ITALIC, bright);
            styles.put((String)lowerName, basic);
            styles.put("*" + lowerName + "*", italic);
            styles.put("_" + lowerName + "_", italic);
            styles.put("**" + lowerName + "**", bold);
            styles.put("__" + lowerName + "__", bold);
            styles.put(upperName, bold);
            styles.put("**_" + lowerName + "_**", italicBold);
            styles.put("__*" + lowerName + "*__", italicBold);
            styles.put("_" + upperName + "_", italicBold);
            styles.put("*" + upperName + "*", italicBold);
            styles.put(lowerName + "!", bright);
            styles.put("*" + lowerName + "*!", italicBright);
            styles.put("_" + lowerName + "_!", italicBright);
            styles.put("**" + lowerName + "**!", boldBright);
            styles.put("__" + lowerName + "__!", boldBright);
            styles.put(upperName + "!", boldBright);
            styles.put("**_" + lowerName + "_**!", italicBoldBright);
            styles.put("__*" + lowerName + "*__!", italicBoldBright);
            styles.put("_" + upperName + "_!", italicBoldBright);
            styles.put("*" + upperName + "*!", italicBoldBright);
            styles.put("bg_" + lowerName, negative ? NEGATIVE : Style.of(color, true, false));
            styles.put("bg_" + lowerName + "!", negative ? NEGATIVE : Style.of(color, true, true));
        });
        styles.put("bold", BOLD);
        styles.put("BOLD", BOLD);
        styles.put("italic", ITALIC);
        styles.put("*bold*", BOLD_ITALIC);
        styles.put("_bold_", BOLD_ITALIC);
        styles.put("*BOLD*", BOLD_ITALIC);
        styles.put("_BOLD_", BOLD_ITALIC);
        styles.put("**italic**", BOLD_ITALIC);
        styles.put("__italic__", BOLD_ITALIC);
        styles.put("ITALIC", BOLD_ITALIC);
        styles.put("plain", PLAIN);
        styles.put("faint", FAINT);
        styles.put("underline", Style.of(Ansi.Attribute.UNDERLINE));
        styles.put("strikethrough", Style.of(Ansi.Attribute.STRIKETHROUGH_ON));
        styles.put("blink", Style.of(Ansi.Attribute.BLINK_SLOW));
        styles.put("conceal", Style.of(Ansi.Attribute.CONCEAL_ON));
        return styles;
    }

    static class Emphasis
    extends Style {
        private final Ansi.Attribute attribute;

        Emphasis(Ansi.Attribute attribute) {
            this.attribute = Objects.requireNonNull(attribute);
        }

        @Override
        public Ansi apply(Ansi ansi) {
            ansi.a(this.attribute);
            return ansi;
        }

        @Override
        public Ansi reset(Ansi ansi) {
            return ansi.reset();
        }

        @Override
        public String toString() {
            return this.attribute.toString();
        }
    }

    static class Hue
    extends Style {
        private final Ansi.Color color;
        private final boolean background;
        private final boolean bright;

        Hue(Ansi.Color color, boolean background, boolean bright) {
            this.color = Objects.requireNonNull(color);
            this.background = background;
            this.bright = bright;
        }

        @Override
        public Ansi apply(Ansi ansi) {
            if (this.background) {
                if (this.bright) {
                    ansi.bgBright(this.color);
                } else {
                    ansi.bg(this.color);
                }
            } else if (this.bright) {
                ansi.fgBright(this.color);
            } else {
                ansi.fg(this.color);
            }
            return ansi;
        }

        @Override
        public Ansi reset(Ansi ansi) {
            return ansi.reset();
        }

        @Override
        public String toString() {
            return this.color + ", background=" + this.background + ", bright=" + this.bright;
        }
    }

    static class StyleList
    extends Style {
        private final List<Style> styles = new ArrayList<Style>();

        StyleList(String ... names) {
            for (String name : names) {
                this.add(name);
            }
        }

        StyleList(Ansi.Attribute ... attributes) {
            for (Ansi.Attribute attribute : attributes) {
                this.add(attribute);
            }
        }

        StyleList(Style ... styles) {
            for (Style style : styles) {
                this.add(style);
            }
        }

        StyleList add(String name) {
            this.add(Style.named(name));
            return this;
        }

        StyleList add(Ansi.Attribute attribute) {
            this.add(new Emphasis(attribute));
            return this;
        }

        StyleList add(Style style) {
            this.styles.add(style);
            return this;
        }

        int size() {
            return this.styles.size();
        }

        Style pop() {
            if (this.styles.isEmpty()) {
                return StyleList.none();
            }
            return this.styles.remove(this.size() - 1);
        }

        @Override
        public Ansi apply(Ansi ansi) {
            for (Style style : this.styles) {
                style.apply(ansi);
            }
            return ansi;
        }

        @Override
        public Ansi reset(Ansi ansi) {
            return ansi.reset();
        }

        @Override
        public String toString() {
            return this.styles.toString();
        }
    }

    private static enum AnsiState {
        ESC1,
        ESC2,
        NEXT_ARG,
        STR_ARG_END,
        INT_ARG_END,
        CMD,
        CMD_END,
        CMD_PARAM,
        ST,
        CHARSET;

    }
}

