/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.util;

import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class TimeUtils {
    private static final DateTimeFormatter ZONED_DATE_FORMATTER = DateTimeFormatter.ofPattern("MM-dd-yyyy kk:mm:ss z");
    private static final ZoneId ZONE = ZoneId.systemDefault();

    public static String currentDateTime() {
        return TimeUtils.toDateTime(System.currentTimeMillis());
    }

    public static String toDateTime(long millis) {
        return TimeUtils.toDateTime(Instant.ofEpochMilli(millis));
    }

    public static String toDateTime(FileTime fileTime) {
        return TimeUtils.toDateTime(fileTime.toInstant());
    }

    public static String toDateTime(Instant instant) {
        ZonedDateTime time = ZonedDateTime.ofInstant(instant, ZONE);
        return ZONED_DATE_FORMATTER.format(time);
    }

    private TimeUtils() {
    }
}

