/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.sitegen;

import io.helidon.build.maven.sitegen.Config;
import io.helidon.build.maven.sitegen.Site;
import io.helidon.build.maven.sitegen.asciidoctor.AsciidocEngine;
import io.helidon.build.maven.sitegen.freemarker.FreemarkerEngine;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class SiteEngine {
    private final AsciidocEngine asciidoc;
    private final FreemarkerEngine freemarker;
    private final Site site;

    private SiteEngine(Builder builder) {
        String backend = Objects.requireNonNull(builder.backend, "backend is null!");
        this.site = Objects.requireNonNull(builder.site, "site is null!");
        this.freemarker = Optional.ofNullable(builder.freemarker).orElseGet(() -> FreemarkerEngine.create(backend));
        this.asciidoc = Optional.ofNullable(builder.asciidoc).orElseGet(() -> AsciidocEngine.create(backend));
    }

    public Site site() {
        return this.site;
    }

    public AsciidocEngine asciidoc() {
        return this.asciidoc;
    }

    public FreemarkerEngine freemarker() {
        return this.freemarker;
    }

    public static SiteEngine create(String backend, Config config) {
        return SiteEngine.builder().backend(backend).config(config).build();
    }

    public static SiteEngine create(String backend) {
        return SiteEngine.builder().backend(backend).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements Supplier<SiteEngine> {
        private FreemarkerEngine freemarker;
        private AsciidocEngine asciidoc;
        private String backend;
        private Site site;

        public Builder site(Site site) {
            this.site = site;
            return this;
        }

        public Builder backend(String backend) {
            this.backend = backend;
            return this;
        }

        public Builder freemarker(FreemarkerEngine freemarker) {
            this.freemarker = freemarker;
            return this;
        }

        public Builder freemarker(FreemarkerEngine.Builder builder) {
            this.freemarker = builder.build();
            return this;
        }

        public Builder freemarker(Consumer<FreemarkerEngine.Builder> consumer) {
            FreemarkerEngine.Builder builder = FreemarkerEngine.builder();
            if (this.backend != null) {
                builder.backend(this.backend);
            }
            consumer.accept(builder);
            this.freemarker = builder.build();
            return this;
        }

        public Builder asciidoctor(AsciidocEngine asciidoc) {
            this.asciidoc = asciidoc;
            return this;
        }

        public Builder asciidoctor(AsciidocEngine.Builder builder) {
            if (this.backend != null) {
                builder.backend(this.backend);
            }
            this.asciidoc = builder.build();
            return this;
        }

        public Builder asciidoctor(Consumer<AsciidocEngine.Builder> consumer) {
            AsciidocEngine.Builder builder = AsciidocEngine.builder();
            if (this.backend != null) {
                builder.backend(this.backend);
            }
            consumer.accept(builder);
            this.asciidoc = builder.build();
            return this;
        }

        public Builder config(Config config) {
            this.freemarker = config.get("freemarker").asOptional().map(c -> FreemarkerEngine.create(this.backend, c)).orElse(null);
            this.asciidoc = config.get("asciidoctor").asOptional().map(c -> AsciidocEngine.create(this.backend, c)).orElse(null);
            return this;
        }

        public SiteEngine build() {
            return new SiteEngine(this);
        }

        @Override
        public SiteEngine get() {
            return this.build();
        }
    }
}

