/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.sitegen.asciidoctor;

import io.helidon.build.maven.sitegen.asciidoctor.Block;
import io.helidon.build.maven.sitegen.asciidoctor.Include;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.asciidoctor.ast.Document;
import org.asciidoctor.extension.Preprocessor;
import org.asciidoctor.extension.PreprocessorReader;

public class IncludePreprocessor
extends Preprocessor {
    static List<String> convertHybridToBracketed(List<String> lines) {
        ArrayList<String> augmentedLines = new ArrayList<String>();
        AtomicInteger lineNumber = new AtomicInteger(0);
        while (lineNumber.get() < lines.size()) {
            String line = lines.get(lineNumber.get());
            if (line.startsWith("include::")) {
                augmentedLines.addAll(IncludePreprocessor.handleADocInclude(lines, lineNumber));
                continue;
            }
            if (Block.isBlockStart(line)) {
                augmentedLines.addAll(IncludePreprocessor.handleBlock(lines, lineNumber));
                continue;
            }
            if (Include.isIncludeNumbered(line)) {
                augmentedLines.addAll(IncludePreprocessor.handleNumberedInclude(lines, lineNumber));
                continue;
            }
            augmentedLines.add(line);
            lineNumber.getAndIncrement();
        }
        return augmentedLines;
    }

    static List<String> convertBracketedToNatural(List<String> lines) {
        ArrayList<String> result = new ArrayList<String>();
        AtomicInteger lineNumber = new AtomicInteger(0);
        while (lineNumber.get() < lines.size()) {
            String line = lines.get(lineNumber.get());
            if (Include.isIncludeStart(line)) {
                result.addAll(IncludePreprocessor.bracketedIncludeToNatural(lines, lineNumber));
                continue;
            }
            result.add(line);
            lineNumber.getAndIncrement();
        }
        return result;
    }

    static List<String> convertBracketedToNumbered(List<String> content) {
        ArrayList<String> result = new ArrayList<String>();
        AtomicInteger lineNumber = new AtomicInteger(0);
        while (lineNumber.get() < content.size()) {
            String line = content.get(lineNumber.get());
            if (Include.isIncludeStart(line)) {
                Include ia = Include.consumeBracketedInclude(content, lineNumber, result, result.size());
                if (ia == null) continue;
                result.add(ia.asNumberedAsciiDocInclude());
                result.addAll(ia.body());
                continue;
            }
            if (Block.isBlockStart(line)) {
                Block sba = Block.consumeBlock(content, lineNumber);
                result.addAll(sba.asBlockWithNumberedIncludes());
                continue;
            }
            result.add(line);
            lineNumber.getAndIncrement();
        }
        return result;
    }

    public void process(Document doc, PreprocessorReader reader) {
        OutputType outputType = OutputType.match(doc.getOptions().get("preprocessOutputType"));
        if (outputType == null) {
            return;
        }
        List<String> processedContent = this.markIncludes(reader, outputType, doc.getAttributes());
        this.savePrecludedDocIfRequested(processedContent, doc);
    }

    private List<String> markIncludes(PreprocessorReader reader, OutputType outputType, Map<String, Object> attributes) {
        List<String> origWithBracketedIncludes = IncludePreprocessor.convertHybridToBracketed(reader.lines());
        IncludePreprocessor.readAndClearReader(reader);
        String origWithBracketedIncludesContent = IncludePreprocessor.linesToString(origWithBracketedIncludes);
        reader.pushInclude(origWithBracketedIncludesContent, null, null, 1, attributes);
        List<String> bracketedIncludesWithIncludedText = IncludePreprocessor.readAndClearReader(reader);
        List<String> numberedIncludesWithIncludedText = IncludePreprocessor.convertBracketedToNumbered(bracketedIncludesWithIncludedText);
        String numberedIncludesWithIncludedTextContent = IncludePreprocessor.linesToString(numberedIncludesWithIncludedText);
        reader.pushInclude(numberedIncludesWithIncludedTextContent, null, null, 1, attributes);
        switch (outputType) {
            case PREPROCESSED: {
                return numberedIncludesWithIncludedText;
            }
            case NATURAL: {
                return IncludePreprocessor.convertBracketedToNatural(bracketedIncludesWithIncludedText);
            }
        }
        throw new IllegalArgumentException(String.format("outputType %s is not one of %s", outputType.toString().toLowerCase(), Arrays.toString((Object[])OutputType.values())));
    }

    private static List<String> readAndClearReader(PreprocessorReader reader) {
        List result = reader.readLines();
        reader.restoreLines(Collections.emptyList());
        return result;
    }

    private static String linesToString(List<String> lines) {
        return lines.stream().collect(Collectors.joining(System.lineSeparator()));
    }

    private void savePrecludedDocIfRequested(List<String> content, Document doc) {
        Path outputPath = (Path)doc.getOptions().get("preincludeOutputPath");
        if (outputPath != null) {
            try {
                Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
                Files.write(outputPath, content, new OpenOption[0]);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private static List<String> handleADocInclude(List<String> lines, AtomicInteger lineNumber) {
        ArrayList<String> result = new ArrayList<String>();
        String line = lines.get(lineNumber.getAndIncrement());
        String includeTarget = line.substring("include::".length());
        result.add(Include.includeStart(includeTarget));
        result.add(line);
        result.add(Include.includeEnd(includeTarget));
        return result;
    }

    private static List<String> handleBlock(List<String> lines, AtomicInteger lineNumber) {
        Block sba = Block.consumeBlock(lines, lineNumber);
        return sba.asBracketedBlock();
    }

    private static List<String> handleNumberedInclude(List<String> lines, AtomicInteger lineNumber) {
        Include ia = Include.fromNumberedInclude(lines, 0, lines.get(lineNumber.getAndIncrement()));
        lineNumber.addAndGet(ia.endWithinBlock() - ia.startWithinBlock() + 1);
        return ia.asBracketedAsciiDocInclude();
    }

    private static List<String> bracketedIncludeToNatural(List<String> lines, AtomicInteger lineNumber) {
        ArrayList<String> result = new ArrayList<String>();
        Include inc = Include.consumeBracketedInclude(lines, lineNumber, result, 0);
        if (inc != null) {
            result.addAll(inc.asAsciiDocInclude());
        }
        return result;
    }

    static enum OutputType {
        PREPROCESSED,
        NATURAL;


        static OutputType match(Object outputType) {
            Optional<OutputType> match = Arrays.stream(OutputType.values()).filter(ot -> ot.toString().toLowerCase().equals(outputType)).findFirst();
            if (match.isEmpty()) {
                return null;
            }
            return match.get();
        }
    }
}

