/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.sitegen.freemarker;

import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import io.helidon.build.maven.sitegen.freemarker.ContentNodeDirective;
import io.helidon.build.maven.sitegen.models.Page;
import io.helidon.build.maven.sitegen.models.SearchEntry;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.asciidoctor.ast.ContentNode;
import org.asciidoctor.ast.StructuralNode;

public final class SearchIndexDirective
extends ContentNodeDirective {
    private final List<SearchEntry> entries = new ArrayList<SearchEntry>();

    @Override
    void doExecute(ContentNode node, Map<?, ?> params, TemplateDirectiveBody body) throws TemplateException, IOException {
        String title = null;
        if (params.containsKey("title")) {
            Object titleParam = params.get("title");
            if (!(titleParam instanceof TemplateScalarModel)) {
                throw new TemplateModelException("The title parameter must be a string");
            }
            title = ((TemplateScalarModel)titleParam).getAsString();
        } else if (node instanceof StructuralNode) {
            title = SearchIndexDirective.stripHtmlMarkups(((StructuralNode)node).getTitle());
        }
        if (title == null) {
            throw new TemplateModelException("missing title");
        }
        Page page = this.page(node);
        StringWriter writer = new StringWriter();
        body.render((Writer)writer);
        SearchEntry entry = SearchEntry.create(page.target(), SearchIndexDirective.stripHtmlMarkups(writer.toString()), title);
        this.entries.add(entry);
    }

    private static String stripHtmlMarkups(String content) {
        if (content == null) {
            return null;
        }
        return content.replaceAll("\\<.*?\\>", " ").replaceAll("\\\\n", "").replaceAll("\\s+", " ");
    }

    public List<SearchEntry> entries() {
        return this.entries;
    }
}

