/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.sitegen.maven;

import io.helidon.build.common.FileUtils;
import io.helidon.build.common.maven.plugin.PlexusLoggerHolder;
import io.helidon.build.maven.sitegen.Config;
import io.helidon.build.maven.sitegen.RenderingException;
import io.helidon.build.maven.sitegen.Site;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.doxia.siterenderer.DefaultSiteRenderer;
import org.apache.maven.doxia.siterenderer.DocumentRenderer;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.RenderingContext;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.plugins.site.render.ReportDocumentRenderer;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.IOUtil;

@Component(role=Renderer.class)
public class DoxiaSiteRenderer
extends DefaultSiteRenderer {
    @Requirement
    private PlexusLoggerHolder plexusLogHolder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Collection<DocumentRenderer> documents, SiteRenderingContext context, File outputDirectory) throws RendererException, IOException {
        Path outputDir = outputDirectory.toPath();
        for (DocumentRenderer docRenderer : documents) {
            boolean modified;
            if (!(docRenderer instanceof ReportDocumentRenderer)) continue;
            RenderingContext renderingContext = docRenderer.getRenderingContext();
            Path outputFile = outputDir.resolve(docRenderer.getOutputName());
            Path inputFile = renderingContext.getBasedir().toPath().resolve(renderingContext.getInputName());
            long lastModifiedTime = FileUtils.lastModifiedMillis((Path)outputFile);
            boolean bl = modified = !Files.exists(outputFile, new LinkOption[0]) || FileUtils.lastModifiedMillis((Path)inputFile) > lastModifiedTime || context.getDecoration().getLastModified() > lastModifiedTime;
            if (modified || docRenderer.isOverwrite()) {
                if (!Files.exists(outputFile, new LinkOption[0])) {
                    Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Generating " + outputFile);
                }
                BufferedWriter writer = null;
                try {
                    if (!docRenderer.isExternalReport()) {
                        writer = Files.newBufferedWriter(outputFile, Charset.forName(context.getOutputEncoding()), new OpenOption[0]);
                    }
                    docRenderer.renderDocument(writer, (Renderer)this, context);
                    continue;
                }
                finally {
                    IOUtil.close(writer);
                    continue;
                }
            }
            if (!this.getLogger().isDebugEnabled()) continue;
            this.getLogger().debug(inputFile + " unchanged, not regenerating...");
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        Map templateProps = context.getTemplateProperties();
        if (templateProps != null) {
            templateProps.forEach((k, v) -> properties.put((String)k, v.toString()));
            MavenProject project = (MavenProject)templateProps.get("project");
            if (project != null) {
                properties.put("project.groupId", project.getGroupId());
                properties.put("project.artifactId", project.getArtifactId());
                properties.put("project.version", project.getVersion());
                properties.put("project.basedir", project.getBasedir().getAbsolutePath());
            }
        }
        Path siteDir = ((File)context.getSiteDirectories().iterator().next()).toPath();
        Path configFile = siteDir.resolve("sitegen.yaml");
        Config config = Config.create(configFile, properties);
        Site site = Site.create(config);
        if (this.getLogger().isDebugEnabled()) {
            System.setProperty("jruby.cli.verbose", "true");
        }
        try {
            site.generate(siteDir, outputDir);
        }
        catch (RenderingException ex) {
            throw new RendererException("Rendering error", (Throwable)ex);
        }
    }

    public void copyResources(SiteRenderingContext context, File resourcesDir, File outputDir) {
    }

    public void copyResources(SiteRenderingContext context, File outputDirectory) {
    }
}

