/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.sitegen.models;

import io.helidon.build.common.logging.Log;
import io.helidon.build.maven.sitegen.Context;
import io.helidon.build.maven.sitegen.Model;
import io.helidon.build.maven.sitegen.RenderingException;
import io.helidon.build.maven.sitegen.models.Page;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class Link
implements Model {
    private final String source;
    private final String target;
    private final String hash;
    private final String title;
    private final String text;
    private final String window;
    private final String id;
    private final String type;
    private final String role;
    private final String rel;

    private Link(Builder builder) {
        Page doc = Objects.requireNonNull(builder.page, "page is null");
        Objects.requireNonNull(builder.type, "type is null");
        switch (builder.type) {
            case "xref": {
                if (builder.path != null) {
                    Context ctx = Context.get();
                    String backend = ctx.site().backend().name();
                    this.source = builder.path.replace("." + backend, ".adoc");
                    Page page = ctx.resolvePage(doc, this.source);
                    if (page == null) {
                        boolean strict = ctx.strictXRef();
                        String msg = String.format("Unresolved cross-reference: %s, document: %s", this.source, doc.source());
                        if (strict) {
                            throw new RenderingException(msg);
                        }
                        Log.warn((String)msg, (Object[])new Object[0]);
                        page = Page.UNRESOLVED;
                    }
                    this.target = page.target();
                } else {
                    this.source = builder.refId;
                    this.target = null;
                }
                this.hash = builder.fragment;
                if (this.hash != null && (this.target == null || builder.page.target().equals(this.target))) {
                    this.type = "xref_anchor_self";
                    break;
                }
                if (this.hash != null && !this.hash.equals(this.source)) {
                    this.type = "xref_anchor";
                    break;
                }
                this.type = builder.type;
                break;
            }
            case "ref": 
            case "bibref": {
                this.hash = null;
                this.source = null;
                this.target = builder.path;
                this.type = builder.type;
                break;
            }
            default: {
                this.type = "?";
                this.hash = null;
                this.source = null;
                this.target = builder.target;
            }
        }
        this.rel = !builder.options.isEmpty() ? String.join((CharSequence)" ", builder.options) : null;
        this.role = builder.role;
        this.id = builder.id;
        this.text = builder.text;
        this.title = builder.title;
        this.window = builder.window;
    }

    public String rel() {
        return this.rel;
    }

    public String role() {
        return this.role;
    }

    public String source() {
        return this.source;
    }

    public String target() {
        return this.target;
    }

    public String text() {
        return this.text;
    }

    public String title() {
        return this.title;
    }

    public String type() {
        return this.type;
    }

    public String id() {
        return this.id;
    }

    public String window() {
        return this.window;
    }

    @Override
    public Object get(String attr) {
        switch (attr) {
            case "source": {
                return this.source;
            }
            case "target": {
                return this.target;
            }
            case "text": {
                return this.text;
            }
            case "hash": {
                return this.hash;
            }
            case "title": {
                return this.title;
            }
            case "type": {
                return this.type;
            }
            case "id": {
                return this.id;
            }
            case "window": {
                return this.window;
            }
            case "rel": {
                return this.rel;
            }
            case "role": {
                return this.role;
            }
        }
        throw new IllegalArgumentException("Unknown attribute: " + attr);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Page page;
        private String type;
        private String path;
        private String refId;
        private String fragment;
        private String target;
        private String title;
        private String text;
        private String id;
        private String window = "_blank";
        private String role;
        private final List<String> options = new ArrayList<String>();

        private Builder() {
        }

        public Builder page(Page page) {
            this.page = page;
            return this;
        }

        public Builder options(List<String> options) {
            if (options != null) {
                this.options.addAll(options);
            }
            return this;
        }

        public Builder role(String role) {
            this.role = role;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder refId(String refId) {
            this.refId = refId;
            return this;
        }

        public Builder fragment(String fragment) {
            this.fragment = fragment;
            return this;
        }

        public Builder target(String target) {
            this.target = target;
            return this;
        }

        public Builder title(String title) {
            if (title != null) {
                this.title = title;
            }
            return this;
        }

        public Builder text(String text) {
            if (text != null) {
                this.text = text;
            }
            return this;
        }

        public Builder id(String id) {
            if (id != null) {
                this.id = id;
            }
            return this;
        }

        public Builder window(String window) {
            if (window != null) {
                this.window = window;
            }
            return this;
        }

        public Link build() {
            return new Link(this);
        }
    }
}

