/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.sitegen.asciidoctor;

import io.helidon.build.common.logging.Log;
import io.helidon.build.maven.sitegen.Context;
import io.helidon.build.maven.sitegen.asciidoctor.AsciidocRenderingException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.asciidoctor.log.LogHandler;

final class AsciidocLogHandler
implements LogHandler {
    private static final String INVALID_REF = "possible invalid reference";
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean();
    private final Supplier<Collection<String>> frames;

    AsciidocLogHandler(Supplier<Collection<String>> frames) {
        this.frames = frames;
    }

    public void log(org.asciidoctor.log.LogRecord logRecord) {
        Context ctx = Context.get();
        int failOn = ctx.failOn();
        String message = logRecord.getMessage();
        if (logRecord.getSeverity().ordinal() >= failOn || message.startsWith(INVALID_REF)) {
            ctx.error(new AsciidocLoggedException(message, this.frames.get()));
            return;
        }
        switch (logRecord.getSeverity()) {
            case DEBUG: {
                Log.debug((String)message, (Object[])new Object[0]);
                break;
            }
            case WARN: {
                Log.warn((String)message, (Object[])new Object[0]);
                break;
            }
            case FATAL: 
            case ERROR: {
                Log.error((String)message, (Object[])new Object[0]);
                break;
            }
            default: {
                Log.info((String)message, (Object[])new Object[0]);
            }
        }
    }

    static void init() {
        if (!INITIALIZED.get()) {
            Logger asciidoctorLogger = Logger.getLogger("asciidoctor");
            asciidoctorLogger.setUseParentHandlers(false);
            asciidoctorLogger.addHandler(new Handler(){

                @Override
                public void publish(LogRecord record) {
                }

                @Override
                public void flush() {
                }

                @Override
                public void close() throws SecurityException {
                }
            });
            INITIALIZED.set(true);
        }
    }

    static final class AsciidocLoggedException
    extends AsciidocRenderingException {
        private AsciidocLoggedException(String msg, Collection<String> frames) {
            super(msg, frames);
        }
    }
}

