/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.sitegen.freemarker;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import io.helidon.build.maven.sitegen.freemarker.ContentNodeHashModel;
import io.helidon.build.maven.sitegen.models.Page;
import java.io.IOException;
import java.util.Map;
import org.asciidoctor.ast.ContentNode;

abstract class ContentNodeDirective
implements TemplateDirectiveModel {
    ContentNodeDirective() {
    }

    public final void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        TemplateModel dataModel = env.getDataModel().get("this");
        if (!(dataModel instanceof ContentNodeHashModel)) {
            throw new TemplateModelException("Data model is not a ContentNodeHashModel");
        }
        ContentNode node = ((ContentNodeHashModel)dataModel).getContentNode();
        if (node == null) {
            throw new TemplateModelException("'this' has a null content-node");
        }
        if (body == null) {
            throw new TemplateModelException("Body is null");
        }
        this.doExecute(node, params, body);
    }

    abstract void doExecute(ContentNode var1, Map<?, ?> var2, TemplateDirectiveBody var3) throws TemplateException, IOException;

    Page page(ContentNode node) throws TemplateModelException {
        Object page = node.getDocument().getAttribute((Object)"page");
        if (page instanceof Page) {
            return (Page)page;
        }
        throw new TemplateModelException("Unable to get page instance");
    }
}

