/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.sitegen.freemarker;

import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import io.helidon.build.common.logging.Log;
import io.helidon.build.maven.sitegen.Context;
import io.helidon.build.maven.sitegen.RenderingException;
import io.helidon.build.maven.sitegen.freemarker.ObjectWrapper;
import io.helidon.build.maven.sitegen.freemarker.SimpleMethodModel;
import io.helidon.build.maven.sitegen.models.Link;
import io.helidon.build.maven.sitegen.models.Page;
import java.util.Objects;
import java.util.stream.Collectors;
import org.asciidoctor.ast.ContentNode;
import org.asciidoctor.ast.PhraseNode;

public final class HelperHashModel
implements TemplateHashModel {
    private final ObjectWrapper objectWrapper;
    private volatile Page page;

    HelperHashModel(ObjectWrapper objectWrapper) {
        this.objectWrapper = objectWrapper;
    }

    private void setPage(ContentNode node) {
        this.page = (Page)Objects.requireNonNull(node.getDocument().getAttribute((Object)"page"), "page is null!");
    }

    public String imageUri(ContentNode node, String declaredPath) {
        if (node != null) {
            this.setPage(node);
            String imageUri = node.imageUri(declaredPath);
            if (!imageUri.contains("://")) {
                Context ctx = Context.get();
                String target = ctx.outputDir().resolve(imageUri).normalize().toString();
                if (!ctx.resolvedAssets().contains(target)) {
                    boolean strict = ctx.strictImages();
                    String msg = String.format("Image not found! path: %s, document: %s", target, this.page.source());
                    if (strict) {
                        throw new RenderingException(msg);
                    }
                    Log.warn((String)msg, (Object[])new Object[0]);
                }
            }
            return imageUri;
        }
        return null;
    }

    public Link link(PhraseNode node) {
        if (node != null) {
            this.setPage((ContentNode)node);
            return Link.builder().page(this.page).path((String)node.getAttribute((Object)"path")).refId((String)node.getAttribute((Object)"refid")).fragment((String)node.getAttribute((Object)"fragment")).title((String)node.getAttribute((Object)"title")).target(node.getTarget()).window((String)node.getAttribute((Object)"window")).options(node.getAttributes().keySet().stream().filter(k -> k.endsWith("-option")).map(k -> k.substring(0, k.length() - "-option".length())).collect(Collectors.toList())).type(node.getType()).text(node.getText()).role(node.getRole()).id(node.getId()).build();
        }
        return null;
    }

    public TemplateModel get(String key) throws TemplateModelException {
        if (SimpleMethodModel.hasMethodWithName(this, key)) {
            return new SimpleMethodModel((BeansWrapper)this.objectWrapper, this, key);
        }
        return null;
    }

    public boolean isEmpty() {
        return false;
    }
}

