/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.sitegen.asciidoctor;

import io.helidon.build.common.FileUtils;
import io.helidon.build.common.LazyValue;
import io.helidon.build.common.Strings;
import io.helidon.build.common.VirtualFileSystem;
import io.helidon.build.common.logging.Log;
import io.helidon.build.maven.sitegen.Config;
import io.helidon.build.maven.sitegen.Context;
import io.helidon.build.maven.sitegen.asciidoctor.AsciidocConverter;
import io.helidon.build.maven.sitegen.asciidoctor.AsciidocExtensionRegistry;
import io.helidon.build.maven.sitegen.asciidoctor.AsciidocLogHandler;
import io.helidon.build.maven.sitegen.asciidoctor.AsciidocPageRenderer;
import io.helidon.build.maven.sitegen.models.Page;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Attributes;
import org.asciidoctor.AttributesBuilder;
import org.asciidoctor.Options;
import org.asciidoctor.SafeMode;
import org.asciidoctor.ast.Document;
import org.asciidoctor.log.LogHandler;

public class AsciidocEngine {
    public static final String DEFAULT_IMAGESDIR = "./images";
    private final String backend;
    private final List<String> libraries;
    private final Map<String, Object> attributes;
    private final String imagesDir;
    private final LazyValue<Asciidoctor> asciidoctor;
    private final AsciidocLogHandler logHandler;
    private final AsciidocPageRenderer pageRenderer;
    private volatile String sourcePath;
    private volatile AsciidocConverter converter;

    private AsciidocEngine(Builder builder) {
        this.backend = Strings.requireValid((String)builder.backend, (String)"backend is invalid!");
        this.attributes = builder.attributes;
        this.libraries = builder.libraries;
        this.imagesDir = builder.imagesDir;
        this.pageRenderer = new AsciidocPageRenderer(this);
        this.logHandler = new AsciidocLogHandler(this::frames);
        this.asciidoctor = new LazyValue(this::initAdoc);
    }

    private Asciidoctor initAdoc() {
        Asciidoctor adoc = Asciidoctor.Factory.create();
        AsciidocLogHandler.init();
        adoc.registerLogHandler((LogHandler)this.logHandler);
        adoc.requireLibraries(this.libraries);
        AsciidocExtensionRegistry.create(this.backend).register(adoc);
        return adoc;
    }

    private Collection<String> frames() {
        return this.converter != null ? this.converter.frames() : List.of(this.sourcePath + ":0");
    }

    void converter(AsciidocConverter converter) {
        this.converter = converter;
    }

    public AsciidocPageRenderer pageRenderer() {
        return this.pageRenderer;
    }

    public List<String> libraries() {
        return this.libraries;
    }

    public Map<String, Object> attributes() {
        return this.attributes;
    }

    public String imagesDir() {
        return this.imagesDir;
    }

    public void render(Page page, Context ctx, Path target) {
        Objects.requireNonNull(page, "page is null!");
        Objects.requireNonNull(ctx, "ctx is null!");
        Map<String, Page> extraAttributes = Map.of("page", page);
        Path outputDir = ctx.outputDir();
        Path sourceDir = ctx.sourceDir();
        Path source = FileUtils.requireFile((Path)sourceDir.resolve(page.source()));
        AttributesBuilder attrsBuilder = Attributes.builder().attributes(this.attributes).skipFrontMatter(true).experimental(true).attributes(extraAttributes);
        if (this.imagesDir != null) {
            attrsBuilder.imagesDir(this.imagesDir);
            attrsBuilder.attribute("imagesoutdir", (Object)outputDir.resolve(this.imagesDir).toString());
        }
        String outDir = AsciidocEngine.relativePath(source, VirtualFileSystem.unwrap((Path)outputDir));
        attrsBuilder.attribute("outdir", (Object)outDir);
        Options options = Options.builder().attributes(attrsBuilder.build()).sourcemap(true).safe(SafeMode.UNSAFE).headerFooter(false).eruby("").baseDir(source.getParent().toFile()).option("parse", (Object)false).backend(this.backend).build();
        this.sourcePath = sourceDir.relativize(source).toString();
        Log.info((String)"rendering %s to %s", (Object[])new Object[]{this.sourcePath, outputDir.relativize(target)});
        try (Asciidoctor asciidoctor = (Asciidoctor)this.asciidoctor.get();){
            Document document = asciidoctor.loadFile(source.toFile(), options);
            try {
                String output = document.convert();
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
                Files.writeString(target, (CharSequence)output, new OpenOption[0]);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
    }

    public static AsciidocEngine create(String backend, Config config) {
        return AsciidocEngine.builder().backend(backend).config(config).build();
    }

    public static AsciidocEngine create(String backend) {
        return AsciidocEngine.builder().backend(backend).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static String relativePath(Path sourceDir, Path source) {
        return Strings.normalizePath((Object)sourceDir.relativize(source));
    }

    public static class Builder
    implements Supplier<AsciidocEngine> {
        private final List<String> libraries = new ArrayList<String>();
        private final Map<String, Object> attributes = new HashMap<String, Object>();
        private String imagesDir = "./images";
        private String backend;

        private Builder() {
        }

        public Builder backend(String backend) {
            this.backend = backend;
            return this;
        }

        public Builder libraries(List<String> libraries) {
            if (libraries != null) {
                this.libraries.addAll(libraries);
            }
            return this;
        }

        public Builder library(String library) {
            if (library != null) {
                this.libraries.add(library);
            }
            return this;
        }

        public Builder attributes(Map<String, Object> attributes) {
            if (attributes != null) {
                this.attributes.putAll(attributes);
            }
            return this;
        }

        public Builder attribute(String key, Object value) {
            if (key != null && value != null) {
                this.attributes.put(key, value);
            }
            return this;
        }

        public Builder imagesDir(String imagesDir) {
            this.imagesDir = imagesDir;
            return this;
        }

        public Builder config(Config config) {
            this.libraries.addAll(config.get("libraries").asList(String.class).orElseGet(List::of));
            this.attributes.putAll(config.get("attributes").asMap().orElseGet(Map::of));
            this.imagesDir = config.get("images-dir").asString().orElse(null);
            return this;
        }

        public AsciidocEngine build() {
            return new AsciidocEngine(this);
        }

        @Override
        public AsciidocEngine get() {
            return this.build();
        }
    }
}

