/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.sitegen.asciidoctor;

import io.helidon.build.common.FileUtils;
import io.helidon.build.common.LazyValue;
import io.helidon.build.common.logging.Log;
import io.helidon.build.maven.sitegen.asciidoctor.AsciidocLogHandler;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Attributes;
import org.asciidoctor.Options;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;
import org.asciidoctor.ast.Document;
import org.asciidoctor.extension.IncludeProcessor;
import org.asciidoctor.extension.PreprocessorReader;

final class AsciidocHeaders {
    private static final ThreadLocal<Deque<List<Document>>> REGISTRY = ThreadLocal.withInitial(ArrayDeque::new);
    private static final IncludeProcessorImpl PROCESSOR = new IncludeProcessorImpl();
    private static final LazyValue<Asciidoctor> ADOC = new LazyValue(() -> AsciidocHeaders.initAdoc(PROCESSOR));
    private static final LazyValue<Asciidoctor> RAW_ADOC = new LazyValue(() -> AsciidocHeaders.initAdoc(null));

    private AsciidocHeaders() {
    }

    static Map<String, Object> readDocumentHeader(Path source) {
        FileUtils.requireFile((Path)source);
        Path baseDir = source.getParent();
        List<String> headerLines = AsciidocHeaders.headerLines(source);
        HashMap headerMap = new HashMap();
        headerLines.stream().filter(line -> line.startsWith("= ")).map(line -> line.substring(2).trim()).findFirst().ifPresent(h1 -> headerMap.put("h1", h1));
        String header = String.join((CharSequence)System.lineSeparator(), headerLines);
        try {
            HashMap hashMap;
            block10: {
                ArrayList documents = new ArrayList();
                REGISTRY.get().push(documents);
                Log.debug((String)("Reading header " + source), (Object[])new Object[0]);
                Asciidoctor asciidoctor = (Asciidoctor)ADOC.get();
                try {
                    Options options = AsciidocHeaders.options(Map.of()).baseDir(baseDir.toFile()).build();
                    Document doc = asciidoctor.load(header, options);
                    headerMap.putAll(doc.getAttributes());
                    for (Document includedDoc : documents) {
                        headerMap.putAll(includedDoc.getAttributes());
                    }
                    hashMap = headerMap;
                    if (asciidoctor == null) break block10;
                }
                catch (Throwable throwable) {
                    if (asciidoctor != null) {
                        try {
                            asciidoctor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                asciidoctor.close();
            }
            return hashMap;
        }
        finally {
            REGISTRY.get().pop();
        }
    }

    private static List<String> headerLines(Path source) {
        List<String> list;
        block8: {
            Stream<String> lines = Files.lines(source);
            try {
                list = lines.takeWhile(line -> !line.startsWith("==")).collect(Collectors.toList());
                if (lines == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            lines.close();
        }
        return list;
    }

    private static Asciidoctor initAdoc(IncludeProcessor processor) {
        Asciidoctor asciidoctor = Asciidoctor.Factory.create();
        if (processor != null) {
            asciidoctor.javaExtensionRegistry().includeProcessor(processor);
        }
        AsciidocLogHandler.init();
        return asciidoctor;
    }

    private static OptionsBuilder options(Map<String, Object> attributes) {
        return Options.builder().attributes(Attributes.builder().attributes(attributes).skipFrontMatter(true).experimental(true).build()).safe(SafeMode.UNSAFE).headerFooter(false).eruby("");
    }

    private static final class IncludeProcessorImpl
    extends IncludeProcessor {
        private IncludeProcessorImpl() {
        }

        public boolean handles(String target) {
            return true;
        }

        public void process(Document doc, PreprocessorReader reader, String target, Map<String, Object> attributes) {
            try {
                Log.debug((String)("Processing include " + target), (Object[])new Object[0]);
                Path targetPath = Path.of(target, new String[0]);
                if (!Files.exists(targetPath, new LinkOption[0])) {
                    Log.warn((String)("include file not found: " + target), (Object[])new Object[0]);
                    return;
                }
                String source = Files.readString(targetPath);
                try (Asciidoctor asciidoctor = (Asciidoctor)RAW_ADOC.get();){
                    Options options = AsciidocHeaders.options(doc.getAttributes()).build();
                    Document included = asciidoctor.load(source, options);
                    List<Document> documents = REGISTRY.get().peek();
                    if (documents == null) {
                        throw new IllegalStateException("include context is not set!");
                    }
                    documents.add(included);
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
    }
}

