/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.sitegen.freemarker;

import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import io.helidon.build.maven.sitegen.RenderingException;
import io.helidon.build.maven.sitegen.freemarker.ObjectWrapper;
import io.helidon.build.maven.sitegen.freemarker.SimpleMethodModel;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import org.asciidoctor.ast.ContentNode;

final class ContentNodeHashModel
implements TemplateHashModel {
    private final ObjectWrapper objectWrapper;
    private final ContentNode contentNode;

    ContentNodeHashModel(ObjectWrapper objectWrapper, ContentNode node) {
        this.objectWrapper = Objects.requireNonNull(objectWrapper);
        this.contentNode = Objects.requireNonNull(node);
    }

    public ContentNode getContentNode() {
        return this.contentNode;
    }

    public TemplateModel get(String key) throws TemplateModelException {
        if ("this".equals(key)) {
            return this;
        }
        Object getterName = "get";
        getterName = (String)getterName + Character.toUpperCase(key.charAt(0));
        getterName = (String)getterName + key.substring(1);
        Method getterMethod = null;
        for (Method m : this.contentNode.getClass().getMethods()) {
            if (!((String)getterName).equals(m.getName()) || m.getParameterCount() != 0) continue;
            getterMethod = m;
            break;
        }
        if (getterMethod != null) {
            try {
                return this.objectWrapper.wrap(getterMethod.invoke((Object)this.contentNode, new Object[0]));
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof RenderingException) {
                    throw (RenderingException)cause;
                }
                throw new TemplateModelException(String.format("Error during getter invocation: node=%s, method=%s", this.contentNode, getterMethod.getName()), ex);
            }
        }
        if (SimpleMethodModel.hasMethodWithName(this.contentNode, key)) {
            return new SimpleMethodModel((BeansWrapper)this.objectWrapper, this.contentNode, key);
        }
        return null;
    }

    public boolean isEmpty() {
        return false;
    }
}

