/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.sitegen.spi;

import io.helidon.build.common.Strings;
import io.helidon.build.maven.sitegen.Backend;
import io.helidon.build.maven.sitegen.BasicBackendProvider;
import io.helidon.build.maven.sitegen.Config;
import io.helidon.build.maven.sitegen.VuetifyBackendProvider;
import java.util.List;
import java.util.ServiceLoader;

public interface BackendProvider {
    public static final List<BackendProvider> BUILTINS = List.of(new BasicBackendProvider(), new VuetifyBackendProvider());

    public Backend create(String var1, Config var2);

    public static Backend get(Config config) {
        String name = config.get("name").asString().orElse(null);
        return BackendProvider.get(name, config);
    }

    public static Backend get(String name, Config config) {
        Backend backend;
        Strings.requireValid((String)name, (String)"name is invalid!");
        for (BackendProvider provider : BUILTINS) {
            backend = provider.create(name, config);
            if (backend == null) continue;
            return backend;
        }
        for (BackendProvider provider : ServiceLoader.load(BackendProvider.class)) {
            backend = provider.create(name, config);
            if (backend == null) continue;
            return backend;
        }
        throw new IllegalArgumentException("backend: " + name + "not found");
    }
}

