/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.sitegen;

import io.helidon.build.common.FileUtils;
import io.helidon.build.common.SubstitutionVariables;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public final class Config {
    private final Object value;
    private final Config parent;
    private final SubstitutionVariables substitutions;

    private Config(Object value, Map<String, String> properties) {
        this.value = value;
        this.parent = null;
        this.substitutions = SubstitutionVariables.of(properties);
    }

    private Config(Object value, Config parent) {
        this.value = value;
        this.parent = parent;
        this.substitutions = parent.substitutions;
    }

    public Config parent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == this;
    }

    public Config get(String key) {
        Object v = this.value instanceof Map ? ((Map)this.value).get(key) : null;
        return new Config(v, this);
    }

    public boolean containsKey(String key) {
        if (this.value instanceof Map) {
            return ((Map)this.value).containsKey(key);
        }
        return false;
    }

    public Optional<Config> asOptional() {
        return this.value == null ? Optional.empty() : Optional.of(this);
    }

    public Optional<String> asString() {
        return this.as(String.class);
    }

    public Optional<Boolean> asBoolean() {
        return this.as(Boolean.class);
    }

    public <T> Optional<T> as(Function<Object, T> mapper) {
        if (this.value == null) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(mapper.apply(this.value));
        }
        catch (Throwable ex) {
            throw new MappingException(ex);
        }
    }

    public <T> Optional<T> as(Class<T> type) {
        return this.as((Object o) -> this.convert(o, type));
    }

    public Optional<List<Config>> asNodeList() {
        if (this.value == null) {
            return Optional.empty();
        }
        if (this.value instanceof List) {
            return Optional.of(((List)this.value).stream().map(e -> new Config(e, this)).collect(Collectors.toList()));
        }
        throw new MappingException(this.value.getClass(), List.class);
    }

    public Optional<List<String>> asList() {
        return this.asList(Function.identity());
    }

    public <T> Optional<List<T>> asList(Class<T> type) {
        return this.asList((String e) -> this.convert(e, type));
    }

    public <T> Optional<List<T>> asList(Function<String, T> mapper) {
        if (this.value == null) {
            return Optional.empty();
        }
        if (this.value instanceof List) {
            ArrayList values = new ArrayList();
            this.traverse((prefix, entry) -> {
                Object value = mapper.apply((String)entry.getValue());
                values.add(value);
            });
            return Optional.of(values);
        }
        throw new MappingException(this.value.getClass(), List.class);
    }

    public Optional<Map<String, String>> asMap() {
        return this.asMap(Function.identity());
    }

    public <T> Optional<Map<String, T>> asMap(Class<T> type) {
        return this.asMap((String e) -> this.convert(e, type));
    }

    public <T> Optional<Map<String, T>> asMap(Function<String, T> mapper) {
        if (this.value == null) {
            return Optional.empty();
        }
        if (this.value instanceof Map) {
            TreeMap values = new TreeMap();
            this.traverse((prefix, entry) -> {
                String key = prefix.isEmpty() ? (String)entry.getKey() : prefix + "." + (String)entry.getKey();
                values.put(key, mapper.apply((String)entry.getValue()));
            });
            return Optional.of(values);
        }
        throw new MappingException(this.value.getClass(), Map.class);
    }

    public static Config create(Object value, Map<String, String> properties) {
        return new Config(value, properties);
    }

    public static Config create(String path, Class<?> clazz, Map<String, String> properties) {
        return Config.create(FileUtils.resourceAsPath((String)path, clazz), properties);
    }

    public static Config create(Path path, Map<String, String> properties) {
        try {
            return Config.create(Files.newBufferedReader(path), properties);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static Config create(Reader reader, Map<String, String> properties) {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
        return Config.create(yaml.loadAs(reader, Object.class), properties);
    }

    private void traverse(BiConsumer<String, Map.Entry<String, String>> visitLeaf) {
        ArrayDeque path = new ArrayDeque();
        this.traverse((k, v) -> {
            if (k != null) {
                path.addLast(this.substitutions.resolve(k));
            }
        }, (k, v) -> {
            if (!path.isEmpty()) {
                path.removeLast();
            }
        }, (k, v) -> {
            String prefix = String.join((CharSequence)".", path);
            visitLeaf.accept(prefix, Map.entry(this.substitutions.resolve(k), this.substitutions.resolve(v)));
        });
    }

    private void traverse(BiConsumer<String, Object> visitNode, BiConsumer<String, Object> postVisitNode, BiConsumer<String, String> visitLeaf) {
        ArrayDeque parents = new ArrayDeque();
        ArrayDeque<String> keys = new ArrayDeque<String>();
        ArrayDeque<Object> stack = new ArrayDeque<Object>();
        stack.push(this.value);
        while (!stack.isEmpty()) {
            ListIterator it;
            Object parent = parents.peek();
            String key = (String)keys.peek();
            Object node = stack.peek();
            if (parent == node) {
                postVisitNode.accept(key, node);
                stack.pop();
                if (stack.isEmpty()) continue;
                parents.pop();
                keys.pop();
                continue;
            }
            if (node instanceof Map) {
                List entries = List.copyOf(((Map)node).entrySet());
                it = entries.listIterator(entries.size());
                while (it.hasPrevious()) {
                    Map.Entry previous = it.previous();
                    stack.push(previous.getValue());
                    keys.push(previous.getKey().toString());
                }
                parents.push(node);
                visitNode.accept(key, node);
                continue;
            }
            if (node instanceof List) {
                List list = (List)node;
                it = list.listIterator(list.size());
                while (it.hasPrevious()) {
                    keys.push(String.valueOf(it.previousIndex()));
                    stack.push(it.previous());
                }
                parents.push(node);
                visitNode.accept(key, node);
                continue;
            }
            visitLeaf.accept(key, String.valueOf(node));
            stack.pop();
            keys.pop();
        }
    }

    private <T> T convert(Object obj, Class<T> type) {
        String value = this.substitutions.resolve(String.valueOf(obj));
        if (type.equals(String.class)) {
            return (T)value;
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return (T)Boolean.valueOf(value);
        }
        if (type.equals(Character.class) || type.equals(Character.TYPE)) {
            return (T)Character.valueOf(value.charAt(0));
        }
        if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
            return (T)Byte.valueOf(value);
        }
        if (type.equals(Short.class) || type.equals(Short.TYPE)) {
            return (T)Short.valueOf(value);
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return (T)Integer.valueOf(value);
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return (T)Long.valueOf(value);
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return (T)Float.valueOf(value);
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return (T)Double.valueOf(value);
        }
        throw new MappingException(obj.getClass(), type);
    }

    public static class MappingException
    extends RuntimeException {
        private MappingException(Class<?> actual, Class<?> expected) {
            super(String.format("Cannot get a %s as %s", actual.getSimpleName(), expected.getSimpleName()));
        }

        private MappingException(Throwable cause) {
            super(cause);
        }
    }
}

