/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.sitegen;

import io.helidon.build.common.FileUtils;
import io.helidon.build.common.SourcePath;
import io.helidon.build.common.Strings;
import io.helidon.build.maven.sitegen.Backend;
import io.helidon.build.maven.sitegen.Config;
import io.helidon.build.maven.sitegen.Context;
import io.helidon.build.maven.sitegen.RenderingException;
import io.helidon.build.maven.sitegen.freemarker.FreemarkerEngine;
import io.helidon.build.maven.sitegen.freemarker.TemplateSession;
import io.helidon.build.maven.sitegen.models.Nav;
import io.helidon.build.maven.sitegen.models.Page;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class VuetifyBackend
extends Backend {
    public static final String BACKEND_NAME = "vuetify";
    private final Nav nav;
    private final Map<String, String> theme;
    private final Path staticFiles;
    private final String home;
    private final List<String> releases;

    private VuetifyBackend(Builder builder) {
        super(BACKEND_NAME);
        this.theme = builder.theme;
        this.nav = builder.nav;
        this.home = Strings.requireValid((String)builder.home, (String)"home is invalid!");
        this.releases = builder.releases;
        this.staticFiles = FileUtils.resourceAsPath((String)"/files/vuetify", VuetifyBackend.class);
    }

    public Nav nav() {
        return this.nav;
    }

    public Map<String, String> theme() {
        return this.theme;
    }

    public String home() {
        return this.home;
    }

    public List<String> releases() {
        return this.releases;
    }

    @Override
    public void generate(Context ctx) {
        List<Object> navRoutes;
        Nav resolvedNav;
        Map<String, Page> pages = ctx.pages();
        Page home = pages.get(new SourcePath(this.home).asString(false));
        if (home == null) {
            throw new IllegalStateException("unable to get home page");
        }
        if (this.nav != null) {
            resolvedNav = this.resolveNav(ctx);
            navRoutes = resolvedNav.items().stream().flatMap(n -> n.items().isEmpty() ? Stream.of(n) : n.items().stream()).flatMap(n -> n.items().isEmpty() ? Stream.of(n) : n.items().stream()).flatMap(n -> n.items().isEmpty() ? Stream.of(n) : n.items().stream()).map(Nav::to).filter(Objects::nonNull).collect(Collectors.toList());
        } else {
            resolvedNav = null;
            navRoutes = List.of();
        }
        Path pagesDir = ctx.outputDir().resolve("pages");
        try {
            Files.createDirectories(pagesDir, new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        ctx.processPages(pagesDir, "js");
        ctx.copyStaticAssets();
        TemplateSession session = ctx.templateSession();
        Map<String, Page> pagesByRoute = pages.values().stream().map(p -> Map.entry(p.target(), p)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        ArrayList<String> routes = new ArrayList<String>();
        routes.add(home.target());
        navRoutes.forEach(r -> {
            if (!routes.contains(r)) {
                routes.add((String)r);
            }
        });
        pagesByRoute.keySet().forEach(r -> {
            if (!routes.contains(r)) {
                routes.add((String)r);
            }
        });
        Map<String, String> allBindings = session.vueBindings().bindings();
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("searchEntries", session.searchIndex().entries());
        model.put("navRoutes", navRoutes);
        model.put("allRoutes", routes);
        model.put("customLayoutEntries", session.customLayouts().mappings());
        model.put("pages", pagesByRoute);
        model.put("metadata", home.metadata());
        model.put("nav", resolvedNav);
        model.put("header", ctx.site().header());
        model.put("theme", this.theme);
        model.put("home", home);
        model.put("releases", this.releases);
        model.put("bindings", allBindings);
        FreemarkerEngine freemarker = ctx.site().engine().freemarker();
        Path outputDir = ctx.outputDir();
        for (Page page : pages.values()) {
            String bindings = allBindings.get(page.source());
            if (bindings == null) continue;
            HashMap<String, Object> bindingsModel = new HashMap<String, Object>(model);
            bindingsModel.put("bindings", bindings);
            bindingsModel.put("page", page);
            String path = "pages/" + page.target() + "_custom.js";
            freemarker.renderFile("custom_bindings", path, bindingsModel, outputDir);
        }
        freemarker.renderFile("search_index", "main/search-index.json", model, outputDir);
        freemarker.renderFile("index", "index.html", model, outputDir);
        freemarker.renderFile("config", "main/config.js", model, outputDir);
        Context.copyResources(this.staticFiles, ctx.outputDir());
    }

    private Nav resolveNav(Context ctx) {
        Map<String, Page> pages = ctx.pages();
        ArrayDeque<Nav.Builder> builders = new ArrayDeque<Nav.Builder>();
        ArrayDeque<Nav> stack = new ArrayDeque<Nav>();
        stack.push(this.nav);
        builders.push(Nav.builder());
        Nav.Builder parent = null;
        while (!stack.isEmpty() && !builders.isEmpty()) {
            Nav node = (Nav)stack.peek();
            Nav.Builder builder = (Nav.Builder)builders.peek();
            List<Nav> items = node.items();
            if (parent != builder && !items.isEmpty()) {
                ListIterator<Nav> it = items.listIterator(items.size());
                while (it.hasPrevious()) {
                    Nav item = it.previous();
                    builders.push(Nav.builder(builder).type(item.type()));
                    stack.push(item);
                }
                continue;
            }
            Nav.Builder nodeParent = builder.parent();
            builder.title(node.title()).to(node.to()).href(node.href()).pathprefix(node.pathprefix()).glyph(node.glyph());
            Nav.Type type = node.type();
            if (type == Nav.Type.PAGE) {
                String source = node.source();
                if (source != null) {
                    try {
                        Page page = Nav.resolvePage(pages, source);
                        builder.title(page.metadata().title(), false).source(source).to(page.target());
                    }
                    catch (IllegalArgumentException ex) {
                        ctx.error(new RenderingException(ex.getMessage()));
                    }
                }
            } else if (type == Nav.Type.MENU) {
                for (String source : node.sources()) {
                    try {
                        String resolvedSource = new SourcePath(node.dir(), source).asString(false);
                        Page page = Nav.resolvePage(pages, resolvedSource);
                        builder.item(Nav.Type.PAGE, p -> p.title(page.metadata().title()).source(page.source()).to(page.target()));
                    }
                    catch (IllegalArgumentException ex) {
                        ctx.error(new RenderingException(ex.getMessage()));
                    }
                }
                List<Page> resolvedPages = node.resolvePages(pages.values());
                if (!resolvedPages.isEmpty()) {
                    resolvedPages.sort(Comparator.comparing(Page::source));
                }
                for (Page page : resolvedPages) {
                    builder.item(Nav.Type.PAGE, p -> p.title(page.metadata().title()).source(page.source()).to(page.target()));
                }
            }
            if (nodeParent != null) {
                parent = nodeParent.item(builder);
                builders.pop();
            }
            stack.pop();
        }
        return ((Nav.Builder)builders.pop()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements Supplier<VuetifyBackend> {
        private final Map<String, String> theme = new HashMap<String, String>();
        private Nav nav;
        private String home;
        private final List<String> releases = new ArrayList<String>();

        public Builder theme(Map<String, String> theme) {
            if (theme != null) {
                this.theme.putAll(theme);
            }
            return this;
        }

        public Builder nav(Nav nav) {
            this.nav = nav;
            return this;
        }

        public Builder nav(Supplier<Nav> supplier) {
            this.nav = supplier.get();
            return this;
        }

        public Builder home(String home) {
            this.home = home;
            return this;
        }

        public Builder releases(List<String> releases) {
            if (releases != null) {
                this.releases.addAll(releases);
            }
            return this;
        }

        public Builder releases(String ... releases) {
            if (releases != null) {
                this.releases.addAll(Arrays.asList(releases));
            }
            return this;
        }

        public Builder config(Config config) {
            this.theme.putAll(config.get("theme").asMap().orElseGet(Map::of));
            this.home = config.get("homePage").asString().orElse(null);
            this.releases.addAll(config.get("releases").asList().orElseGet(List::of));
            this.nav = config.get("navigation").asOptional().map(Nav::create).orElse(null);
            return this;
        }

        public VuetifyBackend build() {
            return new VuetifyBackend(this);
        }

        @Override
        public VuetifyBackend get() {
            return this.build();
        }
    }
}

