/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.sitegen.freemarker;

import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateNotFoundException;
import freemarker.template.Version;
import io.helidon.build.common.Strings;
import io.helidon.build.common.logging.Log;
import io.helidon.build.maven.sitegen.Config;
import io.helidon.build.maven.sitegen.Context;
import io.helidon.build.maven.sitegen.RenderingException;
import io.helidon.build.maven.sitegen.freemarker.HelperHashModel;
import io.helidon.build.maven.sitegen.freemarker.ObjectWrapper;
import io.helidon.build.maven.sitegen.freemarker.PassthroughFixDirective;
import io.helidon.build.maven.sitegen.freemarker.TemplateLoader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;

public class FreemarkerEngine {
    private static final Version FREEMARKER_VERSION = Configuration.VERSION_2_3_23;
    private static final ObjectWrapper OBJECT_WRAPPER = new ObjectWrapper(FREEMARKER_VERSION);
    private final String backend;
    private final Map<String, String> directives;
    private final Map<String, String> model;
    private final Configuration freemarker;

    private FreemarkerEngine(Builder builder) {
        this.backend = Strings.requireValid((String)builder.backend, (String)"backend is invalid!");
        this.directives = builder.directives;
        this.model = builder.model;
        this.freemarker = new Configuration(FREEMARKER_VERSION);
        this.freemarker.setTemplateLoader((freemarker.cache.TemplateLoader)new TemplateLoader());
        this.freemarker.setDefaultEncoding("UTF-8");
        this.freemarker.setObjectWrapper((freemarker.template.ObjectWrapper)OBJECT_WRAPPER);
        this.freemarker.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.freemarker.setLogTemplateExceptions(false);
    }

    public Map<String, String> directives() {
        return this.directives;
    }

    public Map<String, String> model() {
        return this.model;
    }

    public void renderFile(String template, String targetPath, Map<String, Object> model, Path outputDir) throws RenderingException {
        try {
            String rendered = this.renderString(template, model);
            Path target = outputDir.resolve(targetPath);
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            Files.writeString(target, (CharSequence)rendered, new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public String renderString(String template, Object model) throws RenderingException {
        Context ctx = Context.get();
        String path = this.backend + "/" + template;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Template tpl = this.freemarker.getTemplate(path);
            OutputStreamWriter writer = new OutputStreamWriter(baos);
            Log.debug((String)"Applying template: %s", (Object[])new Object[]{path});
            Environment env = tpl.createProcessingEnvironment(model, (Writer)writer);
            for (Map.Entry<String, TemplateDirectiveModel> directive : ctx.templateSession().directives().entrySet()) {
                env.setVariable(directive.getKey(), (TemplateModel)directive.getValue());
            }
            env.setVariable("helper", (TemplateModel)new HelperHashModel(OBJECT_WRAPPER));
            env.setVariable("passthroughfix", (TemplateModel)new PassthroughFixDirective());
            env.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
            env.setLogTemplateExceptions(false);
            env.process();
            return baos.toString(StandardCharsets.UTF_8);
        }
        catch (TemplateNotFoundException ex) {
            boolean strict = ctx.strictTemplates();
            String msg = String.format("Unable to find template: %s", path);
            if (strict) {
                throw new RenderingException(msg);
            }
            Log.warn((String)msg, (Object[])new Object[0]);
            return "";
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        catch (TemplateException ex) {
            throw new FreemarkerRenderingException(path, ex);
        }
    }

    public static FreemarkerEngine create(String backend, Config config) {
        return FreemarkerEngine.builder().backend(backend).config(config).build();
    }

    public static FreemarkerEngine create(String backend) {
        return FreemarkerEngine.builder().backend(backend).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, String> directives = new HashMap<String, String>();
        private final Map<String, String> model = new HashMap<String, String>();
        private String backend;

        public Builder backend(String backend) {
            this.backend = backend;
            return this;
        }

        public Builder directives(Map<String, String> directives) {
            if (directives != null) {
                this.directives.putAll(directives);
            }
            return this;
        }

        public Builder model(Map<String, String> model) {
            if (model != null) {
                this.model.putAll(model);
            }
            return this;
        }

        public Builder config(Config config) {
            this.directives.putAll(config.get("directives").asMap().orElseGet(Map::of));
            this.model.putAll(config.get("model").asMap().orElseGet(Map::of));
            return this;
        }

        public FreemarkerEngine build() {
            return new FreemarkerEngine(this);
        }
    }

    public static final class FreemarkerRenderingException
    extends RenderingException {
        FreemarkerRenderingException(String template, Throwable cause) {
            super(String.format("An error occurred while rendering '%s'", template), RenderingException.cause(cause));
        }
    }
}

