/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.sitegen.models;

import io.helidon.build.common.SourcePath;
import io.helidon.build.maven.sitegen.Config;
import io.helidon.build.maven.sitegen.Model;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;

public abstract class SourcePathFilter
implements Model {
    private final List<String> includes;
    private final List<String> excludes;

    protected SourcePathFilter(AbstractBuilder<?, ?> builder) {
        this.includes = builder.includes;
        this.excludes = builder.excludes;
    }

    public List<String> includes() {
        return this.includes;
    }

    public List<String> excludes() {
        return this.excludes;
    }

    public List<SourcePath> resolvePaths(Collection<SourcePath> paths) {
        if (this.includes.isEmpty()) {
            return List.of();
        }
        return SourcePath.filter(paths, this.includes, this.excludes);
    }

    @Override
    public Object get(String attr) {
        switch (attr) {
            case "includes": {
                return this.includes;
            }
            case "excludes": {
                return this.excludes;
            }
        }
        throw new IllegalArgumentException("Unknown attribute: " + attr);
    }

    public static abstract class AbstractBuilder<T extends AbstractBuilder<T, U>, U extends SourcePathFilter>
    implements Supplier<U> {
        private final List<String> includes = new ArrayList<String>();
        private final List<String> excludes = new ArrayList<String>();

        public List<String> includes() {
            return this.includes;
        }

        public List<String> excludes() {
            return this.excludes;
        }

        public T includes(List<String> includes) {
            if (includes != null) {
                this.includes.addAll(includes);
            }
            return (T)this;
        }

        public T includes(String ... includes) {
            if (includes != null) {
                this.includes.addAll(Arrays.asList(includes));
            }
            return (T)this;
        }

        public T excludes(List<String> excludes) {
            if (excludes != null) {
                this.excludes.addAll(excludes);
            }
            return (T)this;
        }

        public T excludes(String ... excludes) {
            if (excludes != null) {
                this.excludes.addAll(Arrays.asList(excludes));
            }
            return (T)this;
        }

        public T config(Config config) {
            this.includes.addAll(config.get("includes").asList().orElseGet(List::of));
            this.excludes.addAll(config.get("excludes").asList().orElseGet(List::of));
            return (T)this;
        }

        @Override
        public final U get() {
            return this.build();
        }

        public abstract U build();
    }
}

