/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.sitegen;

import io.helidon.build.common.Instance;
import io.helidon.build.common.Strings;
import io.helidon.build.maven.sitegen.Context;
import io.helidon.build.maven.sitegen.Model;
import io.helidon.build.maven.sitegen.PageRenderer;
import java.nio.file.Path;
import java.util.List;

public abstract class Backend
implements Model {
    private final String name;
    private final Instance<List<PageRenderer>> renderers;

    protected Backend(String name) {
        this.name = Strings.requireValid((String)name, (String)"name");
        this.renderers = new Instance(this::renderers);
    }

    public String name() {
        return this.name;
    }

    public void generate(Context ctx) {
    }

    public List<PageRenderer> renderers() {
        return List.of(Context.get().site().engine().asciidoc().pageRenderer());
    }

    public PageRenderer renderer(Path source) {
        for (PageRenderer renderer : (List)this.renderers.instance()) {
            if (!renderer.supports(source)) continue;
            return renderer;
        }
        throw new IllegalArgumentException("no renderer found for: " + source);
    }

    @Override
    public Object get(String attr) {
        throw new IllegalArgumentException("Unknown attribute: " + attr);
    }
}

